set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      0.951557,
      0,
      9,
      1.037580,
      NULL,
      NULL,
      '43',
      NULL,
      26,
      NULL,
      '1220243',
      1.492373,
      0,
      2,
      NULL,
      '4243',
      3,
      0,
      NULL,
      NULL,
      ' 0-21-1982',
      57.061488,
      60,
      NULL,
      1,
      2.136776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 7-1986',
      NULL,
      ' 5-15-1996',
      NULL,
      2.766734,
      0,
      NULL,
      0,
      2,
      NULL,
      0.353681,
      NULL,
      257.453134,
      3,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.497394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      0,
      2,
      0,
      0,
      3,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.275476,
      NULL,
      NULL,
      0.384228,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.387321,
      1.930411,
      2.567723,
      NULL,
      2.042973,
      3.410817,
      3,
      1,
      0.742722,
      1,
      1.819733,
      NULL,
      3,
      0.338245,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.168958,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      5,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5.369657,
      1,
      1,
      1,
      0,
      1.708552,
      NULL,
      0.453349,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      5,
      1,
      NULL,
      5,
      0,
      NULL,
      5,
      0,
      2,
      4,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      200.271683,
      NULL,
      NULL,
      0.076093,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      1.509275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.406612,
      0,
      NULL,
      1.633215,
      1,
      NULL,
      0.541346,
      NULL,
      1.312333,
      1.653099,
      3,
      1.144437,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.154544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.714519,
      1.396533,
      1,
      1,
      0,
      NULL,
      NULL,
      1.107438,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      1,
      2,
      0,
      3,
      1,
      2,
      1.663264,
      3.993876,
      NULL,
      3.376622,
      0.018405,
      NULL,
      3,
      0,
      1.564805,
      2,
      0,
      0,
      2,
      0.620066,
      1.405371,
      0,
      0.721028,
      1,
      1.038252,
      0.059262,
      8,
      5.938603,
      5,
      6,
      NULL,
      5.893603,
      3.470916,
      0.534112,
      3.734887,
      1.488068,
      2,
      36.644596,
      1,
      2,
      NULL,
      NULL,
      28,
      3.166964,
      0,
      3,
      1,
      '12220',
      '',
      '',
      1.019178,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.823868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.805391,
      0.339897,
      NULL,
      1.948358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.717268,
      3.223002,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.488369,
      NULL,
      2,
      1,
      1,
      0.836243,
      1,
      0,
      NULL,
      4.086147,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.965101,
      NULL,
      NULL,
      NULL,
      1,
      2.821490,
      1.353459,
      0.328032,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3.887173,
      NULL,
      2,
      2.964581,
      1.814221,
      0,
      0,
      0.880427,
      1.153125,
      NULL,
      NULL,
      NULL,
      1.865691,
      0.396333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.317897,
      2.583419,
      0.049231,
      0,
      0.675219,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.436420,
      2,
      3.538787,
      NULL,
      NULL,
      NULL,
      7,
      3,
      3,
      1.027225,
      0,
      NULL,
      0.848927,
      NULL,
      NULL,
      4.319201,
      1.411381,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6.528851,
      3.356772,
      4,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      0.249554,
      NULL,
      NULL,
      3.623022,
      1.572290,
      0.956781,
      1.516868,
      NULL,
      NULL,
      5.603067,
      2,
      NULL,
      0.208568,
      3,
      1.037744,
      1,
      0.556080,
      NULL,
      0.306079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.351437,
      2,
      5.806435,
      2,
      NULL,
      NULL,
      0.257089,
      3,
      0,
      1.571219,
      NULL,
      0,
      1.331849,
      NULL,
      0.909881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.903608,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.047836,
      NULL,
      NULL,
      2.078818,
      NULL,
      NULL,
      1.205834,
      NULL,
      NULL,
      1.744041,
      NULL,
      NULL,
      1.867401,
      1,
      1.722775,
      1.633114,
      0,
      0,
      1,
      NULL,
      NULL,
      1.500847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.384257,
      NULL,
      NULL,
      NULL,
      0.699739,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.604761,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.540814,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.036635,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.161090,
      2.323306,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298711,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.304477,
      NULL,
      NULL,
      0,
      NULL,
      1.747336,
      67.333149,
      1,
      NULL,
      1.069557,
      0,
      1,
      1,
      1.978183,
      0.512253,
      NULL,
      1.742146,
      0,
      0.020915,
      0,
      NULL,
      0,
      0,
      0.739721,
      0,
      1.087430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      10,
      3.652882,
      4,
      NULL,
      NULL,
      1,
      1.787681,
      0.333522,
      1.352757,
      0,
      1.010914,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915794,
      0.262588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150443,
      NULL,
      NULL,
      1.361832,
      NULL,
      1.714094,
      0,
      NULL,
      1.985149,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356849,
      1,
      NULL,
      0.014310,
      0,
      NULL,
      1,
      1.976447,
      1.090544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531007,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      0,
      1.374821,
      NULL,
      2,
      NULL,
      51.456355,
      NULL,
      NULL,
      3.737217,
      NULL,
      '',
      '',
      0.337092,
      NULL,
      NULL,
      '',
      0.756801,
      '',
      NULL,
      NULL);
commit;
end;
/


