set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      0.167380,
      0,
      NULL,
      1.388862,
      2,
      3.185634,
      NULL,
      '41032321',
      NULL,
      44,
      '4031121',
      0,
      1.317310,
      1,
      2,
      '0011',
      0,
      1,
      NULL,
      NULL,
      ' 2- 1-1979',
      59.017356,
      270.702327,
      NULL,
      2.132327,
      4.832676,
      ' 6-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 5-1982',
      ' 1- 1-1982',
      '10- 0-2000',
      1,
      2.007761,
      3.352741,
      2.171393,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      3.785804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      2,
      NULL,
      3,
      3,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.703127,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0.684518,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      5,
      0,
      NULL,
      3,
      4.991812,
      3.003618,
      '10- 2-2002',
      0.746146,
      ' 6-10-1984',
      188,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664987,
      NULL,
      2,
      0.193958,
      1.274438,
      0,
      3.881133,
      11.752475,
      4,
      1,
      1,
      2,
      2.038806,
      0.859878,
      1.775025,
      1,
      0.757211,
      7,
      NULL,
      6.823728,
      5.760358,
      NULL,
      NULL,
      1,
      0.269196,
      NULL,
      0.474704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305447,
      NULL,
      0.671764,
      1.767536,
      0.776486,
      0,
      NULL,
      3.206459,
      19,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.362839,
      2,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      3,
      3,
      3,
      3,
      2,
      1.210208,
      2,
      5.838242,
      0,
      0.706745,
      3.772570,
      NULL,
      0.355583,
      0,
      NULL,
      1,
      1,
      1,
      0.291502,
      0,
      0.663773,
      2,
      0,
      NULL,
      0,
      NULL,
      8,
      5,
      1,
      NULL,
      NULL,
      7.160588,
      0,
      2,
      NULL,
      NULL,
      2,
      0.003162,
      8,
      NULL,
      NULL,
      28,
      NULL,
      4.911012,
      1,
      '14013',
      '',
      '',
      1,
      '',
      '',
      NULL,
      4.146819,
      '3101',
      '4423',
      '',
      1,
      5.740285,
      183.967992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.988825,
      NULL,
      0.735485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.248641,
      0.133023,
      NULL,
      NULL,
      1.125889,
      NULL,
      NULL,
      2,
      1,
      0,
      0.683648,
      1,
      1.867038,
      NULL,
      1.568112,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      1.958034,
      7.981147,
      3.191875,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.823925,
      NULL,
      NULL,
      NULL,
      0.251119,
      NULL,
      NULL,
      0.015787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323353,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.877652,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852616,
      NULL,
      NULL,
      0.198421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918968,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.538716,
      NULL,
      NULL,
      0.119946,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.749216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.555357,
      0,
      1,
      0.867324,
      0.421919,
      0,
      NULL,
      0,
      4,
      1,
      1,
      2.702658,
      1.013765,
      1.978720,
      0,
      0,
      1,
      0.299927,
      0.738747,
      0.505239,
      1.103551,
      1.866717,
      1.506222,
      8,
      NULL,
      NULL,
      1.832894,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1.443618,
      1.173423,
      2,
      1,
      0.949901,
      0.048133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965365,
      NULL,
      NULL,
      1.860605,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.928959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.338487,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.788296,
      NULL,
      NULL,
      0.489596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.756827,
      2,
      1.581878,
      0.513623,
      1.275634,
      0.973624,
      NULL,
      NULL,
      1,
      3.354858,
      NULL,
      15.729691,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.551004,
      NULL,
      NULL,
      NULL,
      3.938699,
      1.300008,
      0.178695,
      NULL,
      0.007606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.773582,
      NULL,
      2.622701,
      NULL,
      2.894907,
      NULL,
      2.388261,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.187314,
      NULL,
      0.377044,
      NULL,
      1,
      0.685317,
      1,
      NULL,
      0,
      NULL,
      0.388972,
      NULL,
      0,
      1.230012,
      1.459339,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1.286793,
      0,
      NULL,
      NULL,
      1.598169,
      1,
      NULL,
      0,
      1.003160,
      0.161142,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.423291,
      NULL,
      NULL,
      NULL,
      2.137078,
      0.344965,
      NULL,
      1,
      0.555850,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.587482,
      NULL,
      0,
      NULL,
      14.406176,
      1.620168,
      0.971606,
      1.429388,
      1.429189,
      NULL,
      0,
      1,
      0,
      1,
      1.517238,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      3.925632,
      2.141228,
      0.776550,
      1,
      1.299396,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.820882,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.880580,
      NULL,
      0,
      NULL,
      0,
      1,
      3.095492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927138,
      NULL,
      0.654697,
      NULL,
      1,
      NULL,
      NULL,
      0.037006,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.777358,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.773199,
      1,
      NULL,
      0,
      1.385750,
      0.244789,
      0,
      0.568563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.930548,
      NULL,
      1.257615,
      0.094392,
      0,
      NULL,
      1.637725,
      3,
      NULL,
      1.264358,
      1,
      1.717479,
      NULL,
      1.542773,
      0.576287,
      0,
      2.407300,
      0,
      0.677638,
      1.745588,
      1.845118,
      NULL,
      NULL,
      1.904030,
      NULL,
      1.812979,
      NULL,
      1,
      0.778330,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.109907,
      NULL,
      NULL,
      NULL,
      0.292971,
      0,
      3,
      3.506433,
      1,
      NULL,
      1.102944,
      3,
      0.405648,
      2.061956,
      1.410132,
      3,
      0,
      2.336646,
      0,
      0.752527,
      NULL,
      NULL,
      0,
      0.659681,
      1,
      NULL,
      1.902316,
      NULL,
      0.337420,
      1,
      0.493758,
      1,
      0.370635,
      0.222275,
      0.772799,
      1.166749,
      7,
      0.469959,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200699,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      4,
      NULL,
      NULL,
      NULL,
      67.226460,
      32,
      1,
      4,
      2.790816,
      '23404',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '0240',
      '2000',
      NULL);
commit;
end;
/


