set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      '3012',
      2.600362,
      1,
      NULL,
      NULL,
      ' 2-29-1975',
      24.214270,
      NULL,
      3,
      1.764502,
      1.803362,
      ' 9-28-2001',
      42,
      2,
      113,
      20,
      NULL,
      ' 6-12-1993',
      ' 0- 4-1982',
      ' 9-10-2003',
      2.631392,
      1,
      1.416584,
      1.711318,
      1.726076,
      NULL,
      1,
      0.745986,
      0.531479,
      13,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      19,
      1,
      5,
      0,
      0.142274,
      0,
      1,
      1,
      1,
      1.986020,
      1.883924,
      2,
      0.724511,
      1,
      0,
      NULL,
      4,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      3,
      0,
      1,
      1,
      1,
      2,
      1,
      0,
      NULL,
      0,
      1.380943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      0,
      0,
      0,
      1,
      2,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.676875,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      0,
      2,
      3,
      1,
      2,
      1,
      0,
      1,
      4,
      1,
      NULL,
      3,
      3,
      5,
      5,
      5,
      4,
      NULL,
      5,
      3,
      1,
      5.442722,
      2.184372,
      NULL,
      132,
      NULL,
      5.377989,
      0.992182,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7.053407,
      2,
      NULL,
      3,
      0.195969,
      2,
      0.681336,
      0.195208,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.045295,
      0,
      2.877172,
      0,
      3,
      1.215888,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.992296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.682328,
      1.640490,
      0,
      1.365889,
      2.715272,
      0,
      1.083083,
      NULL,
      3.223926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.096376,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      0.960689,
      1.617334,
      0,
      0.574524,
      3.307589,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0.625837,
      8,
      11,
      3,
      3,
      1.270413,
      3,
      1,
      0,
      1,
      NULL,
      1.921477,
      2,
      66,
      1,
      3.466872,
      NULL,
      NULL,
      50,
      48,
      2,
      NULL,
      3,
      '41234',
      '',
      NULL,
      0.470934,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      15,
      12.622063,
      32,
      2.870891,
      5,
      4,
      2,
      NULL,
      3.469292,
      NULL,
      1.728494,
      0.166469,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.886700,
      NULL,
      1,
      0.574754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.970817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186099,
      3.879354,
      NULL,
      1.717240,
      NULL,
      NULL,
      3.153409,
      8.501084,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867990,
      2,
      0,
      1.745536,
      0.575984,
      0,
      1.040293,
      1.471613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649047,
      3,
      3.781233,
      0.909746,
      3.831493,
      NULL,
      0.350689,
      0.403004,
      1.137246,
      1,
      2.639992,
      0,
      1,
      1.319465,
      1.767769,
      0,
      NULL,
      NULL,
      0.406923,
      NULL,
      NULL,
      2,
      0.882064,
      0,
      NULL,
      4.960701,
      NULL,
      0,
      1.039779,
      NULL,
      NULL,
      NULL,
      3,
      1.077602,
      1.764456,
      1.432549,
      0.085545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.574907,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5.234301,
      NULL,
      0.026392,
      NULL,
      NULL,
      0.364794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.746775,
      2.590867,
      0.903078,
      NULL,
      NULL,
      NULL,
      1,
      5.500603,
      NULL,
      4,
      7.403633,
      NULL,
      0,
      4.950669,
      2,
      3,
      1.819233,
      0,
      2,
      NULL,
      1,
      0,
      1.881342,
      NULL,
      2.699470,
      4.432799,
      6,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.364933,
      NULL,
      3.662469,
      3.730260,
      1.832405,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      4,
      3,
      3,
      NULL,
      1.945319,
      0,
      0.413539,
      0.141202,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.620026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.156445,
      NULL,
      NULL,
      0.174459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.836875,
      0,
      1,
      3,
      1,
      3,
      1,
      4.923464,
      NULL,
      0.157012,
      1,
      9,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0.080574,
      NULL,
      NULL,
      NULL,
      0.606746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.195889,
      NULL,
      1.651930,
      1,
      3,
      NULL,
      1,
      0.922530,
      2.885241,
      NULL,
      0.881366,
      1,
      NULL,
      NULL,
      NULL,
      0.801472,
      2,
      NULL,
      0,
      2.005889,
      0,
      NULL,
      NULL,
      1.378212,
      NULL,
      NULL,
      2.529217,
      1,
      3.723856,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      3.403656,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.933813,
      1,
      12.773441,
      NULL,
      NULL,
      10.690484,
      0.982366,
      NULL,
      1.653209,
      NULL,
      NULL,
      NULL,
      2,
      16.007618,
      5,
      0,
      2.754393,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.781095,
      3,
      2,
      0.391172,
      1,
      4,
      1.491941,
      8.047242,
      0.209559,
      NULL,
      1,
      1,
      0.056188,
      NULL,
      1.543475,
      0.570357,
      NULL,
      0.490946,
      1,
      0.792177,
      NULL,
      0.507747,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      8,
      2,
      1,
      NULL,
      1,
      12.890781,
      NULL,
      2.913238,
      1,
      NULL,
      0.017710,
      1.422277,
      0.852301,
      1.794305,
      3.794414,
      3,
      3.005502,
      1.207766,
      NULL,
      1.280444,
      NULL,
      1,
      0,
      1,
      2.743607,
      2.440387,
      3,
      0,
      1,
      1,
      2,
      0,
      1.922679,
      1.716262,
      1,
      1.623161,
      0.665814,
      2.813706,
      0.594149,
      NULL,
      3,
      2.220679,
      NULL,
      1.324280,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.600042,
      0,
      0,
      1,
      0.531793,
      1.788218,
      NULL,
      NULL,
      1,
      NULL,
      2.191684,
      2,
      1,
      NULL,
      3,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      0.666786,
      NULL,
      NULL,
      1,
      0.099162,
      0,
      1,
      0,
      5,
      1.384193,
      NULL,
      NULL,
      0.496213,
      NULL,
      1.051853,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      89.686389,
      102.084029,
      0,
      NULL,
      NULL,
      '43044',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


