set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      4,
      3.956070,
      2.030719,
      NULL,
      6.354009,
      0.038247,
      '342',
      '21311420',
      43,
      NULL,
      '4022132',
      0.913692,
      1,
      0,
      1,
      '1102',
      5,
      1.592552,
      NULL,
      NULL,
      NULL,
      24.168461,
      24,
      NULL,
      1,
      NULL,
      ' 5-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9-17-1988',
      ' 5- 3-1984',
      NULL,
      3.374281,
      NULL,
      0.979120,
      2.541435,
      0,
      1.954719,
      1,
      1.160580,
      0,
      3,
      5,
      5.835424,
      9.282956,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.120079,
      NULL,
      NULL,
      0.583118,
      0.084051,
      0,
      0.422046,
      1,
      1,
      NULL,
      1.230097,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      4,
      0,
      1,
      NULL,
      2,
      NULL,
      10,
      3,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.834084,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      2.827134,
      1,
      0,
      1.558428,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      5.066964,
      2,
      0,
      2.114175,
      0.162025,
      NULL,
      NULL,
      0.817190,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      0,
      1.671502,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      2,
      1,
      NULL,
      2,
      NULL,
      4,
      NULL,
      NULL,
      2,
      1,
      NULL,
      5,
      2,
      2,
      2,
      NULL,
      NULL,
      2,
      3,
      1,
      5.327233,
      NULL,
      '11- 5-1993',
      4.460312,
      ' 3-27-1977',
      15,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      4,
      3,
      0,
      2,
      3.793146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      2.278410,
      22.877664,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139830,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.566817,
      0,
      0,
      0.313548,
      0.427746,
      15.923405,
      0.805896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874472,
      1,
      1,
      2,
      1,
      0,
      1,
      3,
      0,
      3,
      0,
      2,
      2,
      NULL,
      1,
      2,
      1,
      NULL,
      3.339497,
      NULL,
      1,
      1.815661,
      0.780704,
      1,
      0,
      0,
      0,
      1,
      3.793133,
      1.804117,
      1,
      3,
      6,
      NULL,
      4,
      0,
      0,
      5,
      1.660076,
      NULL,
      2,
      NULL,
      0.676741,
      39,
      3,
      0,
      38,
      NULL,
      37,
      12,
      2,
      5,
      6,
      '32240',
      '31103',
      '12001',
      0,
      '00032',
      '',
      '',
      0.283623,
      NULL,
      '23144',
      '',
      0,
      18,
      3.767768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407267,
      3,
      1,
      3.474427,
      0,
      0.410546,
      0.423244,
      NULL,
      NULL,
      0,
      1.238833,
      0,
      0.945242,
      0,
      0.871067,
      1.051456,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      18.621479,
      3.305451,
      1,
      0.738302,
      0.854358,
      NULL,
      0.182980,
      1.058459,
      0,
      0.940257,
      NULL,
      1,
      1.979408,
      NULL,
      1.128688,
      NULL,
      0.822075,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.207757,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787631,
      NULL,
      1,
      NULL,
      1.830587,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.739044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454137,
      NULL,
      1.328018,
      NULL,
      0.922016,
      NULL,
      1,
      NULL,
      0.638332,
      0.879050,
      1.462939,
      NULL,
      0.694023,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.919426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.338174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.624926,
      0.369503,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1.304434,
      1,
      2.821310,
      3,
      NULL,
      2,
      1,
      0,
      0,
      1.919997,
      NULL,
      3,
      3.138345,
      NULL,
      3.845036,
      NULL,
      NULL,
      NULL,
      1.891704,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.674419,
      1,
      NULL,
      0,
      1.336025,
      NULL,
      0,
      0,
      NULL,
      1,
      1.647866,
      NULL,
      2.003539,
      1.377271,
      1.866807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3,
      0,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      1.167341,
      6,
      '33000',
      '20404',
      NULL,
      NULL,
      '23000',
      '',
      NULL,
      1,
      '22133',
      '34321',
      NULL);
commit;
end;
/


