set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8609467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '4022324',
      NULL,
      0,
      2,
      2,
      '2144',
      3.064234,
      NULL,
      5.013363,
      20,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      ' 7-21-1991',
      NULL,
      2.022000,
      327.829978,
      102,
      0,
      NULL,
      NULL,
      ' 3- 2-1980',
      2,
      1.112525,
      1,
      NULL,
      NULL,
      2.785018,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.756111,
      NULL,
      74.817747,
      NULL,
      3,
      7.182604,
      0,
      0,
      2.471001,
      NULL,
      NULL,
      0,
      0.287241,
      NULL,
      0,
      0,
      0.738316,
      NULL,
      0,
      138.702309,
      1,
      3,
      2,
      2.364934,
      4,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      5.926749,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.733224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      0,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.448228,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      1,
      1,
      2,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      0,
      4,
      1,
      4,
      0,
      NULL,
      1.351765,
      ' 5- 2-1985',
      184.191621,
      ' 8-14-1993',
      398,
      1.144666,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.531565,
      1.510554,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.103016,
      0,
      1.684145,
      0.501885,
      3.901474,
      2600.284833,
      1,
      1.796110,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2,
      2,
      2,
      0,
      3,
      NULL,
      3,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      18.428999,
      1.955699,
      1.294510,
      3.990750,
      1.776291,
      1.487539,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.809311,
      1,
      16.047238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836786,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      18,
      NULL,
      33,
      1,
      51,
      NULL,
      124.048925,
      3,
      1.408836,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.683348,
      3.955623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.093648,
      1.887452,
      3,
      0.176827,
      1.233115,
      1.453442,
      2,
      1,
      1.525014,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5.972991,
      7.945112,
      0.267674,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.537019,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.856434,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.649030,
      2.191152,
      0.742738,
      NULL,
      0.415323,
      0,
      1,
      0.992147,
      NULL,
      1.658945,
      1.877008,
      NULL,
      NULL,
      1.316190,
      0.855969,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      19,
      1.681918,
      3.080994,
      NULL,
      1.586877,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.916458,
      0.198362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.517232,
      0,
      1,
      NULL,
      NULL,
      NULL,
      6.859820,
      3,
      NULL,
      NULL,
      NULL,
      0.915982,
      NULL,
      NULL,
      1.815346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.794026,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768530,
      NULL,
      NULL,
      0.856384,
      NULL,
      NULL,
      3.926934,
      3.741634,
      0,
      3,
      1,
      0,
      NULL,
      2.008198,
      2.717889,
      NULL,
      2,
      2.066483,
      3,
      NULL,
      NULL,
      1.389514,
      3,
      1.215203,
      0,
      2.523345,
      1,
      NULL,
      NULL,
      2.794558,
      6,
      NULL,
      NULL,
      3.327090,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.192156,
      NULL,
      0,
      NULL,
      NULL,
      8.916009,
      3,
      NULL,
      NULL,
      2.034309,
      3.521836,
      2.414864,
      NULL,
      4,
      0.585047,
      1,
      0,
      0.326741,
      0.211162,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.531622,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.474041,
      NULL,
      NULL,
      1.835212,
      NULL,
      NULL,
      1.323952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.156609,
      NULL,
      NULL,
      0.260452,
      NULL,
      NULL,
      4.030685,
      NULL,
      NULL,
      1.924925,
      0.339902,
      1,
      1.871768,
      1.583840,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.927650,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.126314,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.142323,
      NULL,
      NULL,
      NULL,
      1.248208,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.402239,
      NULL,
      NULL,
      NULL,
      1.656164,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.574317,
      NULL,
      NULL,
      NULL,
      1,
      85.302419,
      28,
      1.498024,
      NULL,
      NULL,
      0.147308,
      NULL,
      NULL,
      NULL,
      2,
      1.619083,
      1,
      NULL,
      NULL,
      1.878804,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036222,
      11748.741414,
      1095,
      1,
      3,
      1.600660,
      NULL,
      0.039790,
      1,
      1,
      0.985476,
      1.105503,
      0,
      1,
      3,
      1.415354,
      0.574588,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.864595,
      NULL,
      3,
      NULL,
      1.650212,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.967276,
      NULL,
      2.407380,
      34.095940,
      17.328214,
      1.625637,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.468319,
      NULL,
      1.600007,
      NULL,
      0.250954,
      NULL,
      1.908646,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.787621,
      NULL,
      0.064805,
      0,
      1.423996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.367390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592568,
      3.753108,
      NULL,
      0.468817,
      NULL,
      0.803391,
      NULL,
      NULL,
      NULL,
      0.659772,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.792846,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.571932,
      0.911347,
      3.739555,
      22.325692,
      0.523521,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      0.084615,
      5,
      0.206622,
      3,
      11,
      NULL,
      3.380281,
      1.847286,
      1.391919,
      0.269045,
      NULL,
      3,
      NULL,
      NULL,
      1.756124,
      11.451387,
      NULL,
      0.788379,
      0.210097,
      NULL,
      1.734229,
      1,
      NULL,
      1.599172,
      1,
      NULL,
      1,
      0.072137,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.188827,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      3.566845,
      NULL,
      NULL,
      NULL,
      0.391047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218513,
      NULL,
      0.138274,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      3,
      1.408815,
      1.425271,
      64.874022,
      NULL,
      2,
      1.457267,
      0,
      NULL,
      '32200',
      '34102',
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


