set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9804955';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.884889,
      0.873639,
      1,
      1.252910,
      1.288237,
      2,
      3.346137,
      2,
      NULL,
      '32004232',
      NULL,
      NULL,
      '4330102',
      NULL,
      1,
      3,
      0,
      '0223',
      5,
      1.187046,
      NULL,
      NULL,
      ' 0-29-1996',
      NULL,
      177,
      NULL,
      1.652397,
      1.815827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 5-15-1990',
      NULL,
      NULL,
      1.466175,
      1.597690,
      1,
      2,
      2.983068,
      1.717291,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.202418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1.440008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.569735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061571,
      1,
      1.688049,
      1,
      0.754420,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.713339,
      0.592659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      1.416511,
      1.238535,
      NULL,
      1,
      21.508824,
      NULL,
      0.194479,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.051017,
      1,
      1,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      1,
      2,
      2,
      0,
      1,
      4.384935,
      1.832328,
      0.050212,
      0,
      0.624695,
      1.407762,
      1.777989,
      1,
      0,
      1.663635,
      0.066476,
      1.916532,
      0,
      0.315904,
      3.180713,
      1.762596,
      9,
      9.259144,
      4,
      3.976092,
      6,
      3.918087,
      3.286493,
      3,
      1,
      NULL,
      NULL,
      3.641812,
      11.174836,
      1,
      3.451196,
      NULL,
      NULL,
      13,
      31,
      4,
      2,
      NULL,
      '34011',
      '',
      '',
      1.820499,
      '',
      '',
      '',
      4.839500,
      '02122',
      '4322',
      '',
      2,
      33,
      88.800447,
      14,
      1,
      9,
      5.534061,
      4,
      NULL,
      NULL,
      0.944234,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067235,
      NULL,
      NULL,
      1.267867,
      NULL,
      NULL,
      1.274258,
      NULL,
      NULL,
      1.403524,
      NULL,
      NULL,
      0.341306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.706213,
      NULL,
      NULL,
      1,
      1,
      1.805744,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.419023,
      0,
      0.730588,
      NULL,
      1.119960,
      0.748226,
      NULL,
      NULL,
      0.692290,
      1,
      0,
      2,
      0,
      0,
      2.282288,
      0.338935,
      0.625721,
      NULL,
      1,
      1,
      2,
      0,
      3.632957,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.619739,
      1.515677,
      1,
      1,
      1.856787,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.137236,
      NULL,
      NULL,
      3.789967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886851,
      NULL,
      NULL,
      3.445047,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828392,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.460052,
      NULL,
      NULL,
      4.835294,
      1.852529,
      1,
      NULL,
      NULL,
      NULL,
      0.835158,
      0.826906,
      3.227541,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      1.330531,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.241850,
      2.967877,
      1,
      6,
      1.556869,
      0.725032,
      NULL,
      NULL,
      NULL,
      3.519506,
      1,
      3,
      0,
      0.452894,
      0,
      0.452554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.519284,
      NULL,
      NULL,
      0.619042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.586317,
      3,
      2.120691,
      3.488081,
      0,
      NULL,
      1.084875,
      5,
      NULL,
      1,
      0.663892,
      30,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.066097,
      NULL,
      NULL,
      NULL,
      1.325727,
      NULL,
      0.290765,
      0.266535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.240978,
      NULL,
      0,
      1,
      2.143464,
      NULL,
      3.258720,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3.136858,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.779626,
      0,
      1.935549,
      NULL,
      1,
      0.444730,
      1,
      NULL,
      0.629248,
      1,
      0.923481,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.513360,
      1,
      NULL,
      NULL,
      NULL,
      0.995308,
      NULL,
      NULL,
      1,
      NULL,
      7.653191,
      NULL,
      0,
      0.982908,
      NULL,
      NULL,
      2,
      1,
      5,
      1,
      0.460260,
      15.804076,
      0.176071,
      NULL,
      24,
      5.103663,
      0.036337,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.462983,
      1,
      0.858834,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.330675,
      1,
      1.599359,
      1,
      1,
      1.045383,
      1,
      0,
      1,
      1,
      2,
      NULL,
      0.781432,
      1,
      1,
      0,
      1,
      1,
      0.062591,
      0,
      0.149546,
      NULL,
      NULL,
      NULL,
      0.481724,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.630826,
      NULL,
      1,
      NULL,
      1.256768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      2.690572,
      0,
      0,
      1,
      NULL,
      3.558340,
      NULL,
      2,
      1.460392,
      1,
      1,
      0.187419,
      0,
      0,
      NULL,
      0,
      1.998897,
      0,
      1.063323,
      0.906526,
      NULL,
      3.431150,
      NULL,
      1.854185,
      1.946373,
      0.734715,
      NULL,
      1,
      2.649721,
      NULL,
      0,
      0,
      0.267993,
      1.104229,
      0.102294,
      1.603337,
      0.850357,
      0.777461,
      NULL,
      0.769064,
      1.293314,
      3,
      0.438400,
      0.234867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613862,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      4,
      5,
      0,
      NULL,
      NULL,
      8,
      0.573073,
      4,
      1.697855,
      0,
      '04042',
      '0224',
      '',
      0,
      '',
      '',
      '',
      4.334169,
      '32112',
      '2120',
      NULL);
commit;
end;
/


