set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '00',
      NULL,
      35.239612,
      '0213142',
      1.782361,
      1.149739,
      NULL,
      2,
      NULL,
      3.869858,
      0.564641,
      NULL,
      NULL,
      ' 9- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1992',
      ' 8-12-1991',
      ' 2-26-1981',
      0,
      2,
      NULL,
      0.511119,
      0,
      0,
      3,
      1.789933,
      1,
      8,
      0,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      1,
      1,
      1.314587,
      0.388047,
      1,
      NULL,
      1,
      0,
      1.770361,
      0,
      3,
      4,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.563093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      4,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      2.599431,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      4,
      0,
      1,
      3,
      NULL,
      5,
      2,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      4,
      2,
      NULL,
      NULL,
      1,
      3,
      2,
      5,
      5,
      11.294950,
      3,
      ' 0-17-1987',
      NULL,
      NULL,
      13,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      1,
      0.269494,
      NULL,
      0.919666,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329034,
      0.279690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195143,
      NULL,
      0.243698,
      NULL,
      0.313092,
      0.029523,
      0,
      3,
      NULL,
      NULL,
      0.676945,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474227,
      2,
      3,
      2,
      2,
      2,
      2,
      3,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      1.911623,
      0,
      NULL,
      NULL,
      1.625252,
      0,
      1,
      1,
      0.105063,
      0,
      0.138162,
      0,
      1,
      1.409084,
      3.817030,
      0.849123,
      10,
      NULL,
      NULL,
      5,
      4,
      5.409606,
      NULL,
      1,
      NULL,
      3.555018,
      0,
      3,
      NULL,
      NULL,
      3.999110,
      19,
      NULL,
      NULL,
      15,
      1,
      3.617140,
      1,
      '21320',
      NULL,
      '',
      0.932991,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      26.397797,
      4.960998,
      8,
      1.774020,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.993020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.889013,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.485841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.481823,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796763,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173709,
      NULL,
      NULL,
      1.809819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.316542,
      3,
      NULL,
      3.145543,
      NULL,
      3.411291,
      NULL,
      3.715148,
      1,
      1,
      NULL,
      NULL,
      5.973945,
      4.285061,
      0.652364,
      0.632833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815243,
      NULL,
      NULL,
      1.297232,
      NULL,
      NULL,
      1.444796,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.731620,
      NULL,
      NULL,
      0.550634,
      1,
      0.472226,
      1.132531,
      NULL,
      NULL,
      NULL,
      8,
      0,
      0.244108,
      2.982771,
      0.147170,
      1,
      NULL,
      NULL,
      3.527636,
      1,
      1,
      NULL,
      1.232002,
      NULL,
      1,
      NULL,
      0,
      8,
      1,
      8.329589,
      0.536034,
      0.547389,
      2.332387,
      NULL,
      1.603864,
      NULL,
      0,
      2.941260,
      2.978490,
      1.222215,
      NULL,
      NULL,
      NULL,
      1.699045,
      1.504428,
      1.795358,
      6,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.557633,
      0.576719,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107091,
      0,
      0.712218,
      NULL,
      0.638093,
      0.712573,
      1.161414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891944,
      NULL,
      NULL,
      NULL,
      1.461456,
      1,
      1,
      0,
      1.865328,
      0,
      0,
      NULL,
      NULL,
      1.193401,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.596861,
      96.367697,
      5.789501,
      1.726097,
      0,
      0.455814,
      1,
      0,
      0.375372,
      0.102668,
      NULL,
      0.074525,
      1,
      0,
      1,
      1.362813,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.925453,
      0.209383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.238688,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.574925,
      NULL,
      NULL,
      NULL,
      NULL,
      3.386613,
      1,
      3,
      NULL,
      2,
      NULL,
      147.294727,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5,
      0,
      4,
      0,
      NULL,
      NULL,
      3.746133,
      1.231823,
      1,
      0,
      0.387661,
      NULL,
      1.971881,
      1.360890,
      NULL,
      0,
      0.838864,
      NULL,
      0.740015,
      NULL,
      NULL,
      1.730935,
      NULL,
      NULL,
      1.140337,
      3.993847,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.864947,
      NULL,
      NULL,
      1,
      1.137654,
      NULL,
      0.490477,
      0.100984,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431808,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      7,
      1,
      NULL,
      NULL,
      66.766083,
      122,
      0,
      5.305017,
      5.929587,
      NULL,
      '00101',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


