set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1344320',
      NULL,
      1.082811,
      5,
      3,
      '2433',
      1,
      1.702283,
      NULL,
      NULL,
      ' 7- 8-1988',
      43.703891,
      NULL,
      NULL,
      NULL,
      1,
      '10- 5-1975',
      7,
      NULL,
      296,
      NULL,
      1,
      NULL,
      NULL,
      '11-23-1993',
      NULL,
      0.432021,
      2,
      0,
      0.107367,
      0.391587,
      0,
      0.431773,
      NULL,
      NULL,
      NULL,
      3,
      2.691529,
      41.694446,
      0.855451,
      0,
      18,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0.266108,
      3,
      1.570916,
      1,
      0.587045,
      2,
      6,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      0,
      0.699208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.078436,
      0.648948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.273649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      NULL,
      2,
      2,
      1,
      0,
      1,
      2,
      0,
      0,
      5.495109,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      3,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      1,
      1,
      5,
      0,
      2,
      5,
      1,
      NULL,
      1,
      1.931569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.309176,
      1,
      NULL,
      NULL,
      NULL,
      2.317967,
      0,
      1.433492,
      1.932351,
      1,
      1,
      1.145742,
      NULL,
      NULL,
      NULL,
      1.534965,
      1.083213,
      1.261027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.768973,
      NULL,
      NULL,
      0,
      NULL,
      1.059441,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.774771,
      0.887752,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      3,
      1.019275,
      3.866543,
      1.650406,
      3,
      NULL,
      0.231403,
      5,
      NULL,
      1.431157,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      5,
      1.093240,
      NULL,
      11.017162,
      4,
      9.051849,
      9.138612,
      7.738723,
      4.506159,
      2,
      6.353055,
      1,
      2,
      2.456422,
      NULL,
      2,
      0.830886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260947,
      1,
      NULL,
      '',
      '',
      3.530149,
      '44303',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      18.315372,
      78.558656,
      0.178912,
      0.126088,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221594,
      1,
      3.269805,
      1.422403,
      NULL,
      NULL,
      1.264129,
      NULL,
      NULL,
      2,
      2.382943,
      3,
      1.254748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094325,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.458457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.970433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.904841,
      1,
      0.684863,
      0.236658,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.645195,
      5.643984,
      1.432647,
      NULL,
      NULL,
      3.064308,
      1.168761,
      NULL,
      NULL,
      NULL,
      1.218261,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.990439,
      NULL,
      NULL,
      1.824884,
      NULL,
      NULL,
      1.703886,
      1.199454,
      0.629124,
      NULL,
      5.897741,
      0.382118,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.095337,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.357784,
      0.582329,
      3.139824,
      1.153891,
      0,
      1,
      1.895354,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.670842,
      2.881520,
      NULL,
      NULL,
      1.945912,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319578,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.533795,
      0.522285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.419887,
      0,
      1,
      1.028542,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.858892,
      2.960188,
      0,
      0,
      1.935448,
      0,
      0.198377,
      1,
      1.192155,
      1,
      1.180843,
      1,
      0.968881,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0.193993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      2.549521,
      NULL,
      2.009952,
      2,
      0,
      3.047098,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.308083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.334405,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658507,
      NULL,
      0.052880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901774,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.534556,
      NULL,
      NULL,
      9,
      69,
      NULL,
      1,
      0.750094,
      '',
      '',
      '',
      NULL,
      '32040',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


