set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813575';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1,
      7,
      0.182779,
      7,
      0.578968,
      NULL,
      0,
      '324',
      '02021424',
      45.592335,
      3.810444,
      '3143240',
      0,
      1.841929,
      2,
      2,
      NULL,
      2.816123,
      1.823148,
      NULL,
      NULL,
      ' 0- 5-1983',
      25.967144,
      9,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1980',
      2.114956,
      0.935465,
      2,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      0.447437,
      1.254928,
      NULL,
      1.232823,
      3,
      2,
      3,
      2.714913,
      0,
      NULL,
      1,
      2,
      0,
      0,
      2,
      2,
      4,
      5,
      1,
      4,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.884713,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      2,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0.549160,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2,
      0,
      NULL,
      2,
      1,
      0,
      0,
      1,
      1,
      4,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      5,
      5,
      0,
      4,
      0,
      0,
      NULL,
      ' 1-22-1987',
      162.151813,
      NULL,
      214.981819,
      1.497827,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.888524,
      NULL,
      1.118572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.395067,
      NULL,
      NULL,
      NULL,
      NULL,
      4.889602,
      5,
      0.703095,
      NULL,
      NULL,
      0,
      5,
      0.512381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      2.538130,
      NULL,
      1.203107,
      0.432486,
      1.539270,
      NULL,
      NULL,
      1.278742,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.210239,
      3,
      2,
      2,
      3,
      2,
      3,
      0,
      2,
      1,
      1,
      3,
      3,
      NULL,
      3,
      NULL,
      NULL,
      4,
      NULL,
      0.039616,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.538106,
      '32312',
      NULL,
      '',
      NULL,
      '41203',
      '',
      NULL,
      0.320102,
      '',
      NULL,
      NULL,
      2,
      NULL,
      184.992175,
      7.454415,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      0.521490,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.626448,
      NULL,
      1,
      NULL,
      0,
      2,
      3,
      NULL,
      2,
      NULL,
      1.151508,
      2.837103,
      2,
      1,
      0,
      0.511506,
      1,
      0.476479,
      11.323940,
      0.784345,
      2.404757,
      0,
      0.625781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.516485,
      0,
      1,
      0,
      0.271336,
      1,
      0.051150,
      0.139765,
      NULL,
      0,
      0,
      3.725385,
      1.023467,
      NULL,
      1,
      0,
      0.957687,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.684772,
      0.988825,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362208,
      NULL,
      NULL,
      NULL,
      2.113554,
      2.610340,
      1,
      1,
      0.607663,
      0,
      NULL,
      NULL,
      5,
      3,
      2,
      1,
      NULL,
      NULL,
      0.833472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827897,
      NULL,
      NULL,
      0.288249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.629254,
      0.254254,
      1,
      0.377397,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.514030,
      NULL,
      NULL,
      0.377352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2.826349,
      0.261839,
      6.352655,
      NULL,
      2.382176,
      3,
      3.136150,
      1,
      3.523957,
      NULL,
      3.379499,
      2.033691,
      3.803483,
      NULL,
      NULL,
      NULL,
      2.622922,
      8,
      6.514138,
      NULL,
      NULL,
      2.881514,
      6.819267,
      0.893031,
      0,
      2,
      NULL,
      NULL,
      1,
      1.713610,
      0.097860,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390000,
      NULL,
      NULL,
      0.637843,
      NULL,
      NULL,
      0.709508,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.082554,
      NULL,
      NULL,
      1,
      2.998321,
      1.328654,
      NULL,
      1,
      2.732389,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      321,
      NULL,
      0.884241,
      NULL,
      NULL,
      NULL,
      1.488307,
      NULL,
      0,
      NULL,
      0.250484,
      NULL,
      0,
      NULL,
      3.052439,
      NULL,
      NULL,
      NULL,
      1.728517,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.967005,
      NULL,
      2.427645,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.248609,
      NULL,
      1.287674,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.754382,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      1.080937,
      2.873129,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2,
      24,
      14,
      1,
      NULL,
      NULL,
      3,
      3.486314,
      2,
      0.937409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0.023475,
      1,
      NULL,
      1,
      1.609147,
      1.368501,
      1.719201,
      0,
      0.926386,
      0,
      0,
      1,
      0.067684,
      1.385327,
      NULL,
      NULL,
      1,
      2.135644,
      1.508664,
      1.544818,
      1.417970,
      1,
      1,
      0.471609,
      2,
      1,
      0.965079,
      0.437718,
      89,
      0.190498,
      0,
      5,
      NULL,
      3.552412,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.139117,
      0.336645,
      1.867692,
      0.512730,
      1,
      1,
      0.911918,
      NULL,
      1.555138,
      0.201884,
      1.503236,
      0.678189,
      0.722301,
      NULL,
      1.247462,
      NULL,
      1,
      1,
      1.281040,
      1.627083,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191033,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      0.628723,
      NULL,
      0.597993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127816,
      NULL,
      0,
      NULL,
      1.300906,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335303,
      NULL,
      1.500085,
      0,
      0.966546,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.475254,
      0.492311,
      NULL,
      NULL,
      0.633338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.571034,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.224441,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2.795638,
      2.072505,
      NULL,
      0.901136,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389757,
      NULL,
      1.799576,
      NULL,
      1.110457,
      NULL,
      2,
      2,
      5,
      1.863688,
      0,
      3.469865,
      62,
      80,
      0,
      4,
      NULL,
      '30214',
      '32224',
      '41213',
      1,
      '12341',
      '',
      '',
      NULL,
      '00120',
      '',
      '');
commit;
end;
/


