set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000208';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3232304',
      3,
      0.708547,
      0,
      3,
      '4232',
      3,
      2.378933,
      NULL,
      43,
      ' 1-23-1976',
      89,
      NULL,
      1,
      NULL,
      NULL,
      ' 2-18-1996',
      18.386270,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 3- 6-1993',
      0.070127,
      0,
      2,
      0.975994,
      NULL,
      2.897490,
      NULL,
      0,
      0,
      NULL,
      7,
      NULL,
      1.936801,
      2.830342,
      6,
      0,
      10,
      5,
      3,
      5.408410,
      0,
      1,
      0,
      0,
      1,
      1.896563,
      1.896177,
      1.415472,
      NULL,
      1,
      NULL,
      4,
      1,
      3,
      2.250928,
      3,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.302113,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3.418172,
      1.745660,
      0.579165,
      1.576782,
      1,
      1.712560,
      NULL,
      0,
      1.362192,
      1,
      1,
      NULL,
      0.621017,
      2.529886,
      2,
      1,
      4,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1.290050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      1,
      5,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1.824355,
      NULL,
      NULL,
      5,
      1,
      2,
      2,
      0,
      3,
      0,
      5,
      2,
      5,
      NULL,
      4,
      2,
      NULL,
      5,
      3,
      5,
      NULL,
      NULL,
      4,
      2,
      NULL,
      1,
      NULL,
      0,
      11,
      0.385329,
      ' 0-23-1989',
      280,
      NULL,
      255.567561,
      3.189781,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0.499303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830218,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.528587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939825,
      1.630372,
      0.348069,
      1.362096,
      1.962427,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.529505,
      0,
      3,
      2,
      1,
      1,
      3,
      1,
      1,
      0,
      NULL,
      0,
      1.037383,
      3,
      1.760142,
      0.004943,
      1,
      1.197065,
      1.327953,
      1,
      1,
      1,
      0,
      1.395816,
      0.102109,
      1.968138,
      0,
      0,
      2,
      1.498973,
      0.433051,
      2,
      NULL,
      1,
      1.869928,
      3,
      5.074129,
      5,
      1.547259,
      3.115980,
      1.785907,
      1.751496,
      NULL,
      NULL,
      2,
      1.956425,
      60,
      NULL,
      NULL,
      NULL,
      3,
      0.415733,
      3.615156,
      '40234',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.666783,
      '',
      '',
      '',
      0.432233,
      6.654588,
      74,
      NULL,
      1.911083,
      NULL,
      NULL,
      5.037933,
      1,
      2,
      NULL,
      0.405675,
      1.853018,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.185473,
      NULL,
      0.486354,
      3.106358,
      1,
      0,
      NULL,
      3,
      0,
      1.655535,
      NULL,
      NULL,
      0.523135,
      3,
      0,
      3,
      1,
      1.569700,
      NULL,
      3,
      0.905154,
      0.465822,
      0.843898,
      NULL,
      2.057555,
      NULL,
      0,
      9.233624,
      9,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.524334,
      NULL,
      1.537089,
      NULL,
      NULL,
      2,
      0.133363,
      1.282568,
      1.848780,
      3.118574,
      NULL,
      3,
      2,
      1,
      3,
      0.640848,
      1.976332,
      1.879913,
      2.190319,
      1.393561,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.350266,
      NULL,
      NULL,
      3,
      6.666678,
      0.971427,
      0,
      1.614191,
      NULL,
      NULL,
      NULL,
      1.243592,
      NULL,
      NULL,
      NULL,
      3.100872,
      NULL,
      1,
      1.378418,
      2.074162,
      NULL,
      NULL,
      1.218630,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544658,
      NULL,
      NULL,
      NULL,
      1.161224,
      0.204292,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      4.976036,
      1.500986,
      3,
      1.624539,
      1.182916,
      0,
      NULL,
      NULL,
      6,
      6,
      8.682023,
      0.577304,
      NULL,
      5.347394,
      0.207803,
      NULL,
      NULL,
      NULL,
      2.748792,
      3.656261,
      NULL,
      1.422122,
      NULL,
      2.152550,
      0.731279,
      2,
      0,
      7.175136,
      3,
      0.790078,
      0,
      1,
      0.914789,
      3.428459,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      2,
      6.245966,
      NULL,
      2,
      NULL,
      11.774617,
      3.412280,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1,
      1,
      1.790218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.628679,
      NULL,
      NULL,
      0.929003,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.424231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.977598,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079240,
      1.088735,
      NULL,
      NULL,
      0.476017,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.297431,
      NULL,
      NULL,
      3.300819,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.007120,
      NULL,
      NULL,
      NULL,
      1.710865,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.702924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      65.414177,
      24,
      2.183688,
      NULL,
      1.250909,
      1.560535,
      NULL,
      NULL,
      1.573801,
      NULL,
      NULL,
      0.565543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095287,
      NULL,
      NULL,
      NULL,
      34.838538,
      0.354215,
      0.901324,
      1.289534,
      1,
      0.118523,
      0.450046,
      0.038289,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1.649346,
      NULL,
      0.265442,
      1.735389,
      1.312821,
      NULL,
      1.486270,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.053745,
      NULL,
      128,
      NULL,
      7.382065,
      32,
      NULL,
      1,
      1,
      0.578127,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.900630,
      NULL,
      1.611390,
      NULL,
      1.974335,
      NULL,
      3,
      NULL,
      1.880626,
      NULL,
      0.535415,
      NULL,
      0,
      NULL,
      1.766935,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542699,
      1.004031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573530,
      NULL,
      NULL,
      NULL,
      0.940905,
      NULL,
      0,
      1,
      0.241184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      NULL,
      1.595554,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.878617,
      NULL,
      NULL,
      NULL,
      1,
      3.784935,
      NULL,
      1.981186,
      NULL,
      NULL,
      1,
      NULL,
      91,
      1,
      6.734332,
      1.107135,
      0.538407,
      1,
      0.387694,
      1,
      1,
      0.652344,
      52.764509,
      0,
      0,
      1,
      2.534845,
      3,
      0,
      0,
      11.952234,
      3,
      3,
      3.457539,
      3,
      11.179272,
      NULL,
      2,
      2,
      1,
      1.374708,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      3.450892,
      0,
      1,
      NULL,
      0,
      2,
      3.362123,
      1.269227,
      3.805855,
      NULL,
      0,
      NULL,
      0,
      1.456885,
      0,
      1,
      1,
      1.226113,
      0.218479,
      3.912149,
      0.997628,
      1.096375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369374,
      0.083760,
      1,
      0,
      NULL,
      1,
      1,
      2,
      2,
      3.660494,
      1.325478,
      NULL,
      57.766638,
      NULL,
      5,
      NULL,
      4,
      '01110',
      '02012',
      '04100',
      0,
      '',
      '',
      '',
      3.282147,
      '023',
      NULL,
      '');
commit;
end;
/


