set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5104139';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0142234',
      2,
      1,
      3,
      1,
      '4304',
      2,
      0.518310,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      0,
      1.482863,
      1,
      '11-18-1991',
      44.689801,
      NULL,
      1261,
      NULL,
      0,
      ' 3- 0-1979',
      ' 3- 5-1974',
      ' 1- 4-1993',
      1,
      2.389622,
      2.350887,
      0,
      1.286139,
      1.624368,
      0,
      1,
      0.803527,
      NULL,
      NULL,
      NULL,
      4,
      69,
      184,
      5,
      5.833178,
      2,
      0,
      8,
      1,
      0,
      NULL,
      1.601344,
      NULL,
      NULL,
      0.692390,
      1.775258,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      2,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      3.313151,
      0,
      NULL,
      2,
      0,
      1.379781,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.558993,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      0,
      2.599173,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      4,
      0,
      0,
      5,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.124693,
      0,
      1,
      0,
      1,
      3,
      0,
      2,
      2,
      3,
      NULL,
      2,
      2,
      1,
      4,
      2,
      0,
      5,
      NULL,
      1,
      1,
      1,
      3,
      0,
      1,
      2,
      4,
      0,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      1.411298,
      ' 3-29-1986',
      1232.904358,
      ' 1-25-1986',
      21,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      3,
      1,
      2.131995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403559,
      3.465025,
      0.611787,
      0.547203,
      NULL,
      0.746881,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304319,
      0.143337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949505,
      0.603786,
      0.672380,
      0,
      1,
      NULL,
      0.087901,
      19919,
      1.905758,
      0.278414,
      28.209752,
      816.107755,
      1.092376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.098717,
      NULL,
      7,
      0.700230,
      0,
      0,
      NULL,
      1.817073,
      3,
      1,
      1.881783,
      1.114353,
      5.263099,
      0,
      1.421831,
      NULL,
      11,
      34,
      40,
      4,
      1,
      5,
      '34310',
      '12013',
      '',
      1,
      '',
      '',
      '',
      3,
      '3401',
      NULL,
      NULL,
      1.457893,
      0,
      NULL,
      2.346189,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.215245,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.405141,
      1,
      0.653434,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      1.665425,
      1.814240,
      NULL,
      0,
      NULL,
      NULL,
      0.167953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962889,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      2,
      3,
      2,
      1.919934,
      NULL,
      NULL,
      NULL,
      1.271173,
      NULL,
      NULL,
      NULL,
      2.353342,
      3.545187,
      1.862858,
      NULL,
      1,
      1.265241,
      0,
      NULL,
      NULL,
      0.838379,
      1,
      0.231278,
      3,
      1.255894,
      1,
      0,
      1,
      NULL,
      0,
      1,
      2.112265,
      1.480177,
      0.128283,
      1,
      0.297421,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.440656,
      2,
      2.820629,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.811317,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.766776,
      2.399545,
      2.372727,
      NULL,
      NULL,
      NULL,
      9,
      7,
      NULL,
      0.888326,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864577,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      3.400266,
      1,
      1,
      2,
      3,
      5.605631,
      3.355019,
      0,
      1.678539,
      2,
      0,
      0,
      0.203375,
      7,
      7,
      5,
      3,
      7.559972,
      8,
      0.592909,
      6.952451,
      0,
      1,
      2.461689,
      1.317186,
      0.454903,
      0.458227,
      NULL,
      NULL,
      NULL,
      5,
      7,
      6,
      2,
      NULL,
      2,
      3.075650,
      NULL,
      NULL,
      2.626395,
      2.046020,
      3.426694,
      0.207521,
      1.467994,
      NULL,
      10,
      NULL,
      11,
      1,
      NULL,
      2,
      0.186937,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.772341,
      0.128859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.947673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.551731,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.515309,
      0,
      1.001846,
      0,
      0,
      0.141849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.852260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843376,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.771712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815015,
      NULL,
      NULL,
      1.755621,
      NULL,
      NULL,
      0.388982,
      NULL,
      NULL,
      NULL,
      627,
      554,
      0,
      NULL,
      NULL,
      NULL,
      10,
      2.397515,
      6167.446891,
      1587,
      0,
      1,
      1.698242,
      1.050534,
      1,
      0,
      0.579908,
      NULL,
      NULL,
      0.995857,
      0.504415,
      0,
      0.009531,
      1,
      1,
      0.890495,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.999688,
      1.548338,
      0,
      0,
      NULL,
      NULL,
      1.301974,
      NULL,
      1.558671,
      0,
      NULL,
      0,
      0.052723,
      NULL,
      1.910937,
      1,
      NULL,
      0.999431,
      1.871976,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.188634,
      NULL,
      0,
      0.440637,
      NULL,
      0.160903,
      0.125397,
      NULL,
      NULL,
      0,
      NULL,
      0.311915,
      NULL,
      3.008112,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.077311,
      NULL,
      1.629311,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414022,
      0.345959,
      1117,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.921833,
      1,
      NULL,
      1,
      NULL,
      4,
      3,
      NULL,
      3.437928,
      NULL,
      0.021453,
      1,
      19.864455,
      1,
      1,
      NULL,
      '21301',
      '44204',
      '',
      0,
      '',
      '',
      '',
      6,
      '1000',
      '3104',
      '04122');
commit;
end;
/


