set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9858589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      NULL,
      0.899115,
      0.974371,
      5.188518,
      3,
      '231',
      NULL,
      32,
      65.003590,
      '1112044',
      2.060603,
      0,
      0,
      2,
      '1010',
      2,
      NULL,
      NULL,
      NULL,
      ' 4-29-1979',
      NULL,
      38.143571,
      NULL,
      0.311097,
      2,
      ' 9-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 0-16-1987',
      1,
      NULL,
      NULL,
      3,
      1,
      2.839247,
      1,
      0,
      1.049107,
      0,
      8,
      16.797223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.557982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      4,
      1,
      5,
      1,
      6.243477,
      1,
      NULL,
      0,
      0,
      1.477677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      6.702562,
      3,
      1,
      1,
      1.328218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3.863184,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.114534,
      4,
      3,
      2,
      2,
      0,
      4,
      1,
      0,
      4,
      0,
      1,
      1,
      4,
      4,
      NULL,
      2,
      NULL,
      1,
      5,
      NULL,
      1,
      NULL,
      0,
      2,
      3,
      3,
      3,
      ' 3-21-1978',
      102.306554,
      NULL,
      78.948810,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.304597,
      0.079570,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.776733,
      NULL,
      3,
      NULL,
      3.353752,
      NULL,
      NULL,
      4.815149,
      1.306726,
      0.125481,
      2,
      2.544034,
      0,
      NULL,
      NULL,
      NULL,
      3.122092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.265701,
      1.447293,
      1,
      0,
      0.279244,
      0.877867,
      1.329908,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.655001,
      0,
      3,
      NULL,
      3,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      1.369779,
      0,
      NULL,
      2.998494,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.174795,
      0.054109,
      1.597495,
      1.107770,
      1,
      0,
      NULL,
      2,
      0.894286,
      6,
      2,
      NULL,
      9,
      11.895869,
      1.490790,
      5,
      1.890532,
      3,
      3.561191,
      1,
      1.063145,
      NULL,
      1,
      2.280411,
      NULL,
      NULL,
      9,
      40,
      1,
      1.288016,
      0.357882,
      '41440',
      NULL,
      '',
      0.652994,
      '',
      '',
      NULL,
      2.221562,
      '1411',
      '',
      '',
      0,
      12,
      5.080430,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439370,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.663718,
      NULL,
      NULL,
      0.346599,
      NULL,
      NULL,
      0.273153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.801917,
      1.267267,
      1,
      1.382496,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.040522,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.394189,
      8,
      7,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.058099,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785348,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.494402,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      1,
      1.133973,
      NULL,
      NULL,
      5,
      2.934439,
      NULL,
      2.252838,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.342367,
      0.542363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.352322,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.171663,
      3.845707,
      3.624138,
      1.985850,
      NULL,
      NULL,
      4.100665,
      NULL,
      4,
      2,
      NULL,
      5,
      4,
      3,
      0,
      1.441519,
      1,
      NULL,
      NULL,
      0.303768,
      2,
      1,
      9.978661,
      6.077191,
      6.620733,
      NULL,
      0.660509,
      1,
      0,
      NULL,
      0,
      3.373403,
      2.836779,
      2,
      1.644486,
      0,
      2,
      2.731108,
      5.563110,
      1,
      0.652382,
      5,
      1.823510,
      2,
      1,
      2,
      1,
      NULL,
      0,
      1.047245,
      0.485281,
      1.151552,
      NULL,
      NULL,
      1.498897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171945,
      NULL,
      NULL,
      1.646767,
      NULL,
      NULL,
      0.295391,
      1.389303,
      2,
      0,
      1,
      1.458527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.040951,
      NULL,
      NULL,
      NULL,
      3.471837,
      NULL,
      NULL,
      NULL,
      2.842091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.580616,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.205223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.014091,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.097346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.840488,
      NULL,
      NULL,
      NULL,
      10.131357,
      NULL,
      NULL,
      NULL,
      1.914174,
      NULL,
      NULL,
      NULL,
      0.111375,
      1,
      2,
      0.392085,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.112956,
      NULL,
      NULL,
      1.830967,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.713807,
      NULL,
      1,
      NULL,
      0,
      1.585777,
      0.143180,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1.023407,
      NULL,
      0,
      0.285687,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      4,
      1.641356,
      1,
      NULL,
      3,
      4.481578,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.698879,
      NULL,
      NULL,
      0.440121,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436580,
      0,
      NULL,
      1.968849,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.186395,
      NULL,
      0.568173,
      1,
      NULL,
      NULL,
      1.986944,
      NULL,
      2.344669,
      1.523778,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033762,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      0,
      40.111727,
      1.940300,
      1,
      NULL,
      NULL,
      '12432',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0430',
      '',
      '');
commit;
end;
/


