set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '0141204',
      3,
      1.347337,
      3,
      0,
      '1334',
      0.953896,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      ' 0-12-1997',
      NULL,
      1,
      NULL,
      165.934452,
      0,
      ' 6- 8-2000',
      NULL,
      NULL,
      2.459713,
      1.200143,
      0,
      0.769966,
      0,
      2,
      NULL,
      0.182836,
      1.510300,
      26.648621,
      1,
      18,
      NULL,
      0.575258,
      189,
      0,
      0,
      2,
      2,
      8,
      1.386360,
      3,
      1,
      0,
      0.426698,
      1,
      1,
      NULL,
      1,
      0.591811,
      0.267673,
      2,
      4,
      NULL,
      3.205898,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      5,
      0,
      0,
      1,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.104972,
      3.687266,
      1,
      NULL,
      1,
      0,
      0.493988,
      2.035281,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.111404,
      1,
      3,
      0,
      4.267434,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3,
      1,
      2,
      5,
      4,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      5,
      2,
      3,
      0,
      3,
      0,
      3,
      NULL,
      3,
      1.500264,
      NULL,
      74.908991,
      ' 8- 6-2001',
      144.423786,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      1.142609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      2.319764,
      1,
      0.276448,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      6,
      1.818196,
      1.703727,
      0.724306,
      NULL,
      NULL,
      NULL,
      0.303688,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.109848,
      1,
      0.509654,
      0,
      1.772991,
      0,
      0,
      0,
      9.669342,
      2.444692,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      1,
      0,
      3,
      2,
      2,
      0,
      3.885643,
      9.142143,
      7,
      1.315750,
      NULL,
      NULL,
      10,
      1.399053,
      0.619259,
      1.371024,
      0.360263,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.965922,
      NULL,
      3,
      5.092901,
      8.363380,
      10,
      NULL,
      2,
      3.342355,
      NULL,
      1.054008,
      2.473597,
      NULL,
      37,
      NULL,
      1,
      NULL,
      34,
      26,
      0,
      NULL,
      NULL,
      1,
      '13303',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      3,
      NULL,
      NULL,
      33.336361,
      0.860659,
      23,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.868814,
      1.759465,
      0,
      NULL,
      NULL,
      0.835014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.287527,
      0,
      3,
      3,
      0.715410,
      2.460193,
      NULL,
      0,
      1.198411,
      3,
      1.060023,
      3,
      1,
      1.209730,
      1,
      0.573502,
      0,
      NULL,
      0.017396,
      4.744106,
      3,
      0.390112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589591,
      2,
      1.517903,
      1,
      NULL,
      NULL,
      NULL,
      0.426568,
      0.231991,
      3,
      0.780902,
      1,
      2,
      2,
      2.927163,
      0,
      3,
      0.216047,
      NULL,
      3.726012,
      NULL,
      0,
      1,
      NULL,
      0,
      0.892046,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2.141403,
      NULL,
      9,
      8.161351,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471637,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613060,
      NULL,
      NULL,
      0.789507,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.617337,
      NULL,
      NULL,
      0.684004,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.133325,
      NULL,
      0.255633,
      NULL,
      NULL,
      0,
      5.431079,
      6,
      3.670336,
      0,
      NULL,
      0.958629,
      NULL,
      NULL,
      0,
      0,
      3.869778,
      1.082841,
      2,
      1.868898,
      3,
      NULL,
      1,
      3,
      2,
      NULL,
      0.529989,
      1,
      3.629330,
      0,
      NULL,
      NULL,
      3.598828,
      2.359587,
      0,
      3.505588,
      3.836401,
      0.346659,
      3,
      6.951395,
      NULL,
      5,
      2.317243,
      2,
      NULL,
      0,
      1,
      0.980298,
      0,
      1.516660,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.951002,
      1,
      1,
      NULL,
      NULL,
      1.582531,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.797384,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.682044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.550987,
      NULL,
      NULL,
      NULL,
      0.091379,
      NULL,
      NULL,
      NULL,
      0.708925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.630196,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      36.489235,
      NULL,
      0,
      NULL,
      NULL,
      0.005935,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.679492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15472,
      1.776240,
      NULL,
      0,
      0.183608,
      0.512980,
      1,
      NULL,
      NULL,
      NULL,
      1.030883,
      1,
      0,
      0.502945,
      0,
      1,
      NULL,
      1.806122,
      0.268114,
      1.044680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      6,
      0.549695,
      0,
      NULL,
      3.724392,
      0.492015,
      NULL,
      2.272478,
      NULL,
      NULL,
      1.282825,
      1.595808,
      NULL,
      1,
      0,
      NULL,
      1.188428,
      1.198351,
      NULL,
      1.804953,
      3,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.273142,
      1.144187,
      NULL,
      0,
      2.835768,
      NULL,
      NULL,
      0.659450,
      NULL,
      3.705531,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024467,
      NULL,
      1.216389,
      NULL,
      1.166001,
      NULL,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      12.842339,
      3,
      1,
      NULL,
      '33310',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


