set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3441433',
      NULL,
      1,
      NULL,
      3,
      '0414',
      1,
      NULL,
      NULL,
      NULL,
      '10-26-1997',
      NULL,
      NULL,
      1,
      1,
      5,
      ' 2- 7-2001',
      41.576627,
      3.429306,
      NULL,
      NULL,
      1,
      ' 1-21-1998',
      ' 6-14-1985',
      NULL,
      0,
      1.345274,
      1,
      0.829182,
      0.990311,
      0.120372,
      3,
      0,
      0,
      58,
      1,
      3.068838,
      0.598520,
      93,
      NULL,
      0,
      20.511906,
      3,
      0,
      8.595131,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.860809,
      1,
      NULL,
      1.665135,
      0,
      4,
      4,
      0.313033,
      1,
      NULL,
      3,
      0,
      0,
      NULL,
      2,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.469549,
      NULL,
      NULL,
      0.151937,
      NULL,
      NULL,
      5,
      NULL,
      2,
      0,
      0,
      NULL,
      0.403140,
      1,
      2.802819,
      0,
      3,
      1,
      1.988508,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      1.496404,
      NULL,
      NULL,
      1,
      4,
      5,
      1,
      5,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1.553502,
      NULL,
      3,
      NULL,
      1,
      3,
      1,
      0,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      NULL,
      4,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4,
      2.121412,
      2.600435,
      '11- 8-1986',
      122,
      ' 3- 3-2001',
      3.029160,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      4,
      1,
      1.265111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.140861,
      NULL,
      NULL,
      NULL,
      2,
      4.051007,
      3.054274,
      NULL,
      1.440146,
      0,
      0.793155,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.838343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810527,
      1.516040,
      1.291697,
      0.715251,
      NULL,
      1,
      2,
      1,
      3.998676,
      0.246860,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      0,
      0,
      2,
      NULL,
      1,
      1,
      1,
      0,
      2.075332,
      3,
      1,
      3.252920,
      0,
      NULL,
      2,
      1,
      1.927680,
      0,
      1.335529,
      0.975349,
      NULL,
      1.555496,
      0.625770,
      1,
      NULL,
      3,
      2.802900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      10.047434,
      NULL,
      NULL,
      3.178831,
      '44004',
      '',
      '',
      0.915792,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      23.922214,
      33.278636,
      0,
      2.016858,
      8.162757,
      3.129134,
      2.073913,
      4,
      1.800168,
      NULL,
      1.444785,
      1,
      NULL,
      NULL,
      2,
      1.551160,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.088012,
      3.660796,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887640,
      NULL,
      NULL,
      7,
      NULL,
      9.889367,
      0,
      0.927969,
      NULL,
      NULL,
      NULL,
      0.429439,
      NULL,
      NULL,
      NULL,
      0.673063,
      2.624893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420728,
      NULL,
      0,
      0,
      1.759755,
      0.760541,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0.343297,
      1,
      1,
      3.980419,
      3,
      1.018240,
      1.900391,
      NULL,
      NULL,
      NULL,
      1,
      1.654043,
      2.539355,
      7.582387,
      7.122042,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.687134,
      NULL,
      NULL,
      NULL,
      1.405539,
      NULL,
      NULL,
      NULL,
      0,
      0.111719,
      NULL,
      1.685888,
      0,
      1,
      NULL,
      NULL,
      2.461251,
      NULL,
      NULL,
      1.903041,
      0,
      1.673817,
      1.977066,
      NULL,
      NULL,
      0,
      3,
      0.585186,
      2.098074,
      1.612594,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.670947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      1.925446,
      6.192845,
      6,
      5.038942,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.868089,
      1,
      3.533692,
      3,
      0.670105,
      NULL,
      NULL,
      1.580482,
      1,
      8.270668,
      NULL,
      0.281346,
      1.537091,
      3,
      NULL,
      3,
      1,
      1.348191,
      1,
      NULL,
      NULL,
      3.267144,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680143,
      NULL,
      NULL,
      0.784625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.958246,
      NULL,
      NULL,
      3.909419,
      NULL,
      NULL,
      NULL,
      1.589500,
      0,
      NULL,
      1.906003,
      NULL,
      1.237084,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.263793,
      1.523411,
      NULL,
      NULL,
      0.028943,
      0,
      NULL,
      NULL,
      1.186226,
      0.395389,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.687729,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.149325,
      NULL,
      NULL,
      NULL,
      1.425944,
      1.752312,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.377435,
      0.584348,
      NULL,
      NULL,
      3,
      2.907087,
      NULL,
      NULL,
      1.423542,
      0,
      NULL,
      NULL,
      0.755997,
      2.064238,
      NULL,
      NULL,
      0.399581,
      NULL,
      NULL,
      NULL,
      NULL,
      22.760908,
      NULL,
      0,
      NULL,
      NULL,
      0.208616,
      NULL,
      NULL,
      0.392825,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.552864,
      15524.045689,
      652.493899,
      1,
      0,
      0,
      0.635933,
      NULL,
      1.533805,
      1.885916,
      1,
      NULL,
      1,
      1,
      1,
      1.931741,
      NULL,
      1,
      NULL,
      0.262845,
      0.458921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      4,
      1.764766,
      2.364684,
      NULL,
      3,
      5.852703,
      NULL,
      3,
      3.223345,
      1,
      1.309270,
      NULL,
      1.082512,
      1,
      0,
      NULL,
      0.099373,
      1,
      1.651509,
      0.299936,
      NULL,
      1.836293,
      1,
      0.314967,
      NULL,
      NULL,
      2.605902,
      1,
      1.232608,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.947645,
      3.410787,
      0.079032,
      NULL,
      0.888108,
      2.037867,
      3,
      0,
      1.677641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772222,
      1.918139,
      1.297155,
      0,
      1.614135,
      0.720194,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      2,
      0.263190,
      1.180682,
      '44313',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


