set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '1001121',
      NULL,
      1,
      2,
      1,
      NULL,
      2,
      1.508532,
      NULL,
      NULL,
      ' 7- 6-1994',
      9.790949,
      NULL,
      2,
      1.026339,
      NULL,
      ' 5- 6-1990',
      27.169432,
      2.277525,
      NULL,
      26.388936,
      1,
      '11- 7-1985',
      '11-10-2003',
      NULL,
      2,
      NULL,
      3.303497,
      3.086579,
      1,
      0,
      1,
      1.190898,
      1,
      67.793331,
      4,
      NULL,
      5.896934,
      22.352535,
      24,
      4,
      1.017309,
      NULL,
      0,
      3,
      1.909937,
      3,
      1,
      NULL,
      NULL,
      1.390796,
      1.211399,
      NULL,
      NULL,
      1.164598,
      0,
      2,
      1,
      2,
      2,
      3,
      0,
      2,
      1,
      NULL,
      2,
      5,
      NULL,
      1,
      1,
      0,
      0,
      7,
      2,
      NULL,
      2,
      NULL,
      1.034725,
      NULL,
      NULL,
      1.988532,
      NULL,
      NULL,
      5,
      0,
      0.331094,
      2.857269,
      0,
      0.828375,
      0.890742,
      NULL,
      3,
      3.161607,
      1.465508,
      0.372971,
      1.232437,
      NULL,
      1,
      3,
      2.721659,
      3.207583,
      0.749796,
      2,
      1,
      3,
      3.113473,
      NULL,
      2,
      1.507714,
      NULL,
      NULL,
      NULL,
      1.227762,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      4,
      1,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      6,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      4,
      NULL,
      0,
      NULL,
      0,
      5,
      3,
      4,
      3,
      0,
      1,
      1,
      0,
      2,
      2,
      2,
      0,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2.858554,
      0.745269,
      ' 9- 2-1974',
      NULL,
      NULL,
      40.436434,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1.695299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.133082,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.731717,
      6,
      1.834757,
      2.762651,
      4,
      1.495419,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.894287,
      0.194775,
      NULL,
      0,
      1.575473,
      0,
      3.374687,
      4.649814,
      2.663601,
      0.744449,
      NULL,
      NULL,
      NULL,
      1,
      1.006629,
      NULL,
      3,
      1,
      1,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.086011,
      3,
      NULL,
      1.494377,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0.736804,
      1.715648,
      NULL,
      1,
      NULL,
      2,
      1,
      10.759974,
      2,
      3,
      NULL,
      4,
      5.433090,
      NULL,
      NULL,
      4,
      1,
      1.640037,
      0,
      58,
      3,
      0,
      NULL,
      NULL,
      NULL,
      48.005930,
      1,
      0,
      0.412649,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.279498,
      3,
      30,
      38.489771,
      0,
      NULL,
      0,
      0.009553,
      2,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.559523,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181177,
      0.742156,
      1,
      1,
      NULL,
      1,
      2.795707,
      1,
      0,
      2,
      0,
      0,
      0.654044,
      NULL,
      1.365528,
      NULL,
      2.190350,
      NULL,
      2.559033,
      0,
      1,
      1,
      9,
      1.495374,
      2,
      0.976804,
      NULL,
      NULL,
      NULL,
      0.462950,
      NULL,
      NULL,
      NULL,
      1,
      1.959252,
      0.225531,
      NULL,
      NULL,
      NULL,
      0.711507,
      NULL,
      1,
      2.396300,
      0.890865,
      NULL,
      1.649922,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      3.091018,
      1,
      0.662930,
      2,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      0.388234,
      0,
      2.883894,
      5,
      7.927397,
      0,
      1.281335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518399,
      NULL,
      NULL,
      NULL,
      0,
      1.741291,
      0,
      NULL,
      0,
      0.878125,
      NULL,
      NULL,
      5.556487,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      7,
      0,
      0.702989,
      0.914672,
      1.361964,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.497990,
      NULL,
      NULL,
      1,
      1.780474,
      3,
      0,
      NULL,
      2.634416,
      3.649589,
      8.088943,
      5,
      3.233648,
      NULL,
      NULL,
      0.010586,
      NULL,
      NULL,
      1,
      3.536367,
      2,
      3.470071,
      NULL,
      0,
      3,
      3,
      2,
      7,
      0,
      7.851199,
      0.886927,
      0.792146,
      2.923457,
      0,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0.379868,
      3,
      0.536776,
      9.245521,
      NULL,
      6,
      7,
      0.256145,
      NULL,
      0.725401,
      3,
      0,
      0.923415,
      1.740457,
      0,
      1.233638,
      0,
      0.138742,
      NULL,
      NULL,
      1.735567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.006916,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.963106,
      NULL,
      3,
      0,
      NULL,
      NULL,
      4.707767,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.078145,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.447245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.988948,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.616602,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.532619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.197033,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.503272,
      NULL,
      NULL,
      1,
      NULL,
      0.811329,
      4538.187274,
      0.044399,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.998147,
      0.728222,
      0.623279,
      1.441993,
      0.748086,
      0,
      NULL,
      0,
      1.106162,
      1.423337,
      0.870759,
      1,
      0.505244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.838726,
      0,
      NULL,
      0.452860,
      NULL,
      1,
      0,
      1.320096,
      NULL,
      2,
      0,
      NULL,
      0.011936,
      1.618263,
      NULL,
      0,
      1.971057,
      NULL,
      1,
      0,
      NULL,
      1.165069,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.047361,
      NULL,
      0,
      NULL,
      NULL,
      1.174274,
      NULL,
      NULL,
      3,
      2.831945,
      NULL,
      0.665220,
      0.877112,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      17.627331,
      131.185232,
      3,
      NULL,
      1.216400,
      '12123',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1.818200,
      '',
      '',
      '');
commit;
end;
/


