set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3031324',
      2.174828,
      NULL,
      NULL,
      NULL,
      '3214',
      1,
      1.620649,
      NULL,
      NULL,
      NULL,
      57,
      NULL,
      4,
      NULL,
      2.309227,
      ' 9- 9-1988',
      13.647676,
      2.515861,
      212.594810,
      66,
      4,
      NULL,
      NULL,
      '11- 7-1981',
      2.189303,
      1.219791,
      2.248370,
      2.668813,
      1.090430,
      0.863301,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.978441,
      NULL,
      9.298760,
      NULL,
      NULL,
      NULL,
      3,
      1,
      9,
      0.759247,
      NULL,
      1,
      NULL,
      1.729977,
      1.680590,
      1,
      1.414045,
      0,
      0,
      0,
      NULL,
      5,
      3,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.163908,
      1.779690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      2,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0.375890,
      NULL,
      0.095405,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.098286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905718,
      0,
      1,
      0.429746,
      2.694998,
      1.858502,
      0,
      NULL,
      NULL,
      NULL,
      0.762776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.779145,
      NULL,
      1.510566,
      0,
      NULL,
      0.798799,
      0.852788,
      0.072379,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      3,
      3,
      3,
      0,
      0,
      0,
      3,
      1,
      0,
      3,
      0,
      3,
      1,
      1.697129,
      NULL,
      NULL,
      0.024041,
      1.601443,
      NULL,
      NULL,
      1.303544,
      1.931848,
      0.986035,
      1,
      2,
      5.016342,
      NULL,
      10,
      11,
      4,
      NULL,
      8.474258,
      3,
      0.938025,
      0.159479,
      6.231929,
      0,
      NULL,
      3,
      38.148671,
      3,
      1.629593,
      82,
      NULL,
      NULL,
      NULL,
      5,
      1.243649,
      2,
      '12203',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0.944005,
      '',
      '',
      '',
      1.756216,
      13.311832,
      17,
      21,
      2.798795,
      10.500240,
      1.425489,
      0,
      5,
      2.384089,
      0.546527,
      1,
      0.228011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.896245,
      NULL,
      NULL,
      NULL,
      3.249790,
      1,
      1.531149,
      0.427745,
      1.598087,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.033874,
      NULL,
      NULL,
      0.576200,
      NULL,
      NULL,
      9.578014,
      8,
      0.461245,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.589982,
      1.844869,
      1.095963,
      NULL,
      NULL,
      1.800718,
      NULL,
      NULL,
      1.545816,
      1,
      3,
      3.423893,
      0,
      1.838123,
      0,
      2,
      NULL,
      0,
      0.991233,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.495621,
      NULL,
      NULL,
      1.161075,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.954209,
      NULL,
      1,
      NULL,
      0.445974,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.405008,
      2.930276,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      0,
      2.561947,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773391,
      NULL,
      NULL,
      0.108870,
      NULL,
      NULL,
      0.321465,
      NULL,
      NULL,
      0.235590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.737888,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.913523,
      0.619172,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      3.469811,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.151776,
      1,
      0,
      0,
      1.828479,
      4,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.301534,
      1,
      2,
      1.531355,
      1.724072,
      1.826492,
      NULL,
      1.998567,
      NULL,
      NULL,
      NULL,
      0.994453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.913022,
      NULL,
      1.471930,
      0.655857,
      0.584746,
      2,
      NULL,
      NULL,
      2.874838,
      0,
      NULL,
      NULL,
      0.613050,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.697943,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.026423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.030564,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.281405,
      NULL,
      NULL,
      NULL,
      1,
      1.726867,
      NULL,
      NULL,
      1.973868,
      1,
      NULL,
      NULL,
      1.882390,
      1.311076,
      NULL,
      NULL,
      0,
      0.266417,
      NULL,
      NULL,
      1.720194,
      NULL,
      NULL,
      NULL,
      0.351596,
      1.006699,
      NULL,
      NULL,
      6.746761,
      0.162675,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      8,
      2.516677,
      3,
      1.144874,
      NULL,
      0.980472,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.040362,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181732,
      124.570850,
      0.087963,
      0,
      0,
      1.867712,
      0,
      0,
      1.478706,
      1,
      NULL,
      1.796057,
      1.841425,
      1.232941,
      1.788897,
      0.025143,
      NULL,
      0.781835,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.035029,
      1.155988,
      1.272586,
      1,
      0.336841,
      1.074973,
      0.533733,
      1,
      1.752328,
      NULL,
      NULL,
      0,
      3,
      0,
      1.745446,
      3,
      1.005571,
      NULL,
      0,
      0,
      0,
      0.411029,
      1,
      NULL,
      0,
      1.467630,
      0.237323,
      1,
      0.065315,
      1,
      1.217869,
      0.783887,
      1,
      0.437555,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.069393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293695,
      1.209840,
      1.048520,
      0,
      1.807629,
      0,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      27,
      NULL,
      5,
      0,
      0.336890,
      '10413',
      NULL,
      NULL,
      0.570721,
      '',
      '',
      '',
      1.593139,
      NULL,
      NULL,
      '');
commit;
end;
/


