set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303656';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2331232',
      1.192308,
      1.764426,
      4,
      0,
      '0032',
      0,
      NULL,
      NULL,
      NULL,
      ' 5-24-2003',
      NULL,
      NULL,
      NULL,
      2.863999,
      2.464597,
      ' 2-18-1997',
      21.678765,
      3.240269,
      272,
      119.691901,
      1,
      ' 1-27-1999',
      ' 5-23-2000',
      ' 6-26-2000',
      NULL,
      2.386319,
      1.306422,
      0,
      1,
      1.488274,
      0,
      1.857343,
      NULL,
      NULL,
      NULL,
      7.397949,
      NULL,
      NULL,
      1.782569,
      0,
      1,
      2,
      NULL,
      6.191569,
      0,
      1,
      0,
      0,
      0.419419,
      0.438138,
      0,
      4.966120,
      0.328689,
      1.874560,
      1.946189,
      8,
      NULL,
      3,
      3.243578,
      3,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      3,
      2,
      1,
      3.948095,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.769653,
      1.974720,
      0,
      0,
      3.834336,
      2,
      1,
      2.547302,
      1.971099,
      NULL,
      0.682849,
      0.925028,
      1.801334,
      0,
      NULL,
      3,
      3,
      1,
      1,
      6.704080,
      NULL,
      NULL,
      0.791302,
      1,
      NULL,
      NULL,
      1.251343,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1.107907,
      NULL,
      0,
      2,
      0,
      NULL,
      5,
      1,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      5,
      2,
      0,
      3,
      1,
      NULL,
      0,
      5,
      1,
      NULL,
      0.584696,
      NULL,
      ' 4-20-1974',
      82,
      ' 7-18-1986',
      70.171725,
      0,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      3.740373,
      1,
      0,
      1.416629,
      4.503659,
      1,
      NULL,
      NULL,
      0.506463,
      3.536796,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.362231,
      NULL,
      0.732584,
      NULL,
      1,
      20,
      3.100975,
      1.162722,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.241953,
      1,
      1,
      3,
      NULL,
      2,
      0,
      1,
      1,
      2,
      3,
      2.489403,
      NULL,
      3,
      3,
      0,
      0.303736,
      NULL,
      0.960335,
      0.314172,
      1,
      0.275110,
      0,
      1.112708,
      1,
      0.800048,
      0,
      1,
      0.460881,
      1.835790,
      0,
      NULL,
      3.373467,
      3,
      NULL,
      NULL,
      0.539520,
      0.060871,
      0.529255,
      3,
      2,
      1,
      49.637741,
      2,
      NULL,
      NULL,
      20,
      26,
      60,
      NULL,
      NULL,
      1,
      '32043',
      '',
      '',
      0.347262,
      '',
      '',
      '',
      1.765513,
      NULL,
      '',
      NULL,
      1.875477,
      14.637869,
      55.583274,
      21.491282,
      3.239410,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.751924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895750,
      1,
      0,
      NULL,
      NULL,
      3.716841,
      NULL,
      1.575483,
      1,
      NULL,
      0.048921,
      NULL,
      3.427010,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.615969,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.506630,
      0,
      2,
      2.083717,
      2,
      2.502422,
      2.047970,
      1,
      NULL,
      1,
      NULL,
      3.534797,
      2,
      NULL,
      2.330076,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.322044,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.527137,
      NULL,
      NULL,
      0,
      1,
      0.219618,
      2,
      2.883293,
      0,
      NULL,
      NULL,
      NULL,
      1.712278,
      3,
      1.414635,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.973988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.655601,
      1,
      0.674862,
      NULL,
      NULL,
      0.411947,
      4.598426,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.437347,
      1,
      NULL,
      1,
      3.253985,
      0.198635,
      1.794845,
      1,
      NULL,
      3,
      1.386689,
      NULL,
      0.436397,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.592047,
      NULL,
      3.452233,
      NULL,
      5.678578,
      NULL,
      0,
      2.154776,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.622489,
      0,
      1.375760,
      0,
      0.981438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477631,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.578943,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.014374,
      NULL,
      NULL,
      1,
      1.746001,
      1,
      1.766371,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      146.019727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656398,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.242409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.865310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      11,
      4,
      3,
      8,
      1,
      0,
      NULL,
      NULL,
      1.807240,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276582,
      NULL,
      0.548318,
      32,
      2.834360,
      0.005447,
      0.057663,
      1,
      1,
      NULL,
      1,
      0.700804,
      NULL,
      0,
      0.995624,
      1.780476,
      NULL,
      NULL,
      1,
      NULL,
      0.738534,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.603330,
      2.299426,
      0,
      NULL,
      1,
      0.899101,
      NULL,
      1,
      0,
      0,
      0.256687,
      NULL,
      1.451304,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.004690,
      0.917205,
      NULL,
      0.661234,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.072109,
      1.683870,
      NULL,
      0,
      1,
      NULL,
      1.634406,
      1,
      NULL,
      1.553492,
      3.395733,
      NULL,
      1,
      1.594206,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3.080636,
      1,
      44.447959,
      75.817504,
      1,
      4.129803,
      NULL,
      '22211',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.929704,
      '',
      '',
      '');
commit;
end;
/


