set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5803515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '0001314',
      NULL,
      NULL,
      2,
      2,
      '3434',
      2.089269,
      0,
      0,
      9.152220,
      NULL,
      68,
      NULL,
      0,
      1.937292,
      0.218244,
      ' 3-14-1986',
      NULL,
      NULL,
      161.303852,
      92.930649,
      4,
      NULL,
      NULL,
      '11-23-1995',
      2,
      0.829982,
      2.588892,
      0,
      1,
      NULL,
      0,
      1,
      1.130615,
      NULL,
      8,
      8.735040,
      6.098103,
      10.822595,
      3.843760,
      3,
      5.535755,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.225337,
      0,
      NULL,
      1.750034,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.110890,
      2,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.030971,
      NULL,
      0,
      0,
      NULL,
      0,
      1.864028,
      0.649001,
      NULL,
      0,
      1,
      0.755852,
      1,
      0,
      2,
      0,
      0,
      NULL,
      2,
      1.667800,
      1,
      0,
      0.026329,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1.176867,
      0,
      NULL,
      0,
      NULL,
      1.482461,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      1,
      0,
      NULL,
      0,
      4,
      2,
      1,
      1,
      5,
      3,
      1,
      3,
      1,
      NULL,
      5,
      2,
      NULL,
      1,
      2,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      3.871300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515729,
      0.948000,
      2,
      NULL,
      0,
      2.211634,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.878899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      3,
      0,
      1.950176,
      1,
      NULL,
      3,
      0.288718,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.596350,
      1,
      1,
      2,
      3,
      0,
      0,
      3,
      NULL,
      3,
      0,
      2.940175,
      0.571275,
      3,
      3,
      1,
      NULL,
      1.746281,
      NULL,
      1.523127,
      0,
      0.698506,
      1.928133,
      1,
      1,
      0.984023,
      1,
      NULL,
      3.590092,
      0.200439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023278,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.510884,
      '21132',
      '',
      '',
      0.863564,
      '',
      '',
      '',
      0.501893,
      '',
      NULL,
      '',
      0.666612,
      21.254862,
      NULL,
      22,
      3.597905,
      7.864291,
      3,
      81,
      NULL,
      2.240156,
      NULL,
      NULL,
      2,
      5.422611,
      0,
      1,
      NULL,
      0.145772,
      2.668352,
      0.014994,
      0,
      1.973731,
      1.361505,
      1,
      0.258256,
      NULL,
      NULL,
      0,
      2.110142,
      2.381004,
      2.250363,
      2.741242,
      2,
      3.889324,
      1.831564,
      1.174389,
      1.406066,
      NULL,
      1,
      2.320552,
      2,
      1,
      12,
      NULL,
      NULL,
      5.194404,
      NULL,
      1,
      NULL,
      3.276969,
      3,
      18,
      8,
      1.008219,
      3,
      14.647803,
      1,
      2.401142,
      NULL,
      1.986223,
      0.820257,
      1.808619,
      1,
      3.430019,
      2,
      0,
      NULL,
      1.690186,
      1,
      0.699692,
      3,
      NULL,
      3.275956,
      1,
      0,
      1.100153,
      0.095484,
      0.867511,
      0,
      1,
      2,
      0,
      0.812445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.064258,
      5.852989,
      0,
      1.890974,
      3,
      0,
      2.993390,
      17.470268,
      0.694441,
      0.430205,
      0,
      4.619386,
      11.719060,
      3.977666,
      1,
      1,
      3.122306,
      NULL,
      15,
      1.195235,
      1.383968,
      16,
      1,
      1.404880,
      1,
      9,
      5.739940,
      0.876882,
      3,
      NULL,
      0,
      1.370024,
      9,
      0.235387,
      NULL,
      NULL,
      1.412020,
      NULL,
      NULL,
      NULL,
      0.244034,
      NULL,
      NULL,
      1.049650,
      NULL,
      NULL,
      0.264356,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      1.176218,
      NULL,
      2.941683,
      3.237478,
      1,
      1.707910,
      NULL,
      6.852440,
      4.252998,
      1.534263,
      0,
      NULL,
      5,
      8,
      NULL,
      0,
      3.531873,
      NULL,
      0,
      2.083293,
      2,
      NULL,
      3.311593,
      19,
      1,
      NULL,
      NULL,
      3,
      3,
      3.180286,
      NULL,
      NULL,
      5,
      1,
      0.727671,
      NULL,
      NULL,
      3.905688,
      3.538802,
      NULL,
      NULL,
      6,
      0,
      4,
      1,
      2,
      1,
      NULL,
      NULL,
      2.869130,
      1.705641,
      1.588689,
      2,
      NULL,
      2.872721,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288693,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.297630,
      NULL,
      NULL,
      2.153882,
      NULL,
      NULL,
      0,
      NULL,
      0.620161,
      3.027936,
      NULL,
      2.412283,
      1,
      NULL,
      0,
      2.270655,
      NULL,
      0.167328,
      3,
      NULL,
      0.499901,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4.019990,
      91,
      NULL,
      2,
      0.632778,
      3.992901,
      3.914296,
      0.213650,
      0.091425,
      0,
      8,
      NULL,
      5.513675,
      2.755285,
      3.758748,
      NULL,
      1041.628975,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.729644,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.051832,
      0,
      1,
      NULL,
      0.185972,
      NULL,
      1,
      NULL,
      0.983403,
      NULL,
      3.618139,
      NULL,
      2.979735,
      NULL,
      0,
      NULL,
      0.418328,
      NULL,
      1,
      NULL,
      6,
      NULL,
      1.249149,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      2.612759,
      NULL,
      1.130596,
      0.778322,
      NULL,
      NULL,
      0.417754,
      1,
      NULL,
      NULL,
      0.425301,
      1,
      0.715979,
      NULL,
      0.983075,
      NULL,
      1,
      NULL,
      1,
      1.889379,
      0.448316,
      NULL,
      0.144576,
      NULL,
      0.405573,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.709221,
      1,
      NULL,
      NULL,
      NULL,
      3,
      6,
      2,
      NULL,
      35,
      49.262065,
      2,
      NULL,
      2.241060,
      NULL,
      NULL,
      NULL,
      1.766487,
      NULL,
      NULL,
      3.390278,
      22,
      NULL,
      1.424994,
      NULL,
      NULL,
      3.317593,
      18,
      0,
      1140,
      34,
      0.944990,
      0,
      1.885283,
      3.270352,
      1.230084,
      0.426650,
      1.464028,
      3.945347,
      NULL,
      3,
      1.148093,
      0,
      0,
      2,
      NULL,
      NULL,
      1.919082,
      NULL,
      NULL,
      1.096647,
      NULL,
      3.778194,
      NULL,
      2.986191,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.315207,
      16.716110,
      38.156246,
      2.036439,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.617514,
      NULL,
      3,
      NULL,
      2.716963,
      NULL,
      0,
      NULL,
      2.245093,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.549703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.820265,
      NULL,
      0.742822,
      2,
      NULL,
      1.691312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734815,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.642346,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0.037768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.528006,
      0.555372,
      3,
      NULL,
      NULL,
      NULL,
      1.623079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.869966,
      NULL,
      1.669360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1,
      1,
      0.600440,
      2,
      1.190994,
      3,
      NULL,
      3.974926,
      1.061200,
      0,
      0,
      1,
      0.098231,
      0.327252,
      1,
      NULL,
      NULL,
      1.085629,
      NULL,
      1.657980,
      0,
      2.615608,
      0,
      1.987648,
      0.458251,
      0,
      0.966089,
      2,
      NULL,
      1.160644,
      3.109654,
      0.785710,
      0.473481,
      0.788884,
      16,
      0.123107,
      NULL,
      2,
      1.449894,
      2,
      0.293425,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188929,
      0,
      0,
      1.056920,
      0.506049,
      0.577168,
      4,
      2,
      4,
      2,
      NULL,
      1.647988,
      21.210687,
      15.050672,
      3,
      0,
      NULL,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      3.827838,
      '11420',
      NULL,
      '');
commit;
end;
/


