set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7150548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      '2110',
      1.761589,
      1,
      NULL,
      NULL,
      NULL,
      42.327020,
      NULL,
      0,
      0,
      2,
      ' 9-11-1996',
      20,
      NULL,
      173,
      57.540038,
      0,
      ' 1-28-1995',
      ' 7- 9-2000',
      ' 7-24-1976',
      3,
      NULL,
      1,
      3,
      1,
      3,
      3,
      NULL,
      0,
      83,
      7,
      0.557615,
      1.691434,
      19.308548,
      16,
      NULL,
      7,
      3,
      4,
      8.828579,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0,
      2,
      3,
      NULL,
      0,
      6.616794,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.132428,
      0,
      0,
      NULL,
      1,
      0,
      1,
      3,
      0,
      1,
      1.370805,
      2.906024,
      1.561056,
      1.389051,
      2,
      1,
      5,
      1,
      0,
      4,
      0,
      0,
      1,
      0.258417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      4,
      4,
      1,
      NULL,
      1,
      0,
      0,
      0,
      2.108164,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0.035671,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      5,
      5,
      3,
      2,
      1,
      3,
      5,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      5,
      3,
      NULL,
      1,
      5,
      2,
      1.953822,
      0,
      ' 7-25-1985',
      593.732587,
      ' 0-29-1996',
      NULL,
      0.021215,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.271101,
      2,
      3,
      1,
      0,
      1,
      2,
      16.878372,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.763031,
      1.481049,
      5,
      NULL,
      0.374601,
      1.625548,
      3,
      1.069471,
      NULL,
      NULL,
      2,
      9.998533,
      3,
      0,
      3,
      1,
      NULL,
      ' 2-19-1974',
      NULL,
      ' 0- 4-1982',
      25.377568,
      0.445645,
      1,
      NULL,
      3.643858,
      0.474715,
      NULL,
      1,
      0.842140,
      1.603182,
      0,
      3,
      25.628444,
      1,
      0.445489,
      NULL,
      NULL,
      NULL,
      0,
      1.332379,
      1.979893,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      1.591145,
      0.141960,
      2.576873,
      1.747676,
      NULL,
      0,
      5,
      1.115167,
      NULL,
      1.857206,
      NULL,
      1.257764,
      NULL,
      NULL,
      1.323949,
      1,
      5.110986,
      2,
      0,
      7.232746,
      4,
      NULL,
      3.419715,
      7,
      NULL,
      0.576847,
      3,
      7,
      NULL,
      NULL,
      1,
      15,
      1,
      0.773118,
      NULL,
      50,
      NULL,
      6,
      1,
      0,
      2,
      '42110',
      '',
      '',
      0.586794,
      '',
      '',
      '',
      0.234487,
      '',
      '',
      '',
      NULL,
      39,
      NULL,
      24,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182802,
      0.995711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659384,
      NULL,
      NULL,
      1.870830,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.303255,
      1.151062,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517256,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776440,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.039211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.226463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337888,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.852707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.616304,
      NULL,
      NULL,
      3,
      2.514734,
      0.107492,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437580,
      NULL,
      NULL,
      NULL,
      1.139593,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.563504,
      NULL,
      NULL,
      1.285099,
      2.482891,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.246232,
      6.725140,
      1.851312,
      NULL,
      0.544742,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      1,
      NULL,
      2.498409,
      2.376345,
      NULL,
      3,
      3.073866,
      1.399900,
      0,
      2.682112,
      3.049781,
      2.228365,
      2,
      1,
      3.379880,
      3,
      1.531224,
      3,
      2.502729,
      0,
      6,
      NULL,
      4.330008,
      3.991371,
      4.695074,
      1.464553,
      0.968418,
      NULL,
      NULL,
      0,
      0,
      0.329638,
      1,
      1.769349,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.418086,
      0,
      1,
      NULL,
      0.242719,
      0.875492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091710,
      NULL,
      NULL,
      NULL,
      3,
      5.097598,
      0.705147,
      2,
      NULL,
      1.180952,
      0,
      NULL,
      NULL,
      1.811652,
      0,
      NULL,
      0.561011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.292962,
      NULL,
      0,
      0.702317,
      1.403446,
      1.765360,
      1,
      0.801626,
      1.987846,
      1,
      0,
      0,
      NULL,
      0.893425,
      1,
      1,
      1,
      0.647091,
      1.846069,
      1,
      1,
      NULL,
      0.283695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      0.252307,
      1.440052,
      2.816295,
      1,
      8.800298,
      0.324891,
      1,
      2,
      2.035184,
      3,
      2.890497,
      2.084266,
      2,
      2.767778,
      2.836120,
      1.670975,
      2.873942,
      0.941964,
      0.354409,
      0.334884,
      NULL,
      3,
      NULL,
      1.844652,
      3.367302,
      2.411307,
      1.188817,
      3.591624,
      3.683653,
      3,
      NULL,
      0,
      0,
      1,
      0,
      1.083172,
      2,
      0.346984,
      3,
      NULL,
      2,
      NULL,
      2,
      0.461002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.572333,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.646630,
      NULL,
      3.936652,
      NULL,
      0.288151,
      NULL,
      1.470760,
      2.340781,
      NULL,
      3.170041,
      1.582036,
      NULL,
      0.358371,
      0.379436,
      0,
      12,
      NULL,
      NULL,
      0.761143,
      0.656605,
      0,
      1.697130,
      NULL,
      0,
      1,
      NULL,
      3,
      2.327873,
      NULL,
      2,
      76.052757,
      71,
      4,
      0,
      1,
      '13332',
      '',
      NULL,
      2,
      '24041',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


