set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      3,
      NULL,
      3.462728,
      1,
      3.061891,
      NULL,
      1,
      '130',
      '01324411',
      22.025745,
      NULL,
      '4330030',
      NULL,
      0.577140,
      5,
      0,
      '4021',
      3,
      1.293130,
      NULL,
      NULL,
      ' 2-27-1988',
      12,
      25.106440,
      NULL,
      NULL,
      NULL,
      ' 0-13-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3- 4-1977',
      ' 4-25-1974',
      ' 4- 8-1977',
      3,
      0.038391,
      2.627795,
      2.553341,
      0.967763,
      NULL,
      2,
      3.107058,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.462616,
      1,
      0,
      NULL,
      1.444005,
      0.664870,
      1,
      NULL,
      0.385346,
      0.308681,
      0,
      1,
      4,
      4,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.902760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.994915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      2,
      0,
      0,
      2,
      0,
      3,
      NULL,
      1,
      6.958139,
      0,
      1,
      0,
      1,
      0.493316,
      NULL,
      1.946530,
      0,
      3,
      NULL,
      1,
      0,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      5,
      1,
      5,
      4,
      0,
      5,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5,
      3,
      NULL,
      3,
      ' 8-25-1979',
      NULL,
      ' 7-19-1977',
      2.572688,
      3.140076,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      5,
      0,
      0.481095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890050,
      2.991052,
      3,
      0.898346,
      NULL,
      2.524520,
      1.948155,
      NULL,
      0.351158,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.379594,
      1.137654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.354096,
      1.043700,
      0,
      0,
      NULL,
      0.724417,
      27,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.365246,
      0.505573,
      2,
      3,
      2,
      0,
      3,
      1,
      0,
      3,
      3,
      0,
      5,
      0,
      1,
      0.271922,
      NULL,
      1.401255,
      NULL,
      1.646158,
      0,
      1,
      0,
      0.369765,
      0.632777,
      0.669632,
      0,
      0,
      3.183408,
      NULL,
      0,
      11,
      6,
      3.799022,
      6,
      NULL,
      6,
      0.965669,
      2.419835,
      6,
      0.673658,
      2.541748,
      1.019260,
      22,
      NULL,
      0,
      5,
      NULL,
      71,
      49,
      4,
      1.847932,
      3.462978,
      '34330',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.376634,
      13.298610,
      94,
      10,
      1.477247,
      22,
      0,
      1,
      1,
      0.177656,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.944894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.667372,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.578787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238736,
      NULL,
      NULL,
      0.594642,
      NULL,
      0.839715,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.883679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126853,
      NULL,
      NULL,
      1.595199,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.191814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.551691,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.620559,
      NULL,
      1.232970,
      NULL,
      NULL,
      NULL,
      3,
      1.089438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357917,
      NULL,
      NULL,
      3,
      0.848208,
      1,
      2,
      0,
      0.225040,
      3.277317,
      0,
      0.122928,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.244850,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.084824,
      3,
      NULL,
      NULL,
      3,
      3.893675,
      1.022864,
      5.945058,
      2.828153,
      0,
      0.459201,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.689259,
      0,
      1,
      1.092197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.367389,
      1,
      1.193831,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      0.929459,
      0.427449,
      0.403171,
      NULL,
      NULL,
      0.019825,
      0.506469,
      NULL,
      1,
      NULL,
      NULL,
      0.239298,
      NULL,
      NULL,
      1.745630,
      NULL,
      0,
      160,
      2.346467,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.690660,
      0,
      0.200639,
      3,
      NULL,
      NULL,
      1.878031,
      1,
      NULL,
      1.528534,
      0,
      3,
      NULL,
      1.295571,
      NULL,
      0.426394,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.034118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018372,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541887,
      0.472401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183343,
      1.839231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427548,
      1.827264,
      1.368443,
      1.289280,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0.632582,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      3,
      3.978761,
      1.505822,
      2,
      10.305180,
      1.245258,
      3.872211,
      NULL,
      1.406797,
      0.817133,
      NULL,
      NULL,
      1.905187,
      NULL,
      1.355378,
      1,
      NULL,
      0.795935,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.534921,
      0,
      NULL,
      2,
      1.485029,
      NULL,
      0,
      NULL,
      NULL,
      0.248204,
      0,
      NULL,
      NULL,
      1.262705,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.521629,
      NULL,
      1.681227,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      14.630133,
      3,
      1.824560,
      3.601176,
      '40011',
      '',
      '',
      1.399833,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


