set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      NULL,
      1,
      2,
      3.237217,
      2.103699,
      NULL,
      '433',
      '33103420',
      30.691314,
      18,
      '2021442',
      2.745573,
      1.000009,
      3,
      2,
      NULL,
      1.562601,
      1.464582,
      NULL,
      NULL,
      ' 7- 9-1982',
      171.725288,
      145.899937,
      NULL,
      0.467028,
      3.809617,
      ' 7- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-1986',
      NULL,
      ' 2-10-1982',
      2.753487,
      3,
      3.233631,
      1.818735,
      1,
      1,
      0,
      NULL,
      0.423499,
      NULL,
      6,
      1.973685,
      2.243222,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.713754,
      2,
      1,
      0,
      1.810300,
      1.093482,
      1.647185,
      NULL,
      1.512231,
      NULL,
      0.340671,
      3,
      4,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      4,
      NULL,
      1,
      3,
      1,
      2,
      1.031507,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.185646,
      0.035299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      3.459764,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.561693,
      4,
      0,
      0,
      0,
      1,
      2,
      5,
      1,
      5,
      2,
      0,
      3,
      5,
      1,
      3,
      1,
      0,
      NULL,
      0,
      4,
      0,
      NULL,
      5,
      1,
      1,
      0.520116,
      0.022285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.838887,
      0,
      0.736594,
      0.589403,
      1,
      0.313394,
      5,
      5,
      NULL,
      0.890532,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.200208,
      1.561930,
      NULL,
      0,
      0,
      22.681342,
      NULL,
      1.557083,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875701,
      1,
      0,
      3,
      NULL,
      1,
      2,
      1,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      5.535705,
      0.678435,
      NULL,
      NULL,
      2.515959,
      1,
      0,
      NULL,
      NULL,
      1.944141,
      NULL,
      0.723412,
      1,
      0,
      NULL,
      6.673259,
      0.770762,
      2,
      6.053660,
      5,
      4.201601,
      1.914786,
      5,
      4.038756,
      3,
      NULL,
      1,
      3.779396,
      0,
      13.437506,
      3,
      NULL,
      40,
      NULL,
      84,
      NULL,
      3,
      4.660281,
      0.770077,
      '43334',
      '',
      '',
      0.901292,
      '',
      NULL,
      '',
      1.451751,
      '',
      '',
      '',
      1,
      26,
      172.080012,
      21.207166,
      NULL,
      32,
      NULL,
      0.730170,
      NULL,
      1,
      1,
      0.978535,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.363691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.574424,
      NULL,
      NULL,
      0.276004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.505303,
      0.487416,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185438,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531692,
      NULL,
      NULL,
      0.183219,
      NULL,
      NULL,
      3.028263,
      3.338096,
      NULL,
      1,
      NULL,
      NULL,
      4.003420,
      1,
      0.620421,
      3.481247,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.377213,
      1,
      0,
      0.230687,
      NULL,
      NULL,
      0.890627,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.804423,
      NULL,
      NULL,
      2.912319,
      0.135808,
      1.182360,
      NULL,
      0,
      0,
      6,
      0.842405,
      NULL,
      0.045167,
      1,
      0.564758,
      0.172781,
      NULL,
      NULL,
      2.352062,
      1.513314,
      0,
      1.259250,
      NULL,
      NULL,
      3.186788,
      1,
      0,
      3,
      0,
      0.472793,
      3.229046,
      1.638349,
      1.736343,
      NULL,
      1,
      1,
      2.129723,
      1,
      2.381194,
      2.732841,
      0,
      1,
      4,
      NULL,
      NULL,
      5.617514,
      1,
      0,
      3,
      1,
      0,
      1.354519,
      1.846958,
      1.122057,
      0.642408,
      0.800208,
      1.712711,
      NULL,
      NULL,
      0.477545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.838263,
      NULL,
      1,
      NULL,
      1.149312,
      1,
      2.858485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.965362,
      NULL,
      NULL,
      NULL,
      2.151848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.784950,
      NULL,
      NULL,
      NULL,
      0.706778,
      1.741967,
      NULL,
      NULL,
      0.412275,
      NULL,
      NULL,
      NULL,
      2,
      2.635611,
      NULL,
      NULL,
      1,
      1.908767,
      NULL,
      NULL,
      2.083721,
      0.619601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718769,
      NULL,
      NULL,
      NULL,
      0.641674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.336813,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.910561,
      NULL,
      NULL,
      1.872408,
      1,
      NULL,
      1.715204,
      NULL,
      NULL,
      1,
      0.580415,
      0,
      1.614357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027031,
      167.432433,
      0,
      NULL,
      NULL,
      0,
      2.748926,
      1.754821,
      NULL,
      0.559678,
      3,
      1,
      3,
      0,
      2.973943,
      0.808023,
      1.152097,
      0.594888,
      0,
      1.961214,
      0.215460,
      NULL,
      1,
      NULL,
      0.277023,
      NULL,
      1.377197,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.002962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297334,
      0.080624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473409,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.797343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.053475,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.422975,
      NULL,
      1.869413,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.508055,
      5,
      NULL,
      3,
      8.942980,
      3,
      1,
      2,
      0,
      0.708081,
      NULL,
      0.837546,
      1.441804,
      0,
      1,
      1,
      NULL,
      1.265983,
      0.674048,
      0.942928,
      1.021499,
      NULL,
      0.175444,
      0.907323,
      NULL,
      3.066731,
      2,
      0.136548,
      1.154884,
      0,
      1,
      0,
      1.489760,
      1,
      0.562091,
      0.367196,
      1.325857,
      2,
      1.527227,
      0,
      1,
      3.165242,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136618,
      1.928733,
      NULL,
      0.505014,
      0.068061,
      1,
      5,
      7,
      1,
      NULL,
      NULL,
      20.126088,
      97.525694,
      3,
      1.614557,
      1.687606,
      '44020',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


