set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      2.157398,
      1,
      2,
      2,
      '2100',
      2.073037,
      0,
      NULL,
      NULL,
      ' 1- 8-1991',
      31.325341,
      NULL,
      0,
      0,
      0,
      ' 1-29-1981',
      NULL,
      3.080104,
      NULL,
      51,
      0,
      ' 1- 6-1994',
      ' 1-18-2000',
      ' 9-10-1978',
      NULL,
      1.322251,
      1,
      2,
      1.729290,
      2.540369,
      NULL,
      0,
      0.459457,
      62,
      1,
      1,
      6.985793,
      13.815260,
      18,
      4,
      13,
      3,
      3,
      6,
      NULL,
      1,
      0,
      NULL,
      0.169940,
      1.074625,
      0.563719,
      0,
      1,
      NULL,
      69,
      3,
      NULL,
      2,
      3.090936,
      1,
      0,
      1,
      2,
      2,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      1,
      9,
      1,
      1,
      1,
      0,
      0.609726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      1.002282,
      1.263351,
      0.405485,
      2.967561,
      1,
      2.505695,
      0.343975,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3.546200,
      NULL,
      0,
      0,
      3.125550,
      NULL,
      0,
      1.537319,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      5,
      4,
      4,
      NULL,
      0,
      2,
      2,
      NULL,
      3,
      8,
      NULL,
      1,
      1,
      1,
      0.146504,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      3,
      3,
      4,
      1,
      NULL,
      2,
      5,
      5,
      1,
      5,
      NULL,
      4,
      4,
      0,
      NULL,
      1.955707,
      ' 9-17-1996',
      NULL,
      ' 0-15-1975',
      826.509904,
      2,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937316,
      0,
      0,
      1,
      1.957337,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.147598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.486293,
      0.461216,
      1.482819,
      0,
      0,
      1,
      3.221011,
      516,
      1,
      1.839432,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      2,
      1,
      2,
      1,
      1,
      NULL,
      2,
      1,
      3,
      0.333105,
      2,
      1.354379,
      1,
      1,
      0.068249,
      2,
      1.546440,
      NULL,
      0.729504,
      NULL,
      0.787109,
      1,
      0,
      1,
      1.616407,
      NULL,
      0.603274,
      5,
      1,
      4.513578,
      4,
      11,
      1,
      1,
      NULL,
      6.805783,
      2,
      2.537640,
      2,
      48.640498,
      1,
      2.347331,
      NULL,
      42,
      36,
      17.132942,
      2,
      1.096892,
      1.639131,
      '14241',
      '',
      '',
      1,
      '',
      '',
      '',
      0.894190,
      '',
      '',
      '',
      3,
      21,
      302.175018,
      14,
      2.456779,
      NULL,
      3.766102,
      86.764464,
      NULL,
      0,
      2.559680,
      1,
      0.569703,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.792737,
      NULL,
      NULL,
      2.099438,
      2.220871,
      1.091508,
      1.917331,
      NULL,
      NULL,
      0.895506,
      3.654784,
      1.495903,
      0.829636,
      NULL,
      NULL,
      1.574283,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      8,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.276966,
      0,
      1,
      NULL,
      3.843634,
      1.951649,
      3,
      NULL,
      2,
      NULL,
      NULL,
      3.370063,
      3,
      NULL,
      3.676464,
      3.736483,
      3.445788,
      NULL,
      NULL,
      1,
      0.217571,
      0,
      0.887489,
      2.131930,
      3.885284,
      0,
      NULL,
      NULL,
      1.974738,
      NULL,
      NULL,
      1.283412,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294738,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0.503321,
      3,
      3.331994,
      NULL,
      1,
      NULL,
      NULL,
      0,
      9.141292,
      3,
      0,
      NULL,
      3.720128,
      1.649160,
      NULL,
      NULL,
      7,
      3.908457,
      NULL,
      1.692392,
      NULL,
      NULL,
      1.776771,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.980896,
      NULL,
      NULL,
      1.812769,
      NULL,
      NULL,
      1.699789,
      0.083670,
      2.696447,
      2.785420,
      3.765751,
      0,
      5,
      3,
      3,
      4.277713,
      8,
      4,
      NULL,
      NULL,
      1,
      0.662192,
      3,
      NULL,
      0,
      NULL,
      0,
      2.997755,
      0,
      0,
      7.509620,
      4,
      NULL,
      NULL,
      1.841743,
      NULL,
      0,
      3.714740,
      2,
      1,
      2,
      2.232895,
      2,
      2,
      2,
      0.169918,
      6.693563,
      5,
      6,
      9,
      NULL,
      NULL,
      1,
      1,
      1.471346,
      NULL,
      0.321958,
      0.839158,
      0.878013,
      0.569124,
      NULL,
      NULL,
      3.182415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204181,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.814296,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.374028,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.279786,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904752,
      1,
      NULL,
      NULL,
      1.703319,
      1.585376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.395701,
      NULL,
      NULL,
      NULL,
      1.249465,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0.737226,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.657128,
      104,
      316.712990,
      2.790062,
      31,
      3.136169,
      1.326851,
      NULL,
      NULL,
      1.407438,
      3,
      0.889375,
      0.085996,
      206.857287,
      21.257965,
      NULL,
      NULL,
      NULL,
      2,
      6.582637,
      0.055357,
      133.931303,
      21,
      0,
      0,
      0,
      1.671043,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.770597,
      0,
      1,
      1.917573,
      0,
      0,
      0.064579,
      1.503053,
      0.927937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      2.638162,
      4.245508,
      1.834934,
      3,
      6,
      2.847473,
      NULL,
      0,
      NULL,
      0.014117,
      0.603356,
      0,
      1,
      2.984075,
      1.782090,
      2,
      0,
      NULL,
      1.922598,
      NULL,
      2.149963,
      2.975644,
      1.572157,
      0,
      NULL,
      NULL,
      3,
      0.802456,
      3,
      3.341555,
      NULL,
      NULL,
      0.322041,
      1,
      3.715347,
      NULL,
      1.992860,
      2.422134,
      1.073418,
      3,
      2.090655,
      0,
      0.207758,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908590,
      0,
      1.244377,
      NULL,
      1.382250,
      1,
      0,
      0,
      1,
      1,
      1,
      0.665904,
      NULL,
      14.098960,
      3,
      0,
      7.250550,
      '01103',
      NULL,
      '40423',
      0.013575,
      '',
      '',
      NULL,
      NULL,
      '34123',
      '',
      '');
commit;
end;
/


