set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8426905';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.378484,
      0,
      0,
      '4444',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      ' 6- 1-1985',
      77.832970,
      2.999491,
      177,
      30,
      3,
      ' 9-13-1992',
      ' 4-14-2000',
      NULL,
      2.168430,
      0,
      1,
      3.046724,
      0.692725,
      1,
      0,
      NULL,
      NULL,
      77,
      NULL,
      10,
      7.235454,
      3,
      11.996365,
      3,
      18.859869,
      NULL,
      2,
      6,
      NULL,
      1,
      1,
      1,
      NULL,
      0.159198,
      1,
      1.618933,
      0,
      1,
      187.674220,
      6,
      2,
      5,
      2.442755,
      1,
      1,
      3,
      0,
      1,
      NULL,
      0,
      2,
      1,
      1,
      0,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.587380,
      NULL,
      NULL,
      NULL,
      1,
      0.560348,
      1.750362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      0,
      1,
      1,
      0,
      1,
      3,
      1,
      1,
      4,
      0,
      1,
      0,
      0,
      1.630117,
      NULL,
      1,
      0,
      0,
      0,
      3,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      3,
      4,
      NULL,
      3,
      0,
      2,
      1,
      0,
      1,
      0,
      NULL,
      2,
      5,
      NULL,
      2,
      ' 4-15-1991',
      660.589767,
      ' 5-17-1976',
      893.432394,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      1,
      0,
      NULL,
      0.038490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.320725,
      0.014766,
      11.952914,
      0,
      7,
      6,
      0,
      0,
      NULL,
      NULL,
      1.822628,
      3,
      1.004725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833153,
      1,
      1.532749,
      1.315692,
      0,
      0,
      NULL,
      1.719850,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.387490,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      1,
      1,
      3,
      1,
      1,
      2,
      2,
      0.778297,
      1.332502,
      1.409397,
      0,
      4.041384,
      0.730792,
      0.066389,
      0,
      0.538375,
      1,
      1.326147,
      NULL,
      1,
      1,
      0.987438,
      0.469015,
      0,
      11.280803,
      2,
      3.235435,
      7.949777,
      6.024051,
      0,
      NULL,
      0.987720,
      6.932065,
      3.700279,
      0.101618,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      69,
      NULL,
      47,
      4,
      NULL,
      1,
      '43230',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.948372,
      '',
      NULL,
      '',
      2.051100,
      9.048348,
      91.904107,
      NULL,
      NULL,
      NULL,
      NULL,
      3.569023,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      3.943469,
      0.991542,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.851173,
      NULL,
      NULL,
      0.722030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.285012,
      NULL,
      2.206536,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.938827,
      NULL,
      NULL,
      NULL,
      0.885437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.295180,
      NULL,
      NULL,
      1.548871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      3.142379,
      1.520536,
      2.077975,
      6.177238,
      6.842505,
      1,
      3.180208,
      0,
      1.707354,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      NULL,
      NULL,
      0.961015,
      NULL,
      NULL,
      0.419217,
      NULL,
      NULL,
      2.559764,
      1.573485,
      NULL,
      1.712111,
      NULL,
      NULL,
      NULL,
      7.284180,
      5.648644,
      0,
      NULL,
      NULL,
      1,
      2.457139,
      1,
      1,
      NULL,
      5,
      2,
      7.571980,
      0,
      2.941231,
      NULL,
      NULL,
      NULL,
      2.205647,
      3.267541,
      NULL,
      1.281355,
      0,
      NULL,
      1,
      1,
      7,
      0,
      4.464592,
      NULL,
      1.249861,
      3,
      1,
      NULL,
      NULL,
      0.017654,
      NULL,
      NULL,
      1.450267,
      0,
      0.036851,
      9.266179,
      3,
      8.731127,
      5,
      NULL,
      3.261910,
      1,
      3,
      NULL,
      0.489802,
      1.831377,
      NULL,
      0.295466,
      0,
      1.363277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.500149,
      NULL,
      NULL,
      0.489680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.963310,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.449518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168558,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.997532,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2.912750,
      NULL,
      1,
      NULL,
      1.385146,
      272,
      193,
      1,
      154,
      NULL,
      0.056109,
      NULL,
      NULL,
      0.419335,
      42,
      5.353561,
      3.119617,
      25.597625,
      10,
      3,
      9,
      18,
      0,
      8.740494,
      1,
      761,
      50.389332,
      NULL,
      1.253975,
      0.797553,
      1,
      0.928323,
      0,
      1,
      1.810524,
      NULL,
      NULL,
      1.417007,
      1,
      0.792600,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      5.480783,
      7,
      3,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.782617,
      NULL,
      1,
      1.032265,
      NULL,
      1.937746,
      0.032249,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362517,
      2,
      NULL,
      1.948112,
      NULL,
      NULL,
      2.087774,
      0.005959,
      NULL,
      1.460637,
      1.768681,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.379336,
      1,
      NULL,
      3.854708,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      6,
      1,
      0.631264,
      2.228565,
      19.315604,
      17,
      1,
      0,
      1.424566,
      '43121',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.974769,
      '',
      '',
      NULL);
commit;
end;
/


