set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      0,
      5.187959,
      3.286646,
      2.991404,
      0.496470,
      1,
      3,
      '400',
      NULL,
      48,
      9.501624,
      NULL,
      3,
      1.808192,
      1,
      NULL,
      '3124',
      2,
      1.319457,
      NULL,
      NULL,
      '10- 2-1979',
      56,
      81,
      NULL,
      NULL,
      3,
      '11- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11- 8-1997',
      NULL,
      2.853431,
      0.704399,
      NULL,
      2,
      1.764161,
      1,
      8,
      1,
      NULL,
      NULL,
      NULL,
      8.141877,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1.114919,
      1,
      1,
      0.165451,
      0.510260,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      0,
      1,
      3.112118,
      0,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      7.973658,
      NULL,
      1,
      1,
      3,
      0.421327,
      NULL,
      2.029090,
      0,
      1,
      0.121373,
      0.453077,
      1,
      1,
      NULL,
      0.480666,
      0.499070,
      1,
      3,
      NULL,
      3,
      0,
      NULL,
      0.578481,
      0,
      NULL,
      NULL,
      0.586617,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      1,
      3,
      4,
      5,
      NULL,
      0,
      6,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.422448,
      NULL,
      2,
      3,
      3,
      1,
      1,
      2,
      4,
      0,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      1,
      5,
      4,
      3,
      NULL,
      4,
      7.554264,
      1.863493,
      ' 9-26-2000',
      NULL,
      ' 5-21-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      0,
      1,
      2,
      1.030463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.541075,
      0,
      1,
      0.257671,
      2.178844,
      0,
      1,
      5,
      1,
      NULL,
      7,
      1.782296,
      0.947079,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.906745,
      NULL,
      0.412556,
      0,
      0,
      1,
      0,
      2,
      NULL,
      0.580530,
      0.180949,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      3,
      1,
      2,
      2,
      0,
      3,
      3,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.257892,
      NULL,
      0.287187,
      1.290839,
      3.944933,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      2.343214,
      2.984706,
      1,
      NULL,
      NULL,
      0.062354,
      1.936848,
      5,
      2,
      NULL,
      3.801153,
      10,
      NULL,
      NULL,
      9,
      NULL,
      4,
      31,
      0,
      NULL,
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      38,
      21,
      NULL,
      0,
      52.801127,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.613896,
      NULL,
      2.518620,
      1.813275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.589697,
      NULL,
      1.901752,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.743776,
      NULL,
      NULL,
      1,
      5.745048,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.234271,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.204224,
      3.659170,
      1,
      0.806294,
      2.525890,
      0,
      1,
      3.381080,
      1.737633,
      0,
      1.107489,
      1,
      3.132838,
      0,
      NULL,
      2.698308,
      NULL,
      1.647984,
      0.519731,
      2,
      1.080435,
      0,
      0.431277,
      1.656310,
      NULL,
      0,
      2,
      1,
      0.242277,
      2,
      NULL,
      0.179615,
      5.184671,
      3.305530,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.889759,
      2.519665,
      0,
      0.033201,
      1.998949,
      0,
      NULL,
      1,
      NULL,
      2.241987,
      1.550562,
      NULL,
      NULL,
      1.781469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.248178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.960993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.809449,
      NULL,
      NULL,
      4.352726,
      1,
      4.954480,
      0.774424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.843503,
      0,
      2,
      0,
      3.153335,
      NULL,
      3,
      1,
      2,
      2,
      0.891295,
      1.558427,
      0.431194,
      NULL,
      NULL,
      0.230757,
      2,
      1,
      1,
      2,
      0.334700,
      2,
      NULL,
      3,
      1.821484,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      1.987924,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.573978,
      1.123894,
      0.850405,
      1.357713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452858,
      NULL,
      NULL,
      NULL,
      0.309458,
      1.586091,
      1,
      3.197042,
      NULL,
      0,
      1.964241,
      NULL,
      NULL,
      0,
      0,
      1,
      1.454248,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.971067,
      NULL,
      1,
      790.253724,
      13.723791,
      NULL,
      NULL,
      0,
      1.520081,
      0.156564,
      0,
      0.224600,
      0.265376,
      1,
      1.453671,
      0,
      2.916359,
      0.951992,
      1.092395,
      1,
      NULL,
      0.326499,
      2.193203,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.281177,
      NULL,
      1.161551,
      NULL,
      1,
      NULL,
      383,
      NULL,
      NULL,
      23.511170,
      55.352792,
      0,
      0.370033,
      NULL,
      NULL,
      1.849822,
      NULL,
      1.977411,
      NULL,
      1.049087,
      NULL,
      1.610135,
      NULL,
      1.564264,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.236379,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.707764,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.865919,
      0.030697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214716,
      1.342796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481372,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822818,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.349003,
      NULL,
      1.170654,
      1.316631,
      1.523282,
      1.929769,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.850686,
      1,
      1.259938,
      1.220492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      7,
      1.428455,
      2.694105,
      0,
      2,
      NULL,
      0,
      0.423623,
      1.719013,
      NULL,
      NULL,
      NULL,
      0,
      1.250451,
      NULL,
      1,
      NULL,
      NULL,
      0.629948,
      0.444916,
      NULL,
      1.984617,
      1.136188,
      NULL,
      0.818340,
      NULL,
      NULL,
      1.684858,
      0.162399,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.066740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.848256,
      1.087283,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      2,
      2,
      1.483183,
      NULL,
      NULL,
      30.550364,
      121,
      5,
      3,
      NULL,
      NULL,
      '34441',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


