set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '4222441',
      3,
      NULL,
      6,
      NULL,
      '4124',
      1.141921,
      0.803410,
      NULL,
      NULL,
      NULL,
      107,
      NULL,
      2,
      3,
      6,
      ' 8-27-2000',
      16,
      3.377828,
      121,
      92,
      3,
      ' 4-14-1996',
      '11- 0-1983',
      ' 1-19-1999',
      NULL,
      NULL,
      1,
      3,
      1.249452,
      3.586073,
      1,
      NULL,
      0.090702,
      4.236929,
      NULL,
      5,
      7,
      NULL,
      NULL,
      NULL,
      8,
      5,
      1,
      NULL,
      1.181434,
      NULL,
      1,
      0.106174,
      0,
      1.474702,
      0.177110,
      NULL,
      0,
      191,
      0,
      5,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      0,
      1,
      3,
      NULL,
      3,
      0,
      3,
      5,
      1.746866,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.765124,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      2,
      2,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      6,
      1,
      0,
      1,
      1,
      0.152424,
      NULL,
      1,
      1,
      5,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      3,
      0,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      ' 9-19-1991',
      90,
      ' 3- 3-1995',
      168,
      3.563363,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861003,
      1,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.068041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.774079,
      NULL,
      1.435705,
      1.596043,
      0,
      NULL,
      1,
      NULL,
      38.393224,
      NULL,
      0.477330,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      1,
      1,
      0,
      3,
      1,
      2,
      2,
      NULL,
      3,
      1.489470,
      NULL,
      1.826925,
      NULL,
      0,
      0,
      7,
      0.162063,
      1,
      1,
      1.229626,
      0,
      0,
      0.265782,
      0,
      1,
      1,
      0,
      NULL,
      7,
      9,
      5.683607,
      NULL,
      1.916433,
      5.436486,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      54.365288,
      NULL,
      0,
      NULL,
      6,
      NULL,
      36.095924,
      5,
      0.775681,
      NULL,
      '40244',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1,
      35,
      59,
      3,
      NULL,
      NULL,
      3,
      3,
      0,
      3,
      1.301594,
      2,
      1.479401,
      NULL,
      NULL,
      0.118868,
      NULL,
      NULL,
      1.692164,
      NULL,
      NULL,
      2,
      NULL,
      1.156018,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      1.524329,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.155687,
      NULL,
      NULL,
      3,
      0,
      NULL,
      6,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.792800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.876612,
      0.839445,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.459720,
      0,
      3.737556,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      7,
      3,
      0,
      NULL,
      NULL,
      0.847937,
      NULL,
      NULL,
      0.317170,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.653308,
      NULL,
      NULL,
      0,
      2.260692,
      NULL,
      1,
      2.642498,
      3,
      2,
      3.617791,
      NULL,
      5,
      0.176267,
      3.090746,
      1,
      NULL,
      NULL,
      1.766701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.518724,
      0,
      0,
      3,
      1,
      2,
      1,
      2.067513,
      2,
      NULL,
      1,
      2,
      2,
      2.588163,
      NULL,
      6.675204,
      2.474781,
      5,
      3.160371,
      2,
      NULL,
      NULL,
      3,
      0,
      0.222113,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858509,
      NULL,
      NULL,
      1.564590,
      NULL,
      NULL,
      0.433119,
      NULL,
      NULL,
      0.839683,
      NULL,
      NULL,
      0.230062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.969482,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101566,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.415536,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.789977,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.221125,
      NULL,
      NULL,
      NULL,
      3.226134,
      NULL,
      NULL,
      1.256306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.445284,
      0,
      1.964357,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0.605392,
      NULL,
      1.484145,
      1,
      0.066850,
      1.953784,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.489027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.247680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.069717,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.507784,
      NULL,
      1.061886,
      NULL,
      0.932527,
      NULL,
      1.582064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      5,
      0,
      0,
      1.155137,
      0,
      0,
      3.641812,
      NULL,
      NULL,
      1,
      1.108080,
      NULL,
      1,
      3.156394,
      NULL,
      0.470587,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.328947,
      1,
      NULL,
      1.109152,
      0,
      NULL,
      0,
      1.703858,
      NULL,
      1.425803,
      1.354360,
      NULL,
      NULL,
      2.032445,
      NULL,
      1.954893,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.910567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      20.831750,
      27.454956,
      5,
      0.338193,
      3.737293,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


