set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825995';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '3114241',
      NULL,
      1.417939,
      3,
      0,
      '1242',
      NULL,
      0,
      NULL,
      NULL,
      '10-22-1989',
      107,
      NULL,
      1,
      0,
      2,
      ' 2- 4-2002',
      70.676307,
      1.252957,
      330.212468,
      100,
      1,
      '10-21-1998',
      ' 4-29-1999',
      ' 8-14-2001',
      NULL,
      0.231310,
      2,
      NULL,
      0.421610,
      1.190347,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      9,
      25,
      1,
      7.940136,
      2,
      NULL,
      6,
      1.201222,
      1,
      0,
      1.086575,
      0.718377,
      1,
      NULL,
      1,
      1,
      NULL,
      0.637482,
      3,
      NULL,
      NULL,
      2.937769,
      4,
      1,
      0,
      3,
      NULL,
      2,
      2,
      1,
      4,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      0.722696,
      NULL,
      NULL,
      0.819104,
      NULL,
      NULL,
      5,
      1,
      8.549745,
      3,
      1.142508,
      1.897904,
      2,
      3.478787,
      3.010077,
      2,
      0,
      0.023047,
      NULL,
      1,
      1.262964,
      3.108095,
      0.689070,
      1.546667,
      0.372416,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0.005698,
      0,
      1,
      0,
      1,
      0.553781,
      NULL,
      NULL,
      3,
      NULL,
      5,
      4,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      3,
      4,
      1,
      5,
      1,
      NULL,
      1,
      2,
      5,
      1,
      1,
      0,
      3,
      ' 7- 8-1981',
      291.760642,
      ' 5-26-1979',
      76,
      0.297976,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.283508,
      1.284379,
      NULL,
      0,
      NULL,
      0,
      1.865760,
      NULL,
      0.931690,
      2,
      0,
      NULL,
      3,
      1.854563,
      NULL,
      1.535254,
      6,
      6,
      NULL,
      1,
      1.829082,
      2.688977,
      NULL,
      NULL,
      NULL,
      1,
      3.421820,
      1.059100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      NULL,
      0.836267,
      0.744390,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      3,
      2,
      1,
      1,
      1,
      NULL,
      3,
      1,
      0,
      3,
      1,
      0.612053,
      NULL,
      1,
      5.651001,
      NULL,
      0,
      1,
      0.061279,
      1,
      0,
      1.982096,
      1,
      1,
      1,
      0,
      NULL,
      6.158753,
      7.010036,
      2.013461,
      0,
      NULL,
      1,
      5,
      NULL,
      7,
      0,
      NULL,
      0,
      1.160108,
      0,
      3.824557,
      NULL,
      79,
      27,
      13,
      0,
      NULL,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      5.642862,
      '11104',
      '12444',
      '',
      2,
      33.534023,
      133,
      47,
      NULL,
      14,
      20,
      8,
      3,
      NULL,
      2.332087,
      1.532703,
      1,
      NULL,
      NULL,
      0.493505,
      NULL,
      NULL,
      0.326821,
      1.060748,
      NULL,
      3.163790,
      1,
      1,
      NULL,
      NULL,
      0.881307,
      3.220240,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      2,
      NULL,
      0.987197,
      1.266596,
      0,
      1.612568,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233444,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      0.788725,
      2,
      NULL,
      2.544931,
      3,
      0.921320,
      0.720931,
      0.089039,
      0.795325,
      0,
      2,
      0.331459,
      0,
      NULL,
      0,
      0.845892,
      NULL,
      NULL,
      0.905017,
      0.717706,
      NULL,
      0.029239,
      2.515413,
      1,
      0,
      3.793439,
      0,
      2,
      1.527793,
      0.128477,
      NULL,
      6.142496,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.618353,
      NULL,
      0,
      1,
      1.516858,
      2,
      2.225645,
      NULL,
      0,
      1.135994,
      NULL,
      NULL,
      2.394781,
      7,
      1,
      0.422930,
      2.452035,
      NULL,
      NULL,
      NULL,
      NULL,
      3.877241,
      0,
      4,
      0,
      NULL,
      NULL,
      1.754935,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185068,
      NULL,
      NULL,
      0.703950,
      NULL,
      NULL,
      0.770342,
      1.638563,
      1.909792,
      NULL,
      NULL,
      NULL,
      NULL,
      8.369052,
      2.960145,
      4,
      9,
      NULL,
      3,
      6.525505,
      3.298606,
      3,
      1.427538,
      2,
      NULL,
      2.491450,
      1,
      2,
      3,
      3,
      8,
      0,
      6.771951,
      0.043550,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.745562,
      0,
      3,
      2.189141,
      NULL,
      0.692891,
      6,
      0,
      3,
      0.102121,
      0.660123,
      3.981603,
      2.825077,
      2,
      4,
      0,
      0.405011,
      0.612259,
      0.765443,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.184422,
      NULL,
      NULL,
      1.547310,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.099561,
      NULL,
      NULL,
      NULL,
      2.609121,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.807207,
      NULL,
      NULL,
      NULL,
      1.144240,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.628845,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.768355,
      NULL,
      NULL,
      NULL,
      1.996318,
      NULL,
      NULL,
      NULL,
      0.884113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.246927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.126589,
      0.027041,
      1,
      0,
      2.490159,
      34,
      158,
      3.547247,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      4,
      0.245508,
      1,
      136,
      31.105963,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      48.701320,
      1,
      1.099510,
      0.807003,
      NULL,
      0,
      1.828647,
      1,
      1,
      0,
      0,
      NULL,
      1.444566,
      1,
      1.818904,
      NULL,
      0.881213,
      NULL,
      1.973884,
      0.981626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      0.168481,
      2,
      1,
      0,
      2,
      0,
      3.417758,
      1,
      1,
      0,
      NULL,
      0.998173,
      2.428351,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.904387,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.843570,
      NULL,
      NULL,
      1,
      3.724963,
      NULL,
      1,
      3.930406,
      NULL,
      0,
      2,
      NULL,
      3.558562,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0.190446,
      NULL,
      3,
      78.543862,
      81,
      0,
      3,
      2,
      '32001',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.675368,
      '23440',
      '23332',
      NULL);
commit;
end;
/


