set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8633212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '4102030',
      NULL,
      1,
      0,
      3,
      '2034',
      2,
      NULL,
      NULL,
      NULL,
      ' 1-14-2003',
      3,
      NULL,
      0,
      NULL,
      0,
      ' 9- 7-1991',
      76.016350,
      2.887430,
      280,
      NULL,
      3,
      ' 1-22-1984',
      ' 2-26-1979',
      ' 4-18-1982',
      3.311473,
      3.712278,
      NULL,
      3.615976,
      1,
      0,
      NULL,
      2.659237,
      NULL,
      NULL,
      NULL,
      5,
      1.659356,
      1.191948,
      1,
      5,
      16.055128,
      3,
      NULL,
      1,
      1.827358,
      1,
      0,
      0,
      1.196589,
      NULL,
      1.301640,
      NULL,
      1.690931,
      NULL,
      0,
      3,
      2,
      1,
      NULL,
      NULL,
      5,
      NULL,
      5,
      1,
      2,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      NULL,
      1.760721,
      2,
      1.471917,
      1,
      0,
      3,
      NULL,
      1.171960,
      2.190264,
      1.663458,
      NULL,
      NULL,
      3.492994,
      0,
      NULL,
      0,
      2,
      1,
      0,
      0,
      1,
      2,
      0.200151,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      5,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      2,
      1,
      1,
      1,
      0,
      0.542761,
      NULL,
      1.263130,
      0,
      NULL,
      1,
      1,
      1,
      0,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      4,
      NULL,
      3,
      1,
      1,
      2,
      1,
      0,
      0,
      3,
      ' 6-11-1979',
      434.427737,
      ' 3-27-1988',
      541.053242,
      NULL,
      0,
      1,
      3,
      2,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      4,
      NULL,
      5,
      0,
      NULL,
      0,
      3.727475,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.516078,
      0.963188,
      NULL,
      0.063760,
      0.058166,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.910511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.771280,
      1.039853,
      0.135620,
      0.818772,
      0.829977,
      0,
      41.155152,
      1.868610,
      1.249028,
      NULL,
      NULL,
      NULL,
      3,
      1.853335,
      2,
      3,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1.424821,
      0,
      1,
      1.245588,
      0,
      NULL,
      NULL,
      0.772222,
      0,
      NULL,
      1.422127,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1.403910,
      7.594476,
      10,
      3.316513,
      4,
      2,
      6.547817,
      1,
      1,
      NULL,
      22,
      3,
      1,
      NULL,
      44,
      10,
      68.427922,
      NULL,
      NULL,
      2,
      '24223',
      '',
      '',
      0,
      '',
      '',
      '',
      0.807096,
      '',
      '',
      '',
      3.465627,
      0.925087,
      81,
      23.907567,
      1.922563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.201702,
      1,
      0.854087,
      0.423097,
      1.498132,
      0.352039,
      2.798841,
      1.208678,
      1,
      0,
      NULL,
      NULL,
      1.092781,
      0,
      0,
      1.770088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.407873,
      NULL,
      NULL,
      5.286163,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.370520,
      0,
      0.018922,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.654315,
      0,
      NULL,
      0,
      NULL,
      2.374895,
      1.087480,
      0.760032,
      1.663244,
      1.956821,
      1.498699,
      NULL,
      0.441859,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.249879,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      2.374650,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.337769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.648160,
      1.877513,
      2,
      1.509547,
      NULL,
      NULL,
      1,
      0.625123,
      4,
      1,
      1.920071,
      NULL,
      NULL,
      NULL,
      1.608438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076175,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.077239,
      NULL,
      NULL,
      0.678827,
      NULL,
      NULL,
      1.810859,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.331747,
      NULL,
      NULL,
      5,
      0.965320,
      0.228163,
      0,
      NULL,
      NULL,
      0.689556,
      NULL,
      NULL,
      3.118657,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.940886,
      NULL,
      NULL,
      0.009965,
      NULL,
      1.348033,
      NULL,
      0,
      2.893811,
      3.145468,
      1.209681,
      NULL,
      1.332120,
      1.910434,
      0.673600,
      6.694480,
      1.994991,
      0.346095,
      NULL,
      NULL,
      NULL,
      2.069324,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.952654,
      1,
      1,
      1.225128,
      1,
      0.637546,
      NULL,
      3,
      NULL,
      5.943128,
      NULL,
      NULL,
      NULL,
      1.061624,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.817788,
      NULL,
      0.820328,
      NULL,
      0,
      NULL,
      1.157263,
      NULL,
      1.060534,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.262953,
      NULL,
      2.089452,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.533558,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.313638,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.368175,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      24.608129,
      NULL,
      2,
      160.536809,
      NULL,
      0,
      NULL,
      NULL,
      1,
      189,
      3.608770,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.213239,
      0.729046,
      1.386082,
      0,
      0.024376,
      0.621795,
      0.781290,
      0.318675,
      0,
      0,
      0.848176,
      1.711402,
      1,
      1,
      0,
      NULL,
      0,
      0.165091,
      0.609236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.200487,
      NULL,
      1.678464,
      1,
      NULL,
      0.899386,
      2.459851,
      3,
      3.733100,
      1,
      NULL,
      1.105571,
      1.426226,
      NULL,
      2.889921,
      0,
      NULL,
      1.644760,
      NULL,
      0,
      0.199273,
      1.166404,
      0.153843,
      2.603983,
      0,
      0,
      2.898566,
      0.100762,
      0.497006,
      1,
      0.125757,
      1.150317,
      1,
      0.594417,
      0.871040,
      NULL,
      1,
      0.614068,
      NULL,
      1.997563,
      0.760843,
      NULL,
      2.259760,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      4,
      6,
      1,
      NULL,
      NULL,
      111.985144,
      NULL,
      4,
      4,
      NULL,
      '12313',
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      1.840924,
      '',
      NULL,
      '');
commit;
end;
/


