set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1001332',
      3.097820,
      1,
      2,
      2,
      NULL,
      0.619680,
      1.691889,
      NULL,
      NULL,
      ' 9-23-1992',
      28,
      NULL,
      NULL,
      NULL,
      3.899633,
      ' 3-23-1995',
      11,
      1,
      137,
      129.014263,
      1,
      NULL,
      NULL,
      ' 2- 6-1983',
      NULL,
      1.513665,
      NULL,
      NULL,
      1.147689,
      0.091343,
      1,
      0.172925,
      NULL,
      NULL,
      NULL,
      8.892716,
      NULL,
      5.741335,
      14,
      0,
      1.100767,
      1,
      2,
      6.808322,
      0.794234,
      1,
      1,
      NULL,
      1,
      0.324108,
      0.123206,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      5,
      1,
      0,
      NULL,
      0,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      3.909140,
      2,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.572381,
      NULL,
      NULL,
      1,
      2,
      0,
      4,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      3.823998,
      NULL,
      1,
      1,
      0,
      NULL,
      1.818182,
      6,
      3,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      3,
      2,
      5,
      2,
      5,
      0,
      NULL,
      NULL,
      5,
      1.929224,
      NULL,
      56,
      ' 8-10-1987',
      23.323960,
      1.209946,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.663631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.494148,
      4,
      NULL,
      1,
      0.868309,
      1.799867,
      5.082309,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.369972,
      1.797937,
      8.345458,
      4,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      2.251102,
      4,
      1,
      0,
      NULL,
      1,
      6.727455,
      ' 6- 7-1976',
      7.062752,
      ' 4-24-2002',
      NULL,
      1,
      2,
      0,
      0.293537,
      0,
      1.973936,
      1.200305,
      NULL,
      1,
      1,
      3,
      NULL,
      1.633120,
      1.974840,
      NULL,
      NULL,
      NULL,
      1,
      0.094903,
      NULL,
      2,
      3,
      3,
      NULL,
      2,
      3,
      3,
      1,
      NULL,
      2,
      3,
      1,
      1,
      1.734992,
      NULL,
      NULL,
      1,
      1.041754,
      0.605310,
      2.879462,
      1,
      1.873171,
      3,
      NULL,
      1.782902,
      0,
      NULL,
      5,
      1.802390,
      8.755861,
      10,
      0.645402,
      3,
      NULL,
      4.064274,
      4,
      1.532462,
      4,
      2,
      NULL,
      3.770714,
      42.529161,
      3,
      NULL,
      NULL,
      47,
      10,
      70,
      NULL,
      3.125291,
      1.868730,
      '03123',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      74.299358,
      92.764852,
      52,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      0.943437,
      0,
      0.879232,
      NULL,
      NULL,
      NULL,
      0.657489,
      3.104138,
      0.568161,
      NULL,
      NULL,
      1,
      1.102312,
      1,
      NULL,
      NULL,
      NULL,
      0.407106,
      NULL,
      NULL,
      1.398874,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.796221,
      NULL,
      NULL,
      1.484561,
      3.292774,
      0,
      1,
      1.413337,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.544359,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.654231,
      NULL,
      NULL,
      1.850160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.282993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.860879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368459,
      NULL,
      NULL,
      3.730469,
      3.731038,
      3.148066,
      3,
      3,
      3.640154,
      4,
      1.988313,
      1.128979,
      2,
      4.596848,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0.590640,
      2,
      3,
      0.285661,
      0.470460,
      3,
      NULL,
      2.840605,
      1,
      5.465691,
      NULL,
      1.602181,
      3.434318,
      0.164471,
      3.864134,
      NULL,
      1.025855,
      1,
      3,
      2,
      0,
      NULL,
      0,
      NULL,
      0.811280,
      2,
      0.509772,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.926147,
      0,
      0,
      0.228750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.992448,
      1,
      NULL,
      3.425773,
      0,
      0.153277,
      0,
      7.359060,
      NULL,
      NULL,
      NULL,
      2.564914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152039,
      NULL,
      NULL,
      NULL,
      0.953447,
      NULL,
      NULL,
      NULL,
      1.263464,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.125334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.945985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.826327,
      NULL,
      NULL,
      NULL,
      0.552689,
      NULL,
      NULL,
      NULL,
      6.105448,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.500233,
      NULL,
      NULL,
      NULL,
      0.896557,
      NULL,
      NULL,
      1.106784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.732582,
      NULL,
      NULL,
      1.679705,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831138,
      0.656104,
      0.677215,
      0,
      0,
      NULL,
      1.267219,
      NULL,
      1,
      NULL,
      1,
      1.962196,
      1,
      1.358610,
      NULL,
      NULL,
      0,
      1.390226,
      NULL,
      NULL,
      0.005171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      5,
      0,
      3,
      NULL,
      1,
      5,
      1.976032,
      2,
      1,
      1,
      0.451074,
      NULL,
      0.080032,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.363251,
      NULL,
      1.809150,
      0,
      NULL,
      0.958374,
      0.444963,
      NULL,
      1.306926,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1.829744,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      2,
      3,
      1.392979,
      NULL,
      NULL,
      95.651799,
      119,
      1,
      2.447456,
      0.536581,
      '12121',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


