set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3200021',
      NULL,
      1.144292,
      2,
      2,
      '1100',
      NULL,
      0.411814,
      NULL,
      NULL,
      ' 5-27-2001',
      1,
      NULL,
      2,
      3,
      0,
      ' 0- 3-1985',
      8.981575,
      1,
      82,
      NULL,
      3,
      ' 5-27-1996',
      ' 6-22-1999',
      ' 4-25-1997',
      0.052083,
      1,
      3.909714,
      1.728766,
      1,
      NULL,
      6,
      1,
      NULL,
      NULL,
      7,
      9,
      0.979373,
      181.338205,
      74,
      3,
      15.229405,
      NULL,
      0,
      1.347129,
      1.615903,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1.126815,
      NULL,
      1.428462,
      0,
      NULL,
      NULL,
      4,
      3,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      5,
      1,
      4,
      1,
      0,
      0,
      0.474090,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.295584,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2,
      0,
      0.082629,
      3,
      3.810843,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      1.884623,
      2,
      1.923505,
      0.078668,
      3.448915,
      NULL,
      1,
      2,
      10.520232,
      1,
      1,
      1,
      0.957988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1.642764,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      4,
      5,
      NULL,
      0,
      1,
      3,
      0,
      5,
      NULL,
      2,
      0,
      0,
      5,
      5,
      5,
      5,
      0,
      3,
      1,
      NULL,
      7.053500,
      0.133443,
      '11-19-2000',
      926,
      NULL,
      1123.446161,
      2,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.170807,
      0,
      26.740123,
      2,
      1.462614,
      2,
      0.270803,
      1,
      NULL,
      NULL,
      2.853222,
      1.142747,
      10.720711,
      0,
      NULL,
      0.229374,
      0,
      2.311825,
      2,
      1,
      NULL,
      1.800136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.976722,
      NULL,
      0,
      0,
      1.320973,
      NULL,
      0,
      1.086582,
      NULL,
      1,
      0.854406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      2.955319,
      1.243080,
      3,
      5.589814,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.515031,
      0.436414,
      1.279962,
      0,
      3,
      2.088654,
      3,
      1,
      2,
      NULL,
      3.530332,
      9.716922,
      NULL,
      NULL,
      2,
      NULL,
      1.120621,
      2,
      0.121155,
      3,
      17.858421,
      1,
      2.379179,
      NULL,
      38,
      27,
      NULL,
      4,
      1,
      2.386558,
      '42013',
      '',
      NULL,
      0.469714,
      '',
      '',
      '',
      1.067311,
      '',
      '',
      '',
      2,
      17.955530,
      NULL,
      61.947281,
      NULL,
      18,
      5,
      5,
      NULL,
      NULL,
      1.283059,
      0.130569,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.253677,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088632,
      1,
      1,
      3.335383,
      2,
      0,
      NULL,
      3.104901,
      2,
      1.635081,
      NULL,
      NULL,
      0,
      0.203144,
      1.278163,
      NULL,
      NULL,
      NULL,
      8.242231,
      9.359916,
      7,
      0,
      0.360567,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.158001,
      3.677662,
      NULL,
      NULL,
      0.342495,
      NULL,
      3.685962,
      0.516453,
      1,
      1.389158,
      3.381392,
      3,
      2,
      NULL,
      0.811762,
      1.506398,
      NULL,
      0,
      1.988399,
      NULL,
      NULL,
      2.588628,
      3.109051,
      1.625288,
      NULL,
      NULL,
      1.470568,
      NULL,
      NULL,
      2,
      1.115586,
      NULL,
      NULL,
      2.207078,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.041128,
      NULL,
      NULL,
      3.747933,
      3,
      0,
      3.850109,
      2.888165,
      1,
      0,
      NULL,
      NULL,
      8,
      NULL,
      5.849691,
      NULL,
      NULL,
      NULL,
      1.024477,
      NULL,
      NULL,
      1.502148,
      NULL,
      NULL,
      0.469848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886510,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.744688,
      NULL,
      0,
      1.703257,
      NULL,
      NULL,
      8.007598,
      2.310162,
      NULL,
      8.556165,
      1.696477,
      5.339444,
      NULL,
      NULL,
      NULL,
      1,
      1.742565,
      0.993584,
      NULL,
      2.288227,
      2,
      3.199091,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1.516376,
      1.317897,
      3.836598,
      3.954678,
      1.429487,
      2.111850,
      3.949949,
      1.886231,
      3,
      2.558590,
      NULL,
      3,
      9.811884,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.811400,
      0.294546,
      0.165255,
      3,
      NULL,
      NULL,
      1.396014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613755,
      NULL,
      NULL,
      1.188221,
      NULL,
      NULL,
      1.234499,
      NULL,
      NULL,
      1.832409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.390839,
      NULL,
      NULL,
      NULL,
      0,
      0.609016,
      0.990220,
      1,
      0.103128,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.640655,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.834330,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.962048,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.237144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.846838,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      3,
      3,
      NULL,
      83.784473,
      NULL,
      39.680473,
      2,
      0.288742,
      NULL,
      NULL,
      1.564917,
      NULL,
      NULL,
      2,
      3.139730,
      0,
      1.034352,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      532,
      NULL,
      0,
      NULL,
      0.971688,
      0.736463,
      1.242436,
      1.673508,
      0,
      NULL,
      0,
      0.738969,
      0,
      1.864605,
      1,
      1,
      1,
      NULL,
      0,
      0.956889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.336191,
      0.986122,
      0.546264,
      1,
      NULL,
      3.861918,
      1,
      NULL,
      0.276886,
      0.485820,
      0.471708,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.716036,
      NULL,
      1.729865,
      0.195099,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.934220,
      NULL,
      NULL,
      1.426405,
      NULL,
      1.494776,
      1.216298,
      NULL,
      1.711250,
      NULL,
      NULL,
      NULL,
      3.349506,
      NULL,
      0.698584,
      NULL,
      NULL,
      0.222878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.141894,
      NULL,
      0.447476,
      NULL,
      4,
      6,
      NULL,
      1.174240,
      1,
      1,
      7,
      26,
      2,
      NULL,
      1,
      '24130',
      '',
      '',
      1.678541,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


