set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000083';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4434414',
      NULL,
      0,
      0,
      NULL,
      '1023',
      0,
      NULL,
      2.467074,
      3,
      ' 9-22-1988',
      NULL,
      NULL,
      NULL,
      1,
      0.505785,
      ' 9-28-1990',
      60.242137,
      0,
      NULL,
      110,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.303466,
      0.590487,
      5,
      0.315046,
      1.184660,
      NULL,
      5,
      6,
      2,
      4,
      1,
      NULL,
      16,
      1,
      1,
      5.494044,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.591800,
      1,
      0.391422,
      1,
      1.636510,
      0,
      0,
      0,
      3,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      10,
      2,
      0,
      NULL,
      0,
      0.058312,
      NULL,
      NULL,
      0.107180,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      5.120626,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      4,
      1,
      2,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      0,
      1,
      6.797280,
      NULL,
      0,
      1,
      0,
      0.565814,
      NULL,
      NULL,
      1,
      4,
      1,
      0,
      4,
      5,
      3,
      1,
      5,
      0,
      2,
      1,
      NULL,
      1,
      0,
      2,
      5,
      5,
      3,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      5.711241,
      NULL,
      ' 3- 2-2002',
      221.141643,
      NULL,
      NULL,
      3.770482,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0.681456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761454,
      NULL,
      9.803200,
      NULL,
      0,
      0.260551,
      1.189195,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566626,
      1,
      0.625411,
      1,
      NULL,
      1.382610,
      NULL,
      NULL,
      NULL,
      1.266852,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      6.626024,
      3.741923,
      5,
      NULL,
      NULL,
      1.784787,
      4,
      0,
      1,
      1.575627,
      NULL,
      0.864603,
      1.704760,
      1,
      0,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906904,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.853280,
      NULL,
      '02121',
      '',
      '',
      1.411023,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.856677,
      138.060857,
      68,
      1,
      2,
      97,
      2,
      1,
      0,
      NULL,
      3.018150,
      1.291362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.553472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.841670,
      NULL,
      NULL,
      6.789552,
      11.902475,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.749387,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121816,
      2.943452,
      11.508470,
      8,
      5.075123,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177327,
      1,
      1,
      2.490666,
      1.478689,
      0.384556,
      1,
      3,
      2.616981,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0,
      0.114612,
      NULL,
      NULL,
      1.634291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.190009,
      NULL,
      3.866295,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.020090,
      NULL,
      NULL,
      NULL,
      1.630200,
      NULL,
      NULL,
      8,
      NULL,
      8,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9.716452,
      9,
      1,
      NULL,
      3.589672,
      1.350258,
      1.226300,
      NULL,
      NULL,
      0.000662,
      NULL,
      NULL,
      1.362052,
      2.989701,
      1.687364,
      0.392039,
      2.300935,
      0,
      NULL,
      4,
      NULL,
      3.686001,
      1,
      0.663415,
      2.583083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.097706,
      9.985811,
      NULL,
      0.856731,
      0,
      7.955175,
      1,
      1.778221,
      1,
      0.023441,
      NULL,
      NULL,
      0,
      0,
      1.901459,
      0.477594,
      0.896622,
      3.175031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.084206,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.619043,
      0.272333,
      1.958239,
      1,
      0.105395,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464478,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223373,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1.706813,
      NULL,
      NULL,
      NULL,
      1.171884,
      NULL,
      NULL,
      0.826021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643124,
      NULL,
      NULL,
      0.959195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.582317,
      5014,
      1617,
      1,
      1,
      1.042206,
      NULL,
      1.987483,
      0.167427,
      1,
      0,
      0.489252,
      NULL,
      0,
      0,
      1.898100,
      0,
      0.198821,
      0.291965,
      0.328292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.446734,
      1,
      NULL,
      NULL,
      NULL,
      5.813900,
      1,
      2.565274,
      NULL,
      1,
      1,
      NULL,
      0,
      1.184757,
      NULL,
      0.451494,
      2,
      NULL,
      0,
      2,
      NULL,
      0.091365,
      1.144471,
      NULL,
      0.833580,
      3.197276,
      NULL,
      0.119592,
      1.117972,
      NULL,
      NULL,
      1.054714,
      NULL,
      1,
      2.000952,
      NULL,
      0.785480,
      0,
      NULL,
      1,
      3,
      NULL,
      3.226153,
      0.162500,
      1.394292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.598348,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      NULL,
      1,
      3,
      8,
      21,
      2,
      1.861277,
      NULL,
      '10310',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.416043,
      '',
      '',
      '');
commit;
end;
/


