set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.016226,
      2,
      1.887914,
      NULL,
      1.418443,
      3.174599,
      3.784957,
      1.179263,
      '304',
      '32243414',
      9,
      41,
      '3042310',
      2.162089,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '11-24-1988',
      8.658289,
      82,
      NULL,
      1,
      2,
      ' 1- 4-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8- 7-1983',
      ' 3-25-2001',
      ' 1-16-1988',
      1.057229,
      1,
      2.011474,
      1,
      NULL,
      2.085081,
      3,
      0,
      1.599224,
      14,
      4,
      5.017079,
      3.189919,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.860849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      0,
      0,
      9,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.687815,
      NULL,
      2.807363,
      1,
      1,
      2,
      1.273320,
      1.215062,
      2,
      NULL,
      1.377027,
      2.431466,
      NULL,
      NULL,
      2.869578,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      3,
      0.827511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      3,
      2,
      4,
      0,
      0.017275,
      NULL,
      1,
      1,
      1,
      0.833318,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      2,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      2,
      1,
      2,
      NULL,
      5,
      NULL,
      5,
      4,
      0,
      1,
      0.892865,
      NULL,
      ' 4- 7-1981',
      NULL,
      ' 1-13-1996',
      387,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8.703573,
      NULL,
      2.678001,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480976,
      NULL,
      4.183042,
      5,
      0.960964,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.930018,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.803720,
      NULL,
      0.906508,
      0.411755,
      0,
      1.367511,
      1.643409,
      NULL,
      NULL,
      0.021358,
      1.432799,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      2.234910,
      1.656066,
      NULL,
      0.320177,
      0.716140,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.756096,
      2.319859,
      0,
      10,
      3,
      1,
      1.311022,
      2,
      5.474292,
      5,
      1.260784,
      6.250281,
      3.160247,
      2.049219,
      0,
      26.555424,
      NULL,
      2.265309,
      67,
      NULL,
      10,
      32.329972,
      NULL,
      NULL,
      2,
      '00142',
      '10044',
      '32321',
      0.993916,
      '',
      '',
      '',
      2,
      '1102',
      NULL,
      NULL,
      2.761055,
      35.472330,
      78,
      11.165650,
      2,
      32.050611,
      2,
      9.244893,
      2,
      3,
      0.594798,
      2,
      NULL,
      NULL,
      NULL,
      1.121836,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939188,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.191139,
      3.544247,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      2.062178,
      NULL,
      1,
      0,
      NULL,
      1.112627,
      3,
      1.020982,
      2.600928,
      11.691344,
      0.470711,
      5.950148,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.593342,
      NULL,
      3,
      NULL,
      0,
      2,
      0,
      0.538271,
      1.953349,
      1.572302,
      NULL,
      2,
      0.987215,
      2,
      0.313476,
      NULL,
      2.361390,
      0.698958,
      NULL,
      0.520352,
      2,
      1.419319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.431585,
      0,
      1.538069,
      1.890421,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.943951,
      0.034883,
      0.070571,
      3.509280,
      3.281617,
      1.359527,
      NULL,
      1,
      NULL,
      NULL,
      3.859237,
      1.581383,
      1.414012,
      0.647855,
      2.337682,
      NULL,
      4.360602,
      NULL,
      2,
      3,
      1.713749,
      1,
      1,
      0.238636,
      3.461663,
      7,
      2.852932,
      0.224140,
      1.522827,
      NULL,
      NULL,
      0.359484,
      NULL,
      NULL,
      0.236131,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233837,
      NULL,
      NULL,
      1.884011,
      1.467661,
      0,
      1.162766,
      0.241493,
      2.122391,
      3.353068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722490,
      0.433473,
      3,
      NULL,
      3.012612,
      1.519336,
      0,
      2.005658,
      NULL,
      NULL,
      2.261542,
      1.828691,
      1,
      3,
      3,
      NULL,
      0.702208,
      0,
      1,
      3,
      3,
      2.820580,
      0,
      NULL,
      4.985864,
      5.295672,
      3,
      NULL,
      NULL,
      0.853319,
      0,
      4,
      0,
      1.917136,
      2.787919,
      1.571880,
      0,
      NULL,
      NULL,
      NULL,
      1.719173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.577253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.057463,
      NULL,
      NULL,
      3,
      1.487090,
      3,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.844321,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.176077,
      0,
      NULL,
      NULL,
      1.455103,
      NULL,
      NULL,
      NULL,
      1.740872,
      NULL,
      NULL,
      NULL,
      1.511913,
      NULL,
      NULL,
      NULL,
      2.494624,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.013675,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.615125,
      NULL,
      NULL,
      3.617600,
      NULL,
      NULL,
      NULL,
      13.995596,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5.882090,
      4,
      2,
      3,
      374,
      NULL,
      NULL,
      1.454890,
      0,
      1,
      NULL,
      NULL,
      0,
      9.331508,
      0,
      0.230360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.834260,
      NULL,
      0,
      1677,
      11,
      1,
      0.827216,
      NULL,
      2.170321,
      NULL,
      3.366750,
      2.003093,
      3.762779,
      0,
      NULL,
      NULL,
      0.242600,
      NULL,
      0.089529,
      1,
      3.147651,
      1.424553,
      3,
      NULL,
      NULL,
      0.260696,
      1.256989,
      NULL,
      1,
      0,
      0.279575,
      0.478241,
      2,
      2.788998,
      39,
      1,
      0,
      31,
      NULL,
      NULL,
      3.678573,
      0.959443,
      NULL,
      1.475316,
      1.524374,
      0,
      1.855378,
      1,
      1,
      1,
      1.021370,
      0,
      1.003712,
      1,
      1.997254,
      1.037023,
      0,
      NULL,
      0,
      1.381605,
      1.185152,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1.728302,
      3,
      1,
      1.369197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.210679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875247,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.627817,
      0.838233,
      1,
      3,
      NULL,
      736.992537,
      0,
      0,
      0,
      1.148009,
      1,
      1.637908,
      NULL,
      NULL,
      NULL,
      39.445541,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      3.796553,
      1.560199,
      1,
      0.698524,
      1,
      NULL,
      2.398166,
      1.590701,
      1.242460,
      0.632333,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.099800,
      NULL,
      0,
      2.613971,
      NULL,
      0,
      1.135359,
      NULL,
      1.906953,
      0,
      NULL,
      1.154728,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.217090,
      1.002612,
      NULL,
      0,
      1.931554,
      NULL,
      1,
      NULL,
      NULL,
      1.560945,
      0.974343,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.429335,
      NULL,
      0.987782,
      NULL,
      3,
      2,
      4,
      1.526854,
      NULL,
      NULL,
      2,
      22.572107,
      3,
      3.426393,
      NULL,
      NULL,
      '33442',
      '31423',
      0,
      '',
      NULL,
      '',
      0.966532,
      NULL,
      '',
      '');
commit;
end;
/


