set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.234803,
      NULL,
      NULL,
      3.389412,
      1.718048,
      1,
      2.409300,
      3.971311,
      '304',
      NULL,
      15.639300,
      NULL,
      '1423003',
      0,
      0.031465,
      0,
      3,
      '2031',
      2.181161,
      1.403418,
      NULL,
      NULL,
      NULL,
      156.563283,
      38.435987,
      NULL,
      1,
      0,
      ' 9- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490499,
      NULL,
      NULL,
      NULL,
      0.245842,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0,
      5.769409,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.972600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      3,
      NULL,
      0,
      5,
      0,
      NULL,
      4,
      0,
      NULL,
      9,
      1,
      0,
      2,
      0,
      0.743552,
      NULL,
      NULL,
      0.475120,
      NULL,
      NULL,
      0,
      4,
      5,
      1,
      3.191393,
      0.191582,
      3,
      1.395682,
      0,
      0.360962,
      2.303113,
      1.566349,
      3,
      0.402210,
      2,
      NULL,
      0,
      1.406354,
      0,
      0,
      0,
      0,
      1.811352,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      5,
      5,
      2,
      4,
      5,
      4,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1060,
      '11-20-1993',
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      0,
      1,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.962345,
      NULL,
      3,
      4,
      0.531879,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.719762,
      NULL,
      1,
      0,
      0,
      0,
      1.858150,
      1.811334,
      NULL,
      3.307598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      3.145096,
      NULL,
      1.768537,
      0,
      1.979906,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.302733,
      11.449678,
      5,
      2,
      11.171800,
      9,
      NULL,
      5,
      NULL,
      NULL,
      2.530026,
      3.476320,
      0.241106,
      NULL,
      3,
      0.627614,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '12322',
      '',
      NULL,
      1.152479,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      3,
      33.360208,
      114,
      22.839790,
      0.776730,
      0,
      NULL,
      0.851754,
      1,
      3,
      2.185904,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.215556,
      1.221753,
      0.712454,
      NULL,
      NULL,
      2,
      2.367333,
      2.977839,
      NULL,
      1,
      2.374825,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      2,
      0,
      3.981756,
      3,
      1.542282,
      1.307744,
      2,
      0.322072,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472275,
      0.025104,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      0.692174,
      2.268646,
      NULL,
      1,
      0.565185,
      0,
      1.567609,
      1,
      0,
      1,
      1.624095,
      2,
      0.759425,
      2.609972,
      3,
      1,
      1.784686,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.004213,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.858577,
      0.180117,
      3.807884,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      0.807962,
      1.545280,
      0.465532,
      3,
      2,
      NULL,
      0.525720,
      2,
      1,
      1.158402,
      0.611431,
      1,
      0.981632,
      NULL,
      1.244025,
      1,
      0,
      NULL,
      NULL,
      1.429758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.188013,
      NULL,
      NULL,
      1.951558,
      NULL,
      NULL,
      0.926534,
      1,
      3,
      0,
      NULL,
      3.694132,
      0.184649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858022,
      NULL,
      1,
      3.470194,
      3,
      2.332943,
      1,
      NULL,
      2,
      0.943806,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.007276,
      1,
      3.580632,
      NULL,
      1.827827,
      3.493499,
      0,
      NULL,
      5.749078,
      4,
      NULL,
      3,
      NULL,
      NULL,
      1.101450,
      2,
      NULL,
      0,
      0.217969,
      NULL,
      1.974333,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.544758,
      NULL,
      NULL,
      3.331316,
      NULL,
      NULL,
      1.412849,
      NULL,
      NULL,
      2.432047,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.405492,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      3,
      3.220310,
      1.747960,
      1.245882,
      NULL,
      2,
      0.758660,
      NULL,
      6.193633,
      0,
      NULL,
      NULL,
      0.024635,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.620735,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.407086,
      NULL,
      NULL,
      NULL,
      0.059367,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.806919,
      0.475621,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.614539,
      2.033325,
      NULL,
      NULL,
      0.372622,
      0.451012,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.695614,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4.496369,
      3,
      2,
      0,
      NULL,
      187.005917,
      0.113533,
      10.375036,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.582588,
      0,
      NULL,
      NULL,
      0.856037,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2153.461738,
      NULL,
      0.590855,
      3.532040,
      NULL,
      1.844854,
      NULL,
      1.572935,
      1.508956,
      0.319834,
      0.382300,
      0,
      NULL,
      3,
      1.663124,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513274,
      NULL,
      NULL,
      NULL,
      4.742407,
      33,
      94,
      0.133528,
      2.594761,
      0.211543,
      NULL,
      0.999182,
      NULL,
      1.768152,
      NULL,
      NULL,
      NULL,
      1.791571,
      NULL,
      0.477801,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.787646,
      NULL,
      1,
      NULL,
      0.812338,
      NULL,
      1,
      NULL,
      0.612888,
      NULL,
      NULL,
      NULL,
      NULL,
      3.977017,
      1.000963,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.339544,
      NULL,
      176,
      NULL,
      3.515616,
      NULL,
      0.004070,
      NULL,
      NULL,
      1.467373,
      2.364110,
      NULL,
      39,
      0.052181,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.446161,
      NULL,
      0,
      0,
      11,
      2.141754,
      1,
      2,
      NULL,
      3,
      1,
      0,
      1,
      1.897929,
      0.952105,
      3.014399,
      NULL,
      0,
      0,
      NULL,
      0.381176,
      0,
      1,
      0.938953,
      1.138966,
      0.779689,
      1,
      NULL,
      0.426369,
      1.379978,
      NULL,
      1,
      NULL,
      1,
      1.929686,
      1,
      1,
      0.977538,
      NULL,
      1,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.369691,
      1.800607,
      0,
      1.980684,
      1,
      5,
      7,
      NULL,
      NULL,
      NULL,
      6.286148,
      79,
      5,
      3.618484,
      4.276606,
      '00401',
      '23243',
      '04233',
      NULL,
      '',
      '',
      '',
      0.693962,
      '0112',
      '',
      '');
commit;
end;
/


