set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2334312',
      2,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      4,
      52.910666,
      NULL,
      21.860179,
      NULL,
      2,
      NULL,
      1.661844,
      '11-10-1980',
      33.532878,
      0,
      3,
      129.756199,
      0,
      NULL,
      NULL,
      NULL,
      0.636275,
      0.167253,
      NULL,
      NULL,
      1,
      0.857286,
      3,
      3,
      NULL,
      NULL,
      NULL,
      15,
      8.111180,
      10,
      10,
      4,
      24,
      NULL,
      2,
      NULL,
      1.145809,
      0,
      1,
      NULL,
      0,
      1.852642,
      0.843460,
      1.411060,
      1,
      NULL,
      0.326492,
      NULL,
      3,
      3,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.035542,
      1.306333,
      0.780572,
      0.451666,
      1,
      1,
      1.085774,
      1.877026,
      1.138784,
      1,
      0,
      2,
      0,
      1.722498,
      1,
      4,
      4,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      5,
      NULL,
      0,
      0,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      2,
      0,
      0,
      1,
      4,
      1,
      3,
      1,
      3,
      4,
      1,
      1,
      3,
      3,
      NULL,
      NULL,
      4,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4.590175,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426235,
      0,
      0.983897,
      1,
      NULL,
      0.085800,
      1.398193,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      1,
      3,
      1,
      0.139379,
      NULL,
      NULL,
      1.428157,
      3,
      0.131963,
      0,
      0,
      1.782279,
      NULL,
      NULL,
      0.167906,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599547,
      24,
      NULL,
      NULL,
      NULL,
      1,
      0.723642,
      2.246056,
      '03211',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '2244',
      NULL,
      '',
      1.386027,
      17,
      NULL,
      16.317698,
      3,
      25,
      6.633999,
      4.241734,
      3,
      NULL,
      0.955356,
      0,
      1.250819,
      NULL,
      NULL,
      0.481868,
      NULL,
      NULL,
      1.896857,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.616732,
      NULL,
      1.346015,
      1.270658,
      2.529286,
      0,
      0.192073,
      1,
      NULL,
      NULL,
      0.120018,
      NULL,
      NULL,
      3,
      3,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.572937,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940250,
      1.233890,
      2.609906,
      2,
      2,
      2,
      1.804469,
      NULL,
      NULL,
      0.135213,
      NULL,
      0.930263,
      0.700875,
      1,
      0.889561,
      1,
      2,
      NULL,
      2,
      3.884382,
      NULL,
      3.788405,
      NULL,
      1.827438,
      0.813563,
      3.913475,
      NULL,
      0,
      NULL,
      0.095289,
      0,
      0,
      1,
      0,
      NULL,
      0.009198,
      0,
      1.500901,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.695664,
      NULL,
      NULL,
      1.696937,
      NULL,
      NULL,
      NULL,
      1,
      1.792652,
      1.792987,
      2,
      0,
      1.978452,
      NULL,
      NULL,
      11,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.512568,
      NULL,
      NULL,
      0.780804,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.002597,
      NULL,
      NULL,
      0.805019,
      NULL,
      NULL,
      NULL,
      14.236177,
      1,
      0.791179,
      1.270381,
      1,
      0,
      0,
      1.263465,
      2,
      5,
      2.342675,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      3.001305,
      2.346727,
      0,
      0.859140,
      6,
      NULL,
      6.809395,
      3.193404,
      0,
      NULL,
      3.895045,
      0.068718,
      NULL,
      1.593872,
      1.476052,
      1.143791,
      2.969532,
      3,
      0,
      1,
      5.127019,
      NULL,
      1.748504,
      4.039963,
      NULL,
      1.644873,
      0,
      NULL,
      0,
      1.286361,
      NULL,
      1.288452,
      0.800973,
      0.410499,
      NULL,
      NULL,
      0.186386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208291,
      NULL,
      NULL,
      0.340449,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.725964,
      NULL,
      NULL,
      1.717512,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.369924,
      0,
      1.041833,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      181,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.323524,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897608,
      NULL,
      NULL,
      NULL,
      0.276694,
      3,
      NULL,
      NULL,
      2.816877,
      3.098120,
      NULL,
      NULL,
      3.785633,
      NULL,
      NULL,
      NULL,
      0.139763,
      1.270523,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.657020,
      3.234626,
      NULL,
      NULL,
      3.175022,
      1.073362,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.676227,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.582699,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.469127,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.415687,
      0,
      1,
      NULL,
      NULL,
      NULL,
      10,
      1.584496,
      5,
      1,
      1.104876,
      1.612356,
      0.330702,
      NULL,
      0,
      1,
      NULL,
      0.528693,
      0,
      NULL,
      NULL,
      NULL,
      1.398569,
      NULL,
      0.931126,
      1.704526,
      1.176256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      8,
      NULL,
      1,
      1,
      2,
      5,
      2,
      0.492839,
      3,
      0,
      NULL,
      0,
      0,
      2.564138,
      0,
      1.210297,
      1,
      2,
      NULL,
      1.684875,
      0,
      1.361131,
      2,
      3,
      0,
      0,
      0.044767,
      1.679113,
      3,
      0.546962,
      1.288501,
      1,
      1,
      0,
      NULL,
      3,
      1,
      3.400547,
      NULL,
      1,
      0,
      1,
      0,
      0.560849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.839996,
      NULL,
      0.875781,
      NULL,
      2.538724,
      NULL,
      NULL,
      NULL,
      1.615996,
      NULL,
      1.987293,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.086622,
      NULL,
      0.887616,
      NULL,
      1.176239,
      42,
      2,
      NULL,
      1,
      0,
      1,
      2.081564,
      NULL,
      0,
      2,
      5,
      3,
      3,
      1.007186,
      1,
      120,
      NULL,
      NULL,
      1.878336,
      1.784392,
      '12042',
      '00244',
      '',
      NULL,
      NULL,
      '',
      '',
      1.309295,
      '341',
      NULL,
      '');
commit;
end;
/


