set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7715855';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      1.988256,
      1.816603,
      1,
      2,
      '1201',
      0.839718,
      1,
      NULL,
      NULL,
      '11-15-1982',
      45.663182,
      NULL,
      NULL,
      NULL,
      1.571195,
      ' 9- 9-1998',
      28.476094,
      5.423494,
      340.858676,
      137,
      0,
      ' 0-29-1979',
      NULL,
      ' 9-26-1984',
      3,
      NULL,
      0.112464,
      0,
      NULL,
      0.348635,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      11.971106,
      5.431213,
      3.906188,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.336721,
      1,
      0,
      NULL,
      0.165304,
      0.536033,
      0.415006,
      NULL,
      0,
      0.023020,
      0.558973,
      4,
      2,
      3,
      2.371264,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0.968041,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      5,
      NULL,
      1.484529,
      NULL,
      1.954228,
      NULL,
      3.402069,
      3,
      0.169620,
      2,
      NULL,
      2,
      3,
      1.870945,
      0,
      NULL,
      1.910928,
      0.049942,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.004166,
      1.637102,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0,
      NULL,
      1,
      4,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0.131043,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.850099,
      3,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      3,
      0,
      1,
      2,
      NULL,
      1,
      5,
      2,
      NULL,
      0,
      2,
      NULL,
      0,
      2,
      NULL,
      4,
      2.702411,
      NULL,
      ' 0- 7-1988',
      16.333971,
      NULL,
      13.512347,
      0.962218,
      NULL,
      0,
      4,
      4,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      NULL,
      4,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      0.712039,
      3,
      1.739959,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.083501,
      2.983978,
      NULL,
      7.569639,
      NULL,
      3.014791,
      0.876144,
      NULL,
      NULL,
      1,
      15,
      1,
      2,
      2,
      NULL,
      NULL,
      ' 8- 9-1998',
      10,
      ' 3-10-1994',
      12.230287,
      0.622402,
      0,
      0.923226,
      NULL,
      NULL,
      NULL,
      1.088062,
      0,
      0.050783,
      NULL,
      NULL,
      26.345362,
      0.594517,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      3.813297,
      1,
      NULL,
      0.224353,
      NULL,
      NULL,
      4,
      1.812730,
      NULL,
      3.784081,
      0,
      NULL,
      NULL,
      1.074346,
      1.083408,
      NULL,
      NULL,
      3,
      0.749938,
      2.952848,
      NULL,
      NULL,
      2,
      5.087078,
      5,
      4.600387,
      2,
      NULL,
      0.720423,
      0.006215,
      0,
      NULL,
      3,
      3,
      NULL,
      16,
      8,
      25.758820,
      3,
      NULL,
      3.655068,
      NULL,
      '33302',
      '12112',
      2.337805,
      '21034',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      15,
      131.431920,
      NULL,
      NULL,
      51.001341,
      NULL,
      0,
      3,
      2,
      2,
      NULL,
      1.941729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.446042,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.723883,
      NULL,
      NULL,
      2.139766,
      0,
      NULL,
      0.816568,
      NULL,
      NULL,
      1,
      1.258052,
      NULL,
      1.831604,
      NULL,
      NULL,
      1.515386,
      NULL,
      NULL,
      0.542558,
      NULL,
      NULL,
      1.240240,
      0,
      0,
      2,
      1.707575,
      NULL,
      NULL,
      NULL,
      0.401312,
      0,
      NULL,
      NULL,
      NULL,
      1.392830,
      0,
      0,
      0,
      NULL,
      3.769922,
      0.384684,
      3,
      1,
      0.265328,
      1.488775,
      NULL,
      0,
      3.843113,
      1,
      2,
      1,
      2,
      0,
      0.411733,
      2.614031,
      NULL,
      0.226046,
      2,
      0,
      3,
      0.700368,
      2.478217,
      NULL,
      0,
      1.974556,
      0.084194,
      0,
      4,
      NULL,
      3.463609,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.809264,
      3.627269,
      1.041388,
      NULL,
      1,
      NULL,
      NULL,
      0.354545,
      3.548138,
      0,
      3.127447,
      1.699119,
      3,
      0,
      NULL,
      NULL,
      1.137744,
      4.353794,
      6.909067,
      2.055196,
      1,
      0.051863,
      2.183721,
      1.361673,
      0.707466,
      NULL,
      NULL,
      NULL,
      1.020335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.845842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.820476,
      NULL,
      NULL,
      0.760370,
      0,
      2.620455,
      1.990632,
      NULL,
      NULL,
      0.287518,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      0,
      0.566566,
      2.632125,
      1.086740,
      1,
      0,
      NULL,
      2,
      3.700431,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      4,
      3,
      0.701335,
      3.453354,
      2,
      NULL,
      NULL,
      1,
      1,
      0.484522,
      1,
      3.577063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.478271,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.758458,
      NULL,
      NULL,
      3,
      3.280514,
      NULL,
      1.592549,
      2,
      3,
      NULL,
      NULL,
      5,
      1.367473,
      0.952926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      1.873783,
      NULL,
      NULL,
      0.526446,
      NULL,
      0,
      NULL,
      1.853525,
      NULL,
      1.834222,
      NULL,
      NULL,
      NULL,
      1.106915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968749,
      NULL,
      NULL,
      NULL,
      0.915757,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.638776,
      3,
      1.900855,
      NULL,
      NULL,
      1.574285,
      0.887704,
      NULL,
      3.492641,
      3.027886,
      NULL,
      NULL,
      0.810436,
      NULL,
      2,
      NULL,
      NULL,
      2.087522,
      1.256450,
      NULL,
      2,
      0,
      2,
      NULL,
      0.917903,
      1.250781,
      NULL,
      NULL,
      3.834349,
      6.248277,
      6.907067,
      NULL,
      5,
      2,
      3.214351,
      3,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      201.226284,
      19.668715,
      1,
      1.915391,
      1.168033,
      0.687507,
      0.739563,
      NULL,
      2,
      3.945619,
      1.061711,
      NULL,
      1.931722,
      3,
      0.794850,
      NULL,
      0.419831,
      0.533876,
      NULL,
      3,
      1,
      3.454079,
      1,
      0.709265,
      NULL,
      NULL,
      0.789789,
      3,
      0,
      0.640307,
      1.744321,
      86,
      0.600874,
      2,
      18.891030,
      NULL,
      3,
      0.178968,
      1,
      NULL,
      2.012494,
      NULL,
      1.722834,
      NULL,
      0.240277,
      NULL,
      0.403440,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.232667,
      NULL,
      1.026359,
      NULL,
      3.110770,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.668768,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.258162,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.901608,
      NULL,
      1.294673,
      NULL,
      0.995665,
      1.084147,
      3,
      NULL,
      2,
      NULL,
      3,
      NULL,
      368,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.087931,
      NULL,
      NULL,
      0,
      2.870710,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      90.011538,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.012004,
      NULL,
      0,
      NULL,
      1.593083,
      NULL,
      24,
      NULL,
      2.400475,
      NULL,
      2,
      NULL,
      0.720733,
      NULL,
      NULL,
      NULL,
      716,
      NULL,
      2.604744,
      NULL,
      NULL,
      NULL,
      1.534722,
      1,
      2.653492,
      29,
      NULL,
      1,
      1,
      2.651315,
      0,
      NULL,
      2,
      1,
      3.472285,
      0.016067,
      1.209185,
      0.074770,
      3,
      NULL,
      NULL,
      2.463949,
      0.189203,
      NULL,
      0,
      0.512703,
      NULL,
      1.723522,
      2,
      1.660279,
      3.786584,
      3.703557,
      0,
      1.978697,
      0.450013,
      NULL,
      NULL,
      NULL,
      2,
      1.046228,
      2.676645,
      1,
      1.562912,
      0,
      NULL,
      1.820426,
      2,
      1.338978,
      NULL,
      0,
      0.699193,
      2,
      0.444916,
      0.077598,
      NULL,
      0.681308,
      1,
      3.188598,
      3.519960,
      NULL,
      3,
      NULL,
      3,
      3.190601,
      1.343620,
      0,
      1.467628,
      0,
      NULL,
      0.566463,
      1.886412,
      1.510012,
      1,
      1,
      0,
      NULL,
      0,
      2.291819,
      0,
      0.716601,
      1,
      1.794753,
      0.249895,
      0,
      NULL,
      9,
      3.778331,
      NULL,
      3.657309,
      1,
      2,
      NULL,
      2.053189,
      1,
      2,
      2,
      0,
      NULL,
      1.299744,
      NULL,
      NULL,
      3,
      3.425002,
      0.084516,
      0.090812,
      1,
      NULL,
      0.327374,
      0.435891,
      2.202773,
      0,
      1,
      3,
      0.394335,
      3.026503,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0.687413,
      2,
      6,
      7,
      0.715651,
      NULL,
      NULL,
      NULL,
      84.166756,
      2,
      1,
      0,
      NULL,
      '03001',
      NULL,
      1,
      '41322',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


