set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7715855';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1992',
      39.446000,
      NULL,
      4,
      1.438693,
      7,
      ' 5-11-2000',
      5.483833,
      NULL,
      16.960747,
      16.135319,
      0,
      NULL,
      ' 6-16-1995',
      ' 0-19-1999',
      0,
      1.650769,
      0.027596,
      NULL,
      0.787155,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      4,
      NULL,
      3,
      3,
      NULL,
      1.768950,
      0,
      0,
      1.796706,
      3.281704,
      0,
      NULL,
      1,
      0,
      0.398745,
      1,
      3,
      3,
      3,
      2.653513,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      1.407234,
      0,
      0,
      0.690925,
      0,
      0.712175,
      1,
      1.156884,
      3,
      1.750044,
      NULL,
      0.434060,
      0.949700,
      0,
      1,
      0,
      5,
      NULL,
      1,
      3.126563,
      0,
      NULL,
      NULL,
      0.942791,
      1,
      NULL,
      1,
      2,
      5,
      1,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.174769,
      0,
      1,
      0,
      NULL,
      1.575492,
      NULL,
      1,
      NULL,
      0,
      4,
      NULL,
      1,
      5,
      5,
      NULL,
      1,
      1,
      0,
      0,
      2,
      3,
      0,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      2,
      '10- 5-1990',
      3.359729,
      '10- 7-1988',
      13.247177,
      0.918973,
      2,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.441129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.961292,
      1.796736,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.597188,
      0.523836,
      1.444780,
      0.913612,
      NULL,
      1.138758,
      0,
      NULL,
      6.574501,
      6.678808,
      2.824368,
      4,
      2,
      2.374566,
      2,
      0,
      3,
      3.548879,
      2,
      2,
      NULL,
      NULL,
      ' 7-11-1991',
      8,
      ' 0- 6-1981',
      7,
      0.371253,
      2,
      0.846746,
      NULL,
      NULL,
      1,
      0.788361,
      0,
      0.842223,
      1,
      NULL,
      5.656566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.248978,
      2,
      0,
      2,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      3,
      0,
      3.164727,
      2,
      0,
      3,
      0.663669,
      1,
      0,
      1.488795,
      1.205144,
      1.934556,
      1,
      2.532263,
      1.115320,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      28,
      4,
      0.415354,
      6.665095,
      '32323',
      '22010',
      '21200',
      1.150347,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0.136860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      48.436684,
      5.097128,
      0,
      1,
      1,
      0,
      0,
      0.469737,
      3.416021,
      1.752797,
      3,
      2,
      1,
      0.358166,
      NULL,
      1,
      1.776704,
      0.193672,
      NULL,
      1.004065,
      1,
      0,
      1.616434,
      1,
      2.194905,
      0,
      1,
      NULL,
      3,
      2,
      NULL,
      16,
      3.085247,
      NULL,
      45,
      NULL,
      3,
      0.796262,
      2.085196,
      1,
      1,
      1,
      0.650735,
      0.873746,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.854594,
      1,
      NULL,
      1.492262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759967,
      NULL,
      1,
      1.346211,
      1.091228,
      1.108741,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724866,
      NULL,
      2.506641,
      NULL,
      3.031323,
      NULL,
      91,
      NULL,
      2,
      NULL,
      2.976427,
      NULL,
      1,
      NULL,
      2,
      1,
      0.234562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338366,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013235,
      NULL,
      346,
      NULL,
      0,
      NULL,
      2.911001,
      NULL,
      3,
      NULL,
      0.150975,
      10,
      20.761286,
      NULL,
      3,
      1,
      3,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.584801,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.254768,
      0,
      NULL,
      1.887237,
      0.254328,
      NULL,
      NULL,
      0.413018,
      NULL,
      1.881213,
      0.386249,
      NULL,
      0,
      0,
      NULL,
      1,
      1.806467,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.689246,
      0.872077,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.784884,
      NULL,
      1,
      6,
      3,
      0,
      NULL,
      NULL,
      59,
      13,
      4,
      0.332887,
      5.914533,
      '31223',
      '34314',
      '10102',
      1,
      '',
      NULL,
      '',
      1.272435,
      '',
      '',
      '');
commit;
end;
/


