set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7715855';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1203423',
      2.323103,
      0.167528,
      0,
      0,
      '2140',
      NULL,
      0,
      NULL,
      NULL,
      ' 7- 2-1996',
      2.239691,
      NULL,
      5,
      2.718057,
      1.065952,
      ' 5-10-1996',
      41.573975,
      5,
      31.079017,
      NULL,
      NULL,
      ' 0-23-1978',
      NULL,
      ' 6-19-1974',
      0,
      0.210289,
      3,
      3,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      10.224852,
      7.850675,
      11.429771,
      4,
      5,
      NULL,
      0,
      2,
      4.322454,
      NULL,
      0,
      1,
      NULL,
      0,
      0.606519,
      1,
      0,
      1,
      0,
      NULL,
      2,
      2,
      0,
      2,
      2,
      NULL,
      2,
      1,
      1,
      1,
      0,
      0,
      4,
      2,
      0,
      0,
      4.434297,
      0,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      3,
      0.620600,
      2.836246,
      1.064028,
      0.048069,
      0,
      NULL,
      2.193434,
      NULL,
      3.896901,
      NULL,
      0,
      0.216609,
      0.764776,
      1.937102,
      1.882607,
      3,
      NULL,
      0,
      NULL,
      1,
      2,
      3,
      0,
      3.072907,
      0.322711,
      NULL,
      NULL,
      1.909127,
      2,
      1,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.127177,
      4,
      1,
      4,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      5,
      1,
      1,
      2,
      0,
      0.302020,
      '11-26-1981',
      NULL,
      '11-23-1991',
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      13,
      2.845489,
      0,
      4,
      1,
      0,
      2.692435,
      NULL,
      4,
      3,
      3,
      0.279055,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.441333,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.976672,
      2,
      0.204975,
      16,
      2.906419,
      1,
      5,
      1,
      6.218303,
      ' 2- 3-1987',
      NULL,
      NULL,
      5,
      0.098025,
      1,
      0.822155,
      3.318126,
      1,
      0,
      0.235389,
      NULL,
      0.018864,
      1.941397,
      0.515239,
      12,
      3.876250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593100,
      1.219401,
      2,
      2,
      2,
      1,
      3,
      0,
      3,
      NULL,
      1,
      NULL,
      2.785677,
      1,
      2,
      2.940193,
      NULL,
      NULL,
      NULL,
      1.243287,
      1.323198,
      2.284781,
      1.307710,
      0,
      0.272540,
      1.313494,
      0,
      2,
      1,
      NULL,
      0.662066,
      8,
      9.329025,
      6.168001,
      NULL,
      8,
      5.922141,
      NULL,
      3,
      2,
      1,
      1.216660,
      3,
      16.006262,
      1,
      2,
      NULL,
      59,
      5,
      28,
      5,
      0.694548,
      6,
      '43311',
      '44021',
      '04324',
      3,
      '12344',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      NULL,
      225,
      41,
      NULL,
      NULL,
      1,
      0.081817,
      3,
      NULL,
      3.443276,
      2.059630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019231,
      0,
      0.132915,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.344981,
      0.357769,
      3.632681,
      2,
      1.570906,
      NULL,
      NULL,
      NULL,
      1.049113,
      1.881975,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      0.208729,
      1.532693,
      2,
      1,
      2.139942,
      0,
      1,
      1.295698,
      NULL,
      NULL,
      2,
      3.734269,
      NULL,
      1.156257,
      1,
      2,
      1,
      0.080601,
      0.660960,
      1,
      3,
      NULL,
      3,
      NULL,
      1.834352,
      1,
      0,
      0,
      3,
      NULL,
      1,
      4.029852,
      1.487765,
      2,
      0.667030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.970278,
      3,
      1,
      NULL,
      NULL,
      2.507874,
      NULL,
      1,
      0.930300,
      1.123163,
      2,
      1,
      NULL,
      NULL,
      9,
      4.295917,
      2.901921,
      NULL,
      3,
      NULL,
      2,
      0.998970,
      1.520678,
      3.726191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.315118,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671923,
      1.548094,
      0.843608,
      3.080577,
      0.450437,
      0,
      NULL,
      NULL,
      NULL,
      2.050656,
      3.869050,
      1.571652,
      NULL,
      NULL,
      NULL,
      4,
      5,
      0.610924,
      1.311286,
      1.722970,
      2,
      1,
      0,
      0.094805,
      1,
      0.597950,
      NULL,
      0.089900,
      NULL,
      NULL,
      NULL,
      3.669539,
      1,
      3,
      1,
      1.880527,
      2.694285,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      2.779029,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.093334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809921,
      NULL,
      NULL,
      4.575749,
      NULL,
      NULL,
      NULL,
      3.092909,
      2,
      NULL,
      1.731283,
      2.355913,
      0.071227,
      NULL,
      NULL,
      1,
      0.842969,
      NULL,
      21.287315,
      60.926471,
      NULL,
      NULL,
      0,
      0.711538,
      NULL,
      NULL,
      0.021106,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.240699,
      NULL,
      1.422964,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.495538,
      NULL,
      0.572502,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854764,
      NULL,
      NULL,
      NULL,
      3,
      1.211026,
      1.747279,
      NULL,
      1,
      1.560480,
      1.841262,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2.253001,
      NULL,
      1.310753,
      NULL,
      0.026645,
      3.628613,
      2,
      NULL,
      0.966931,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      6,
      NULL,
      2.373431,
      2,
      2,
      2,
      39,
      5,
      1,
      NULL,
      NULL,
      1.057304,
      31,
      NULL,
      0.421688,
      NULL,
      NULL,
      1.440114,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      18,
      0,
      2,
      1,
      2,
      0,
      1,
      3.270503,
      NULL,
      NULL,
      1.869534,
      1,
      2.323921,
      0.607669,
      3,
      NULL,
      0.902258,
      2,
      2.154641,
      NULL,
      1.193558,
      0.162242,
      NULL,
      0.208242,
      0.956019,
      1.736009,
      2.687672,
      1.632201,
      0.511388,
      1,
      64.614003,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3.915867,
      3,
      0.691987,
      0.005668,
      1,
      3.884696,
      0.760200,
      0,
      1.551325,
      NULL,
      NULL,
      1,
      1.740688,
      2.002449,
      NULL,
      2,
      1.686932,
      NULL,
      1,
      1,
      NULL,
      1.696313,
      1.709988,
      1,
      NULL,
      NULL,
      0.996612,
      1,
      NULL,
      1.924348,
      1.867168,
      1.087398,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654164,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.267904,
      NULL,
      1.223280,
      1.328703,
      NULL,
      NULL,
      3.405783,
      NULL,
      1,
      NULL,
      222,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.070911,
      NULL,
      3.517724,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      123.122859,
      NULL,
      0.575506,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.755186,
      1.279613,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587459,
      3.474825,
      NULL,
      3.025990,
      NULL,
      0,
      NULL,
      23.571568,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.212411,
      NULL,
      3,
      NULL,
      690.841972,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.267466,
      0,
      2.928548,
      31,
      NULL,
      2.976536,
      3.782406,
      0,
      5.859508,
      1,
      NULL,
      1,
      4,
      1,
      0.927025,
      NULL,
      2,
      3,
      0.247584,
      2,
      1.442377,
      0,
      NULL,
      0.414838,
      NULL,
      1,
      0,
      0.045489,
      0.039935,
      NULL,
      NULL,
      0.673511,
      1,
      NULL,
      2,
      3.510147,
      2,
      1.112993,
      NULL,
      0,
      0,
      0.025322,
      0.376178,
      NULL,
      NULL,
      1.438316,
      0.272994,
      NULL,
      2,
      1.859386,
      1.147112,
      0,
      NULL,
      1.895997,
      NULL,
      0.412526,
      NULL,
      0,
      1.498707,
      0.823393,
      1.945385,
      2,
      1,
      0.887205,
      NULL,
      NULL,
      1.033198,
      0,
      1,
      0,
      0.942590,
      NULL,
      NULL,
      1.335429,
      0.905569,
      2,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.288444,
      NULL,
      0.634158,
      NULL,
      NULL,
      NULL,
      2.081966,
      1.752082,
      0.162678,
      1.494434,
      1.325258,
      3.968480,
      0,
      0.876800,
      NULL,
      NULL,
      0.121723,
      2,
      1,
      0.944840,
      0.617883,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905530,
      0.120341,
      NULL,
      3.154927,
      NULL,
      1,
      0,
      0,
      1.901734,
      3.092058,
      1,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      126.433225,
      NULL,
      NULL,
      0,
      4,
      '14202',
      '01410',
      '40222',
      NULL,
      '23023',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


