set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2140304',
      2.892696,
      0,
      0,
      1,
      '0132',
      2.837856,
      1.927243,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      4,
      0.670116,
      0.794014,
      ' 5-12-1983',
      33.300329,
      NULL,
      NULL,
      93,
      1,
      ' 1- 4-1979',
      NULL,
      '10- 7-2000',
      0,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      NULL,
      5,
      2,
      17,
      2,
      24,
      1,
      1,
      1,
      1,
      1,
      0,
      1.008124,
      NULL,
      0,
      0.941431,
      NULL,
      1.694899,
      1,
      0,
      2,
      3,
      2,
      0,
      0,
      0,
      1,
      4,
      2,
      2,
      2,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.308247,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.100604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.431857,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      2,
      5,
      4,
      5,
      3,
      1,
      NULL,
      0,
      5,
      0,
      NULL,
      1,
      1,
      0,
      4,
      1,
      3,
      5,
      NULL,
      0,
      4,
      1.810989,
      NULL,
      ' 1-23-1995',
      491,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1.728995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      45,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.777099,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      8,
      NULL,
      0.829243,
      NULL,
      0.163825,
      NULL,
      NULL,
      NULL,
      1.193787,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430124,
      0.050024,
      0.955713,
      0.751286,
      NULL,
      1.416669,
      1.692954,
      2.648020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.443731,
      0,
      0,
      2,
      2,
      2,
      0,
      3,
      0,
      3,
      3,
      3,
      2.928612,
      2.269988,
      0.588918,
      2.830170,
      NULL,
      0.729793,
      0.799366,
      NULL,
      0.699786,
      0,
      0.009667,
      0.910775,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.977825,
      NULL,
      4,
      55,
      16.776970,
      5,
      NULL,
      2.843596,
      '00103',
      '',
      '',
      0.984726,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.233773,
      39.313059,
      18.789875,
      20,
      0,
      NULL,
      2,
      1.638772,
      3,
      1.267890,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.258805,
      NULL,
      NULL,
      NULL,
      0.338769,
      NULL,
      1,
      1.411173,
      1,
      2.566520,
      NULL,
      NULL,
      NULL,
      3,
      0.239694,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.133319,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      3.323610,
      1,
      0.207751,
      NULL,
      NULL,
      NULL,
      1.132459,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.789027,
      NULL,
      NULL,
      1.551654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.884744,
      3.238634,
      2.149904,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      4.657053,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.832918,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      0.344520,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.718870,
      1,
      2,
      1.992443,
      NULL,
      NULL,
      5,
      3,
      2,
      1.604728,
      0,
      6.864067,
      0.565509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.557542,
      3,
      1.006114,
      0,
      NULL,
      3.551539,
      1,
      9,
      0.073911,
      3,
      2,
      1,
      3.105044,
      NULL,
      NULL,
      1.709104,
      3.956677,
      3.744341,
      2,
      0.160745,
      1.240292,
      NULL,
      1,
      6.491332,
      NULL,
      NULL,
      NULL,
      2.901099,
      NULL,
      1,
      1.499004,
      NULL,
      NULL,
      1,
      1,
      3.129967,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384561,
      NULL,
      NULL,
      1.687778,
      NULL,
      NULL,
      1.922848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.459047,
      NULL,
      NULL,
      0.398721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.321140,
      1.094368,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0.784443,
      NULL,
      NULL,
      NULL,
      5.455334,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.607203,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905907,
      NULL,
      NULL,
      NULL,
      3.663022,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.703669,
      NULL,
      NULL,
      NULL,
      1.865958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129285,
      NULL,
      NULL,
      3.352785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.992592,
      0,
      NULL,
      0,
      1.754242,
      NULL,
      1.569009,
      NULL,
      NULL,
      1.110421,
      NULL,
      0.521915,
      76.422625,
      NULL,
      1.649673,
      NULL,
      1,
      1,
      0.016943,
      1.501412,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.013607,
      0,
      1.745358,
      0,
      0.740764,
      1.501369,
      1.694553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      NULL,
      2.629649,
      NULL,
      6,
      0.698696,
      0.897855,
      1.043592,
      1,
      1,
      NULL,
      1.112457,
      0.769102,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1.437543,
      NULL,
      NULL,
      0,
      2.680816,
      NULL,
      3,
      0,
      NULL,
      0.345991,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.712533,
      1.933052,
      NULL,
      NULL,
      1,
      0.545762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.157934,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      2.928740,
      1,
      2.725126,
      58,
      0,
      3,
      NULL,
      1,
      '33230',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


