set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1410242',
      NULL,
      0,
      1,
      2,
      '2414',
      2,
      1.062733,
      NULL,
      NULL,
      ' 1-24-1976',
      40.138585,
      NULL,
      5,
      0.154599,
      0.603497,
      ' 1-13-1983',
      NULL,
      1,
      41,
      NULL,
      NULL,
      ' 6-17-1986',
      ' 8-19-2001',
      ' 5- 0-1990',
      0.391687,
      3.966372,
      0.330054,
      NULL,
      0,
      1.280234,
      NULL,
      1.065829,
      1,
      120,
      2,
      5,
      NULL,
      5,
      20,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      2,
      1,
      0,
      0.953928,
      1.904443,
      0.274253,
      1.200486,
      NULL,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      5,
      4,
      1,
      0,
      1,
      0,
      0,
      3.903375,
      0,
      1,
      NULL,
      1,
      1.616429,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.479054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132426,
      0,
      0,
      1,
      NULL,
      0.189051,
      NULL,
      0.136108,
      1,
      1,
      0,
      1,
      NULL,
      1,
      4,
      NULL,
      1,
      4,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      5,
      3,
      2,
      5,
      1,
      1,
      0.541294,
      1.996626,
      NULL,
      312.589053,
      ' 2-26-1988',
      79.475334,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0.471889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      799.229254,
      2,
      3.385805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537554,
      0,
      NULL,
      1,
      4.702791,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.677500,
      0.115341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      32.827760,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162283,
      2,
      1,
      NULL,
      3,
      2,
      2,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1.768244,
      NULL,
      0,
      NULL,
      0,
      1.017744,
      NULL,
      1.064381,
      0,
      1,
      0.655184,
      0.406703,
      NULL,
      1.836015,
      0,
      0.448683,
      0,
      0,
      1.604662,
      5,
      NULL,
      NULL,
      8,
      0,
      2.407728,
      3.044670,
      6,
      0.852263,
      3.322002,
      3,
      28.480075,
      1,
      0.294429,
      NULL,
      11,
      18,
      57.117012,
      1,
      0,
      NULL,
      '10320',
      '',
      '',
      3.669784,
      '32233',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.931708,
      NULL,
      16.390142,
      4,
      3.764004,
      42.125272,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.519709,
      1.062466,
      0.370646,
      1.050296,
      2.341355,
      2.696192,
      NULL,
      NULL,
      0.877942,
      2,
      2,
      NULL,
      1.897729,
      3.184290,
      0.130849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      NULL,
      5.005036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.191070,
      NULL,
      NULL,
      1.636178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.025434,
      NULL,
      2.575732,
      1,
      NULL,
      NULL,
      1.376548,
      NULL,
      6,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.007640,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      3,
      0.707041,
      0,
      NULL,
      NULL,
      4.827574,
      4.658231,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.400585,
      NULL,
      NULL,
      1.346697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.161762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841588,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.527702,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2.615492,
      5.233191,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588358,
      NULL,
      NULL,
      3.161419,
      0,
      3,
      3,
      NULL,
      1.626636,
      3.823414,
      0.664231,
      3,
      1.311738,
      0.881605,
      1.155249,
      3,
      1.344999,
      0.618213,
      NULL,
      NULL,
      2,
      5,
      6.858306,
      9.066444,
      0,
      NULL,
      2,
      3.972221,
      3,
      0,
      NULL,
      0.937451,
      1.645631,
      0.571360,
      1.019730,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954360,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586383,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.274303,
      NULL,
      NULL,
      2,
      3.743805,
      0,
      NULL,
      0.072332,
      NULL,
      1.929422,
      NULL,
      NULL,
      1.330914,
      NULL,
      NULL,
      96.091556,
      237.923565,
      NULL,
      NULL,
      3.953495,
      2,
      NULL,
      NULL,
      1.072343,
      3,
      NULL,
      NULL,
      1.850871,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.838939,
      NULL,
      NULL,
      1.885090,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.431434,
      NULL,
      NULL,
      NULL,
      1.326351,
      NULL,
      NULL,
      1.786398,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.698995,
      NULL,
      NULL,
      3.847484,
      3.538211,
      NULL,
      NULL,
      0,
      3.325029,
      NULL,
      NULL,
      2.729357,
      3.775434,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.321217,
      NULL,
      2.371386,
      1.118773,
      2,
      2.173484,
      1.036592,
      NULL,
      NULL,
      NULL,
      1.341767,
      1.274550,
      2.931777,
      1,
      0.083625,
      0.561287,
      NULL,
      NULL,
      1,
      0,
      0.468977,
      9,
      0.643914,
      1,
      0.003711,
      1.266566,
      NULL,
      1,
      0.572725,
      0.959796,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.974981,
      1.106449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      4,
      3.093025,
      2,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0.025140,
      NULL,
      1.939414,
      NULL,
      NULL,
      1.510516,
      1,
      NULL,
      3,
      2.266232,
      NULL,
      0,
      0.867501,
      NULL,
      0.283020,
      0,
      NULL,
      3.099324,
      1.042800,
      NULL,
      0.343108,
      2,
      NULL,
      0,
      1.073916,
      NULL,
      1.089523,
      3.829478,
      NULL,
      1.657824,
      1.123362,
      NULL,
      1.198823,
      1.113328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.201996,
      2,
      NULL,
      NULL,
      NULL,
      2.132562,
      NULL,
      1,
      NULL,
      1.166507,
      NULL,
      3,
      NULL,
      0.623620,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2.880478,
      NULL,
      1,
      NULL,
      3.378195,
      NULL,
      0,
      NULL,
      NULL,
      1.551529,
      NULL,
      NULL,
      NULL,
      1.617411,
      NULL,
      0.044238,
      NULL,
      1,
      4,
      1,
      0,
      1.721523,
      NULL,
      22,
      11,
      2,
      1,
      NULL,
      '10143',
      '',
      '',
      2.126352,
      '31013',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


