set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      '1431',
      2.610169,
      0.892016,
      NULL,
      NULL,
      ' 1-23-1975',
      17.094271,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.225752,
      2.346603,
      58.375532,
      NULL,
      2,
      ' 1- 1-2000',
      ' 8- 7-1992',
      ' 5-16-2000',
      NULL,
      2.245013,
      0,
      NULL,
      1,
      2.565921,
      0,
      0,
      0,
      144,
      NULL,
      NULL,
      9.663380,
      NULL,
      8.485194,
      NULL,
      NULL,
      1,
      3,
      7.796167,
      1.634896,
      1,
      1,
      0,
      1,
      1,
      1,
      2,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      3.517806,
      3,
      0,
      2,
      4,
      0,
      3,
      5,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      2,
      1.510214,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1.811070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1,
      NULL,
      0,
      0.607620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.718807,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.056038,
      3,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      2,
      2,
      1,
      1,
      1,
      4,
      4,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0.893070,
      2,
      '11- 7-1988',
      NULL,
      NULL,
      177.358721,
      1.008815,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      322.677325,
      1.713673,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.472453,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.754775,
      2.014769,
      NULL,
      5,
      1.555758,
      1.902144,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.247945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.965621,
      0,
      21.899285,
      0.868542,
      1.291898,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.862168,
      0,
      3,
      2,
      0,
      3,
      3,
      0,
      0,
      0,
      NULL,
      2.344107,
      0,
      1.684394,
      5.743091,
      0,
      1,
      1,
      1.378934,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      4,
      1,
      5.260221,
      9.537952,
      0.531931,
      3.672300,
      6.587086,
      0.786754,
      NULL,
      2,
      6.756708,
      2,
      1.246147,
      1,
      10.340876,
      0,
      NULL,
      NULL,
      6,
      9,
      7.001452,
      4,
      NULL,
      2,
      '10333',
      NULL,
      '',
      0,
      '13210',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.807495,
      18,
      NULL,
      37,
      0.554745,
      20.867937,
      2.984165,
      2,
      2,
      1,
      NULL,
      NULL,
      0.643882,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.923533,
      1.270808,
      2,
      1,
      3,
      0.973745,
      0.794524,
      NULL,
      0.479032,
      1.952778,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565587,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.091840,
      NULL,
      4.592425,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.343774,
      NULL,
      0.442912,
      0,
      NULL,
      NULL,
      NULL,
      1.219237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.965548,
      0.183368,
      1.846600,
      1.754124,
      0,
      1.376339,
      0,
      0.053643,
      1,
      6,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859819,
      NULL,
      NULL,
      1,
      NULL,
      0.996157,
      NULL,
      0,
      2.760880,
      1,
      NULL,
      NULL,
      6,
      2,
      NULL,
      0.465569,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.969126,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.706609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302941,
      NULL,
      NULL,
      1.075545,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.813238,
      NULL,
      NULL,
      5,
      NULL,
      5.607914,
      1,
      NULL,
      NULL,
      0.271306,
      NULL,
      NULL,
      2.918466,
      NULL,
      2.371565,
      1,
      2,
      3,
      NULL,
      5.971671,
      3,
      3,
      3,
      1,
      3,
      1,
      2,
      2.777284,
      3.024944,
      2.232569,
      0,
      3,
      2,
      5.558825,
      9.360469,
      0,
      5.989452,
      4,
      2,
      2.763690,
      3,
      1,
      0.034451,
      0,
      0,
      1,
      1.182089,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612351,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.073494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363512,
      NULL,
      0.780585,
      3.821331,
      0,
      2,
      1,
      NULL,
      NULL,
      5,
      NULL,
      19.124298,
      NULL,
      292,
      NULL,
      NULL,
      NULL,
      3.061829,
      NULL,
      1,
      NULL,
      3.226705,
      NULL,
      2,
      NULL,
      2.777172,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.894110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.776134,
      NULL,
      10,
      NULL,
      0.439110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.359372,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.526412,
      NULL,
      0.441476,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.135560,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.938061,
      NULL,
      15,
      NULL,
      10.797927,
      NULL,
      3.560146,
      NULL,
      0.120040,
      NULL,
      NULL,
      NULL,
      0,
      0.496402,
      2.431860,
      NULL,
      NULL,
      1.502726,
      2,
      0.748447,
      0,
      0.888965,
      0,
      1.454844,
      NULL,
      0,
      0.727966,
      0,
      NULL,
      NULL,
      1.438962,
      NULL,
      1,
      9.264082,
      NULL,
      1,
      NULL,
      1.671137,
      1,
      0.610349,
      0.803229,
      0.926125,
      0.149834,
      0.873831,
      NULL,
      1,
      0,
      NULL,
      1.829666,
      NULL,
      0,
      0.618682,
      0.914473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      5,
      3,
      3.250823,
      3,
      3,
      5,
      0,
      1,
      1.827776,
      1,
      0,
      NULL,
      0,
      0.059465,
      NULL,
      3.744324,
      NULL,
      NULL,
      1.671915,
      NULL,
      NULL,
      1.657871,
      0.187045,
      NULL,
      0,
      0,
      NULL,
      1.551838,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.487674,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.016215,
      NULL,
      2.460691,
      NULL,
      1.142140,
      NULL,
      3.609698,
      NULL,
      2.496013,
      NULL,
      1.374769,
      NULL,
      NULL,
      NULL,
      1.541315,
      NULL,
      NULL,
      3.459178,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      1,
      0.856209,
      58.845526,
      32,
      0,
      1.617246,
      5.009069,
      '44411',
      NULL,
      NULL,
      NULL,
      '14220',
      '',
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


