set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8831314';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      '3340',
      0,
      1,
      NULL,
      NULL,
      ' 1- 8-2003',
      6,
      NULL,
      2,
      2.003479,
      0.602123,
      ' 9-18-1987',
      18.640500,
      3.327782,
      149.950319,
      NULL,
      0,
      ' 9- 2-1984',
      ' 4-12-1988',
      ' 4-26-2001',
      1.607836,
      2,
      NULL,
      1.439393,
      NULL,
      1,
      3,
      1,
      1,
      1,
      0,
      1,
      1.283030,
      154.286717,
      NULL,
      2,
      NULL,
      1,
      4,
      7.461222,
      NULL,
      1,
      NULL,
      0.034920,
      0,
      0.214404,
      NULL,
      1,
      NULL,
      1,
      189,
      5,
      3,
      1,
      0.548600,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      4.059876,
      0,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0.051042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.037431,
      0,
      NULL,
      1,
      0.015627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      0,
      1,
      0,
      0,
      4,
      NULL,
      5,
      NULL,
      0,
      4,
      2,
      3,
      NULL,
      NULL,
      5,
      0,
      3,
      1,
      '11-29-1984',
      638,
      ' 0- 2-2000',
      1193.542034,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422471,
      NULL,
      0.172780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.358422,
      3.959393,
      NULL,
      NULL,
      1.966204,
      0,
      3.870913,
      0.804466,
      NULL,
      4,
      3.411403,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.548084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647891,
      0.717150,
      0.583003,
      0.668097,
      1.746844,
      1,
      32,
      2.355098,
      NULL,
      21,
      23.178182,
      2,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      2,
      3,
      NULL,
      2,
      1,
      3,
      2,
      NULL,
      11.067057,
      7,
      NULL,
      28.644020,
      146.680589,
      NULL,
      106.148905,
      24,
      1,
      0.200256,
      NULL,
      0,
      0.151645,
      1.128393,
      1,
      11,
      13.267359,
      0.255522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333109,
      NULL,
      50,
      65,
      65,
      0,
      1.256551,
      NULL,
      '01420',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      0.486144,
      208.532839,
      34.131597,
      0,
      21,
      8,
      NULL,
      4,
      3.106352,
      1,
      1,
      0.473645,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.622417,
      NULL,
      NULL,
      NULL,
      0.900926,
      1,
      0.742543,
      1,
      0.724643,
      1.307589,
      0.285217,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.349628,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.088001,
      3.878643,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.569790,
      NULL,
      NULL,
      NULL,
      1.736296,
      1,
      0.925485,
      NULL,
      NULL,
      NULL,
      1.952781,
      NULL,
      NULL,
      1,
      1.680560,
      NULL,
      0.669872,
      1,
      NULL,
      2,
      0.361458,
      1,
      NULL,
      1.328400,
      NULL,
      2.026802,
      0,
      0,
      1.264829,
      0,
      NULL,
      NULL,
      1.250835,
      NULL,
      NULL,
      0.842044,
      NULL,
      NULL,
      4,
      7,
      2.171676,
      0,
      0.393266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.830976,
      3,
      3.255377,
      1.195388,
      NULL,
      NULL,
      6,
      6,
      0.007458,
      NULL,
      0.236919,
      0,
      1.330057,
      NULL,
      NULL,
      3.681068,
      1.376539,
      1.137955,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.945149,
      NULL,
      NULL,
      1.044496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      3,
      3.764572,
      1.040402,
      1.505972,
      1,
      NULL,
      2.972580,
      3.094291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.950533,
      NULL,
      1,
      4,
      0,
      9.129797,
      NULL,
      3,
      NULL,
      0.462645,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.309392,
      3,
      1,
      3,
      8,
      2.710080,
      4,
      NULL,
      NULL,
      1.850580,
      0,
      1,
      0,
      1,
      0,
      1.220157,
      1,
      0,
      NULL,
      NULL,
      0.612233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.041574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.154784,
      NULL,
      NULL,
      0.182105,
      NULL,
      3.709554,
      NULL,
      1,
      2.599083,
      NULL,
      NULL,
      NULL,
      2.523344,
      4,
      NULL,
      NULL,
      9,
      2,
      NULL,
      NULL,
      0,
      0.533315,
      NULL,
      NULL,
      1.195486,
      0,
      NULL,
      NULL,
      0.344461,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248317,
      0.583091,
      NULL,
      NULL,
      NULL,
      1.175170,
      NULL,
      NULL,
      1,
      1.654330,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.928234,
      NULL,
      NULL,
      3,
      1.787209,
      NULL,
      NULL,
      3.982513,
      NULL,
      NULL,
      NULL,
      0.611892,
      0.490652,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0.774465,
      1.943919,
      NULL,
      NULL,
      7.723800,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      NULL,
      167,
      43,
      NULL,
      NULL,
      NULL,
      0.616238,
      NULL,
      NULL,
      0.019842,
      NULL,
      NULL,
      0.792697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12554,
      1334,
      1,
      1,
      0.348669,
      NULL,
      1.788467,
      0,
      NULL,
      1,
      0.025382,
      1.207466,
      NULL,
      1,
      0.412282,
      1,
      1,
      0.856733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.190921,
      NULL,
      1.575162,
      NULL,
      NULL,
      8,
      1.983410,
      NULL,
      NULL,
      NULL,
      2.844625,
      3.566533,
      0.560330,
      0,
      1,
      1,
      2,
      1,
      1,
      1.409565,
      NULL,
      0.041382,
      1,
      1,
      0.775392,
      1.181562,
      2,
      0.767827,
      NULL,
      0.347540,
      NULL,
      2,
      0.924681,
      1,
      0.052654,
      1.234972,
      1.206669,
      0.196373,
      3.810728,
      0,
      1,
      1.231590,
      1.840336,
      3.728754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.239091,
      1.285936,
      NULL,
      2.350335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.667342,
      NULL,
      2,
      NULL,
      0.645442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.528933,
      30.239465,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.657028,
      1.228994,
      0,
      NULL,
      3,
      1,
      NULL,
      0.406054,
      0.104774,
      30.701459,
      38.491825,
      NULL,
      0.209345,
      NULL,
      NULL,
      '',
      '',
      1.965897,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


