set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5715854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      NULL,
      19.610962,
      24,
      '4102334',
      2,
      1,
      2,
      0,
      '1003',
      5.726006,
      0.856692,
      NULL,
      NULL,
      ' 7-16-1983',
      10.426797,
      42,
      NULL,
      NULL,
      1.308495,
      ' 1-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 4- 5-2000',
      ' 9-29-1999',
      2.399925,
      2,
      1,
      1.044169,
      1.068459,
      1.687148,
      2,
      2.149811,
      NULL,
      NULL,
      NULL,
      9.996464,
      7.591079,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.372960,
      1,
      1.541163,
      0,
      1,
      0,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.083948,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.184669,
      0,
      1.769877,
      1,
      0,
      0.044162,
      0.816249,
      2.911218,
      NULL,
      NULL,
      0,
      1,
      3.341109,
      NULL,
      1,
      3,
      4,
      1,
      1,
      5.130972,
      0,
      2,
      3.336833,
      0.888008,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      0,
      2,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0.482430,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.875837,
      0,
      0,
      1,
      1,
      0,
      1,
      3,
      NULL,
      5,
      1,
      1,
      1,
      3,
      1,
      1,
      NULL,
      3,
      4,
      4,
      2,
      NULL,
      4,
      NULL,
      1,
      0,
      2,
      2,
      ' 2-18-1983',
      334.348690,
      NULL,
      195,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267690,
      0,
      2.645584,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033904,
      NULL,
      0.401004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.776668,
      1.304685,
      3.526076,
      NULL,
      0,
      0.753316,
      NULL,
      NULL,
      NULL,
      2,
      1.912223,
      0.344531,
      2,
      0,
      0,
      2,
      1,
      0,
      0,
      1,
      2,
      2,
      4,
      1.257011,
      2,
      0.960773,
      NULL,
      0,
      NULL,
      1.044271,
      0.962687,
      1.391811,
      1,
      1.883853,
      1.358902,
      1,
      1.476486,
      NULL,
      0.462542,
      NULL,
      0,
      3.693070,
      2.747046,
      2.029755,
      4,
      NULL,
      2.664154,
      2,
      0.329047,
      4,
      NULL,
      1,
      0.445805,
      13.638444,
      3,
      NULL,
      7,
      NULL,
      50,
      33,
      3,
      5,
      0.900068,
      '30023',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      3.535536,
      28,
      74.482223,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.575735,
      0.061694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.913596,
      1.731505,
      0.662681,
      2.752493,
      0,
      2.722483,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.172479,
      0,
      6.484446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.061771,
      2,
      2.887953,
      1.316229,
      3,
      3.334695,
      NULL,
      NULL,
      NULL,
      2.886889,
      3,
      3.408117,
      3.412840,
      0,
      2.869695,
      3,
      0,
      1.682256,
      NULL,
      1,
      2.187532,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.810185,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.499612,
      0,
      0,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.415929,
      1.179422,
      1.935734,
      0.246091,
      2,
      0.553123,
      NULL,
      NULL,
      2,
      4.080218,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.377870,
      NULL,
      NULL,
      1.142415,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.676047,
      NULL,
      NULL,
      2.766474,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.777124,
      2,
      0.977457,
      0.795168,
      0.641434,
      0,
      3.927422,
      3,
      1,
      3,
      3.954274,
      1.446187,
      NULL,
      1.083349,
      8.190333,
      2.273069,
      1.272956,
      NULL,
      1.332888,
      2.027372,
      NULL,
      0,
      NULL,
      0,
      1.814409,
      0.891692,
      0,
      0.720058,
      NULL,
      NULL,
      NULL,
      1.242836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895079,
      NULL,
      NULL,
      0.954515,
      NULL,
      NULL,
      0.797309,
      NULL,
      NULL,
      0.700729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.998672,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.094235,
      1,
      NULL,
      NULL,
      1.737243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403382,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.190083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.536427,
      0,
      1,
      0.963119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.473585,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      406,
      35.408611,
      1.296644,
      0,
      0,
      0.552929,
      NULL,
      1,
      1.364984,
      0.664921,
      1,
      0.673374,
      1,
      0,
      0,
      1.944965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      6.689928,
      4,
      7.053598,
      2.196143,
      3,
      NULL,
      1.667228,
      3.575790,
      1.340193,
      1,
      1.425118,
      NULL,
      0.250488,
      0.852764,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.006445,
      NULL,
      0.482497,
      0.361294,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.160167,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3.383548,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573302,
      NULL,
      0.449193,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      93.382746,
      5,
      4,
      2.238445,
      '02412',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


