set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '2112034',
      0,
      1,
      NULL,
      NULL,
      '0011',
      3.452252,
      0.481701,
      NULL,
      NULL,
      ' 9-25-1998',
      33.348699,
      NULL,
      2,
      0,
      1,
      ' 9-20-1975',
      21.267798,
      0.172630,
      NULL,
      25,
      NULL,
      ' 2- 5-1995',
      ' 2-26-1985',
      NULL,
      1,
      NULL,
      0.578846,
      1,
      1.567801,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.186860,
      5,
      20,
      31.742829,
      5,
      4,
      3,
      0,
      5,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      0.252899,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      0.916138,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.975774,
      1.631193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.727937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      0,
      5,
      1,
      2,
      NULL,
      0,
      NULL,
      0,
      3,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      1,
      NULL,
      2,
      4,
      3,
      2,
      NULL,
      1,
      3,
      1,
      1,
      3,
      0,
      2,
      2,
      4,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      2,
      0,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      5,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3,
      1,
      NULL,
      0,
      3.390959,
      NULL,
      1.876792,
      0,
      NULL,
      0.139658,
      1,
      NULL,
      NULL,
      NULL,
      1.445220,
      1.802946,
      0.136990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.991428,
      1.429300,
      NULL,
      3,
      1.216330,
      3,
      0,
      NULL,
      5,
      1.069254,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      2,
      NULL,
      2,
      2,
      3,
      NULL,
      17.893852,
      14.817897,
      182,
      79.882468,
      137.293267,
      79,
      NULL,
      NULL,
      0.015536,
      1,
      0.712334,
      NULL,
      1.272828,
      NULL,
      0,
      17,
      19.078381,
      1,
      9.047354,
      4.265036,
      1.647026,
      2.453159,
      5.100730,
      0.502366,
      1,
      1.572975,
      7.410669,
      0,
      NULL,
      NULL,
      16.501740,
      3,
      NULL,
      NULL,
      NULL,
      11,
      56,
      3,
      1,
      NULL,
      '33411',
      '12441',
      '41141',
      1.248263,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2.940577,
      12,
      21,
      27.873500,
      0,
      16,
      0,
      3.011794,
      4,
      1.387437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958861,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.598047,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733734,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396009,
      NULL,
      NULL,
      1.474955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.978286,
      0.938727,
      NULL,
      NULL,
      NULL,
      5.444254,
      0,
      NULL,
      NULL,
      NULL,
      1.721711,
      1.289202,
      0,
      0,
      5.123927,
      3.612981,
      1.857590,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.318746,
      NULL,
      NULL,
      0.683905,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.163099,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.771823,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.647450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.462718,
      NULL,
      NULL,
      4,
      4,
      0.050428,
      0.766094,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.678623,
      0,
      0.104322,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.015876,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      7.975211,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0,
      227.022316,
      3,
      1.840114,
      1.823976,
      0.687545,
      NULL,
      1.058595,
      1.759823,
      1.647860,
      NULL,
      1.719445,
      1.466981,
      1.217694,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.244450,
      NULL,
      1.009605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.001456,
      11.992132,
      18,
      3.116546,
      NULL,
      NULL,
      NULL,
      0.616170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.958217,
      NULL,
      1.728133,
      NULL,
      1.113602,
      NULL,
      2.083514,
      NULL,
      1.288854,
      NULL,
      0.019674,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678799,
      NULL,
      NULL,
      0,
      NULL,
      0.350828,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.190626,
      NULL,
      1.037180,
      0.813027,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.275548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.399851,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.333019,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.596072,
      NULL,
      0,
      NULL,
      1,
      1,
      1.497580,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.263626,
      0.945734,
      1,
      NULL,
      0.164612,
      NULL,
      0.625862,
      NULL,
      NULL,
      NULL,
      0.822963,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.206179,
      NULL,
      15,
      8.487586,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.561851,
      1,
      0,
      3,
      NULL,
      NULL,
      1.288065,
      NULL,
      3,
      0,
      1.309012,
      NULL,
      NULL,
      1.605963,
      0,
      1,
      0,
      0,
      1.252160,
      NULL,
      1.886992,
      1.625088,
      NULL,
      0,
      0.826802,
      NULL,
      NULL,
      1.959870,
      1,
      1,
      1.650667,
      0.564523,
      0.584378,
      1,
      1.104115,
      3.211329,
      NULL,
      0.875270,
      3.037954,
      0.029678,
      0.198787,
      1.882483,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077263,
      1,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      1.380877,
      NULL,
      NULL,
      20.331575,
      74.504411,
      5,
      0,
      6.443321,
      '31000',
      '34234',
      '04002',
      1.813242,
      '',
      '',
      '',
      0.781392,
      '',
      '',
      NULL);
commit;
end;
/


