set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '0211010',
      2,
      0.147685,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1999',
      4.087268,
      NULL,
      NULL,
      2.474423,
      2.586150,
      ' 6-29-2003',
      7,
      1.153407,
      228,
      22,
      2,
      ' 7-26-1990',
      NULL,
      ' 6-17-1987',
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      0.664426,
      4,
      2,
      13,
      NULL,
      10.822403,
      18.875111,
      4,
      16,
      5,
      0,
      NULL,
      1.918288,
      0,
      0,
      NULL,
      0.414794,
      1.082357,
      0,
      0.878811,
      1,
      0,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      0,
      1,
      0,
      3,
      1,
      1,
      NULL,
      2,
      0,
      1,
      1,
      1.278481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.817873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      0,
      3,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      4,
      0,
      1,
      NULL,
      1,
      0.641760,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      0,
      2,
      4,
      0,
      3,
      4,
      1,
      NULL,
      4,
      NULL,
      1,
      2,
      2,
      4,
      4,
      2,
      1,
      1,
      3,
      5,
      0,
      1.943901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.127750,
      1,
      2.956272,
      3.143736,
      5.857249,
      1,
      1,
      0,
      0.442323,
      NULL,
      1,
      5,
      0,
      6,
      1,
      0.809851,
      2.555002,
      0.955376,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.477629,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.503381,
      0.481272,
      1,
      3,
      NULL,
      2,
      0,
      2,
      0,
      2,
      1,
      0,
      3,
      2.728376,
      4,
      7.373671,
      146,
      NULL,
      106.152830,
      175.728100,
      75,
      NULL,
      0,
      1.338738,
      1.141002,
      NULL,
      0,
      0,
      13,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      59,
      89,
      69.265167,
      1,
      0,
      2.052265,
      '11200',
      '',
      NULL,
      1.527989,
      NULL,
      NULL,
      '',
      1.758807,
      '',
      '',
      '',
      2,
      21,
      NULL,
      12,
      3.576887,
      21.369273,
      0.806381,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.477844,
      NULL,
      NULL,
      0.080937,
      NULL,
      NULL,
      1.476277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.279813,
      1,
      NULL,
      NULL,
      1.175042,
      NULL,
      NULL,
      1.008639,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797783,
      NULL,
      NULL,
      0.445007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931204,
      NULL,
      NULL,
      NULL,
      0.641988,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      7.835586,
      0,
      1,
      3,
      0.424408,
      0,
      1,
      NULL,
      NULL,
      2.817470,
      NULL,
      0.429922,
      NULL,
      NULL,
      NULL,
      0.879071,
      NULL,
      NULL,
      0.648955,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.845167,
      NULL,
      NULL,
      0.106630,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.022457,
      1,
      3.917403,
      0,
      1,
      0.250278,
      1,
      2,
      1,
      3.699038,
      5,
      0.285947,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.502448,
      3.350969,
      0.745774,
      NULL,
      NULL,
      NULL,
      1,
      3.820002,
      2,
      0,
      2,
      3.780509,
      NULL,
      NULL,
      3.363910,
      0,
      NULL,
      2.452414,
      2.513671,
      0.649729,
      5.394426,
      2.073279,
      8.563115,
      5,
      NULL,
      0,
      3,
      2.664577,
      1,
      1.532072,
      NULL,
      1,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.964730,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.577415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.182816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.760533,
      NULL,
      NULL,
      0.577808,
      NULL,
      NULL,
      1.420434,
      NULL,
      NULL,
      3.065413,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.175338,
      1.882875,
      1,
      3.066996,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.585579,
      NULL,
      NULL,
      NULL,
      1.787316,
      NULL,
      NULL,
      NULL,
      2.257092,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175426,
      0.886846,
      NULL,
      NULL,
      NULL,
      0.773865,
      NULL,
      NULL,
      1.604817,
      NULL,
      NULL,
      NULL,
      0.639379,
      1,
      NULL,
      NULL,
      2,
      1.379054,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      8.002368,
      0.966989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.928741,
      NULL,
      0.180591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286125,
      NULL,
      NULL,
      0.463273,
      21,
      NULL,
      NULL,
      3.315422,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.215768,
      0.397267,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.448761,
      NULL,
      0,
      0.886216,
      0.982476,
      1,
      0.349714,
      0,
      0,
      1.148914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459437,
      1,
      1.502512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568816,
      0.527849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.674377,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.506738,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978031,
      1.319588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.420443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.387227,
      NULL,
      1,
      NULL,
      1.429546,
      NULL,
      NULL,
      NULL,
      1.120086,
      NULL,
      0,
      NULL,
      1.326189,
      1.899850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.396125,
      0.162776,
      1,
      1,
      0.805971,
      1.437705,
      NULL,
      3,
      1,
      1.604428,
      1,
      0.495124,
      1.103179,
      NULL,
      1.857802,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      2,
      3.738276,
      2.792523,
      1.722262,
      0.749934,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.668371,
      0,
      0,
      1,
      2,
      1,
      0.899639,
      0.682208,
      NULL,
      1.621806,
      1.557574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.234966,
      1.834624,
      0,
      1.342514,
      1,
      NULL,
      5,
      5,
      0,
      NULL,
      NULL,
      27.788511,
      102.881086,
      NULL,
      1.773628,
      2.440437,
      '12404',
      NULL,
      '',
      0.441852,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


