set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3030004',
      1,
      1,
      3,
      2,
      '3213',
      1,
      1.056980,
      NULL,
      NULL,
      ' 3- 2-1997',
      51.338677,
      NULL,
      NULL,
      1,
      0,
      ' 7- 5-1987',
      12.420155,
      1.735269,
      25,
      135,
      2,
      ' 3- 9-2000',
      NULL,
      ' 6-28-1978',
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.280848,
      1.800954,
      8.078315,
      NULL,
      NULL,
      0,
      1.474906,
      2,
      2,
      4,
      0,
      0,
      6.517386,
      0,
      0,
      1,
      1.543095,
      1.253970,
      NULL,
      0,
      1,
      NULL,
      0,
      1.495677,
      1,
      NULL,
      5,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      3.311867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.723321,
      1.328255,
      2,
      NULL,
      1.341913,
      NULL,
      1.561559,
      1,
      0.273936,
      1,
      1,
      NULL,
      0,
      1.431239,
      0.327879,
      1.410643,
      3,
      1,
      2,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.051290,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      3,
      5,
      4,
      0,
      5,
      2,
      NULL,
      2,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      0.140294,
      NULL,
      0,
      3,
      3,
      5,
      2,
      1,
      5,
      0,
      0,
      2,
      4,
      NULL,
      NULL,
      0,
      3,
      1,
      4,
      NULL,
      NULL,
      0,
      0,
      0,
      4,
      0,
      5,
      NULL,
      2,
      0,
      ' 5-25-1992',
      11.246156,
      ' 7-19-1975',
      13,
      0.914857,
      0,
      1,
      3,
      3,
      NULL,
      3,
      1,
      2,
      1,
      0,
      NULL,
      3,
      NULL,
      5,
      NULL,
      0,
      2.036360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.442943,
      1,
      2,
      NULL,
      1,
      5,
      1,
      0,
      1,
      NULL,
      1.178074,
      0,
      1,
      3.309406,
      NULL,
      0.963591,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.138651,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981543,
      1.402493,
      0,
      NULL,
      2,
      1.760059,
      NULL,
      0.268416,
      18,
      3.110311,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.485204,
      0.288809,
      1,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      2.504559,
      4.832423,
      1,
      92,
      75,
      125,
      136,
      4,
      NULL,
      NULL,
      0.548987,
      0,
      0,
      0,
      1.811021,
      0,
      NULL,
      NULL,
      0.369232,
      2,
      10,
      2.933303,
      NULL,
      2.506223,
      4.188371,
      1.014800,
      1.485520,
      0,
      1.296284,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      76,
      62,
      34,
      5,
      1.455316,
      1,
      '43110',
      '22202',
      '20002',
      1.558185,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.071014,
      9.828101,
      15,
      30.190904,
      NULL,
      NULL,
      5,
      2.682112,
      0,
      1,
      NULL,
      NULL,
      0.429672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.190107,
      NULL,
      NULL,
      1.071983,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584580,
      1,
      0,
      11.207753,
      0.786830,
      NULL,
      NULL,
      3.726412,
      3.094311,
      1.773744,
      0.795350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800356,
      NULL,
      NULL,
      0.317381,
      NULL,
      NULL,
      1.803434,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.331642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.960905,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.301569,
      0.200772,
      3.025485,
      0,
      1,
      1.659204,
      0.703368,
      NULL,
      NULL,
      6.659087,
      NULL,
      0,
      0.863441,
      NULL,
      NULL,
      1.377488,
      NULL,
      NULL,
      0.575464,
      NULL,
      NULL,
      0.460646,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.196618,
      0.603099,
      NULL,
      1.348339,
      0,
      3,
      7,
      NULL,
      7,
      0,
      NULL,
      0,
      0,
      0.333003,
      NULL,
      NULL,
      1,
      3,
      1,
      3.463645,
      3,
      0.052226,
      2.810049,
      6.687206,
      NULL,
      1.674242,
      0.473821,
      3.045207,
      1.675162,
      0,
      2.840406,
      2.527359,
      3.627762,
      3,
      NULL,
      0.646415,
      3.765562,
      2,
      1,
      NULL,
      0,
      0.597803,
      2.452438,
      NULL,
      4,
      1,
      3,
      2,
      1,
      NULL,
      1.101318,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.678833,
      NULL,
      NULL,
      0.067477,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.862546,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.814025,
      NULL,
      0.803408,
      0.019410,
      0,
      NULL,
      NULL,
      NULL,
      2.616371,
      1.603472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.187293,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.800263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013638,
      0,
      NULL,
      NULL,
      NULL,
      1.003085,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.639305,
      NULL,
      NULL,
      2,
      1.707582,
      NULL,
      NULL,
      1.669221,
      0.058179,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.322223,
      NULL,
      NULL,
      NULL,
      3.009556,
      NULL,
      1,
      1.478533,
      2.194836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989774,
      1,
      3.177180,
      0.040370,
      0.955486,
      0,
      1.988656,
      NULL,
      0,
      NULL,
      2.977459,
      NULL,
      NULL,
      0.580327,
      0,
      NULL,
      NULL,
      0,
      0.776221,
      0,
      0,
      NULL,
      2,
      1,
      0.943430,
      1,
      1,
      NULL,
      1.897059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349863,
      NULL,
      1.882169,
      NULL,
      2.046725,
      NULL,
      9,
      NULL,
      3,
      12.826966,
      19.102164,
      2,
      0.361892,
      NULL,
      NULL,
      0.306046,
      NULL,
      NULL,
      NULL,
      2.192808,
      NULL,
      2.415747,
      NULL,
      0.336387,
      NULL,
      0.407060,
      NULL,
      0.338314,
      NULL,
      NULL,
      NULL,
      1.739539,
      NULL,
      0.644887,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.513173,
      2,
      1.650723,
      1.815229,
      NULL,
      1,
      NULL,
      0.847655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.024102,
      NULL,
      1.525055,
      1.684653,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595576,
      NULL,
      0.906327,
      NULL,
      0.320367,
      NULL,
      NULL,
      0,
      1.176358,
      NULL,
      1.769573,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.825858,
      NULL,
      0,
      NULL,
      0.302563,
      0.334640,
      1.871057,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.130631,
      2.702554,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.613604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020591,
      0.211707,
      0,
      NULL,
      1.510646,
      NULL,
      1,
      NULL,
      228,
      NULL,
      2.811411,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      24.461126,
      13.917321,
      NULL,
      3.639848,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.124289,
      2,
      2.584396,
      2.104762,
      0.477649,
      1,
      0.458560,
      0.472632,
      0.740061,
      0,
      NULL,
      1,
      0.304898,
      1,
      0.031983,
      0,
      0.832053,
      0.406570,
      0.344195,
      2.875095,
      3.036296,
      NULL,
      0,
      0,
      0.834425,
      0,
      1.867426,
      NULL,
      1.488228,
      1,
      NULL,
      1.506207,
      NULL,
      NULL,
      1,
      1,
      3.766561,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451550,
      1.708079,
      0.614880,
      0,
      NULL,
      0,
      3,
      5,
      1,
      1,
      NULL,
      NULL,
      83.157739,
      131,
      3,
      0,
      7,
      '23242',
      '33313',
      '13333',
      1.176158,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


