set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5409332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0431030',
      NULL,
      1.724303,
      0,
      3,
      NULL,
      3.876500,
      0.507611,
      2,
      NULL,
      NULL,
      20.089107,
      NULL,
      3,
      2.657623,
      NULL,
      NULL,
      67,
      3.381361,
      248.384916,
      75.418836,
      1,
      NULL,
      NULL,
      NULL,
      0.321910,
      0.717255,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      304,
      1,
      14.758147,
      12.532968,
      21.400397,
      27,
      5,
      4,
      NULL,
      0,
      6.268431,
      0,
      2,
      0,
      0.478513,
      1.230374,
      0.473194,
      NULL,
      106.720745,
      1,
      0,
      0,
      NULL,
      4,
      6,
      NULL,
      5,
      1,
      1,
      1,
      0,
      0,
      0,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.579946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      0,
      3,
      1,
      0,
      0,
      2,
      1,
      0,
      NULL,
      0,
      1.128185,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      NULL,
      2,
      0,
      NULL,
      5,
      0,
      2,
      2,
      5,
      2,
      0,
      0,
      5,
      4,
      3,
      NULL,
      0,
      0,
      5,
      3,
      NULL,
      0,
      NULL,
      6.731982,
      NULL,
      ' 2- 5-1989',
      1053.808466,
      '10-21-2001',
      840,
      3,
      1,
      2,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.706421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686060,
      0,
      0.380461,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455822,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211179,
      0.748856,
      1.686836,
      0.698161,
      1.042993,
      1,
      NULL,
      NULL,
      0.645233,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.288158,
      18,
      19,
      19,
      0,
      0,
      NULL,
      1.515913,
      0.808060,
      0,
      0.132668,
      0,
      0.814583,
      1,
      0.951205,
      0,
      6,
      3.285013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      26.115971,
      84,
      36.372423,
      3.053130,
      20.018250,
      0.812009,
      171,
      3,
      1.797534,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858814,
      NULL,
      NULL,
      1.946526,
      NULL,
      NULL,
      1.240663,
      NULL,
      NULL,
      1.631305,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.630758,
      NULL,
      NULL,
      0.612778,
      NULL,
      NULL,
      NULL,
      0.653741,
      NULL,
      NULL,
      NULL,
      0,
      17.807063,
      NULL,
      13,
      NULL,
      NULL,
      0.862086,
      NULL,
      NULL,
      0,
      1,
      1,
      1.539385,
      0.918695,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.082319,
      NULL,
      0.271540,
      0,
      0.373329,
      NULL,
      NULL,
      1.467863,
      NULL,
      NULL,
      1,
      2,
      5,
      6,
      NULL,
      1.749256,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.908414,
      3.757632,
      3.070877,
      1.347810,
      0.938738,
      3,
      18,
      NULL,
      NULL,
      7,
      11,
      1.936538,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952337,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.672417,
      NULL,
      NULL,
      8.237962,
      NULL,
      NULL,
      3,
      1.574364,
      1,
      4.832118,
      1,
      0.005958,
      0.334857,
      0,
      3,
      3.273884,
      2,
      NULL,
      NULL,
      9,
      4,
      5.636503,
      1,
      NULL,
      2.921881,
      0,
      NULL,
      0.119876,
      NULL,
      14,
      2,
      2,
      NULL,
      1,
      0,
      1.574596,
      4.728359,
      6,
      1.200010,
      NULL,
      NULL,
      NULL,
      10.440012,
      NULL,
      NULL,
      0.465760,
      NULL,
      2,
      3,
      0.820282,
      0.216827,
      0.458927,
      2.936363,
      NULL,
      NULL,
      NULL,
      6,
      0,
      2,
      3,
      0,
      0,
      1.963434,
      0.882539,
      1,
      1.202280,
      NULL,
      NULL,
      1.300158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.625862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.468863,
      NULL,
      NULL,
      0.985271,
      NULL,
      NULL,
      1.412328,
      1.865743,
      1.541061,
      0.634947,
      NULL,
      1.647048,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.351482,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.406045,
      NULL,
      NULL,
      NULL,
      1.608298,
      NULL,
      NULL,
      NULL,
      0.866084,
      NULL,
      NULL,
      NULL,
      1.212942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006087,
      NULL,
      NULL,
      NULL,
      1.423511,
      NULL,
      NULL,
      NULL,
      1.823281,
      NULL,
      NULL,
      NULL,
      1.051937,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.604494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.180436,
      NULL,
      NULL,
      NULL,
      0.575465,
      NULL,
      NULL,
      NULL,
      2,
      85,
      138,
      0,
      NULL,
      NULL,
      1.841576,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      1.368452,
      12091.530978,
      857,
      0.292768,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.830196,
      NULL,
      1.566174,
      0,
      NULL,
      NULL,
      1,
      0.623897,
      0.973045,
      0.213059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3.826044,
      NULL,
      5.221791,
      2,
      NULL,
      4.715241,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      1.952094,
      13.315087,
      NULL,
      1,
      5,
      NULL,
      0.645118,
      NULL,
      NULL,
      0.325613,
      1,
      NULL,
      0,
      4.274099,
      NULL,
      0.732703,
      2,
      NULL,
      0,
      1,
      NULL,
      0.868646,
      0,
      NULL,
      0.625980,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.083284,
      1.581300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.023950,
      NULL,
      3,
      NULL,
      6,
      NULL,
      NULL,
      3.100438,
      69.929735,
      58.493217,
      5,
      1.889803,
      3.619987,
      '23040',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      1.525078,
      '',
      '',
      NULL);
commit;
end;
/


