set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1220033',
      2.765124,
      1.461182,
      1,
      1,
      '3120',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      5,
      3,
      NULL,
      ' 0-16-2002',
      47,
      1.357500,
      332,
      81.105620,
      1,
      ' 5- 0-1987',
      ' 1-27-2002',
      '10-14-1997',
      2.855609,
      NULL,
      0.404488,
      NULL,
      NULL,
      0.533458,
      2,
      0,
      0,
      11,
      4,
      10.874710,
      NULL,
      17.326779,
      8.665409,
      0,
      11.273128,
      3,
      0,
      0.356506,
      1,
      1,
      NULL,
      1.442222,
      1.070038,
      NULL,
      NULL,
      0.835835,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.627697,
      3,
      0,
      1,
      3,
      0,
      1,
      5,
      4,
      4,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0.909232,
      1.611445,
      3,
      0,
      NULL,
      1,
      0.480006,
      0.290588,
      0.779288,
      2.331099,
      0.306395,
      0,
      1,
      1,
      2,
      1,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      1.570021,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.890760,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.661912,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      2,
      0,
      5,
      NULL,
      1,
      3,
      2,
      4,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      7,
      0.805416,
      '10- 6-2003',
      381,
      ' 5-17-1980',
      88,
      2,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.692389,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.198860,
      6,
      4,
      NULL,
      1,
      5.689138,
      0.386113,
      0.823915,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.232037,
      NULL,
      1.992501,
      0.888326,
      NULL,
      1.999521,
      NULL,
      3.091903,
      21,
      0.916438,
      0.883190,
      NULL,
      NULL,
      NULL,
      0,
      0.593500,
      2,
      0,
      NULL,
      2,
      2,
      0,
      2,
      1,
      2,
      NULL,
      NULL,
      2,
      1.013299,
      NULL,
      5,
      1,
      NULL,
      3,
      1,
      0.327436,
      0.308058,
      0.318741,
      1,
      1,
      1.990732,
      0,
      1,
      0,
      2,
      1.891857,
      3,
      5.746416,
      2,
      0.206478,
      5.800605,
      NULL,
      5,
      0.708927,
      NULL,
      0,
      1.409838,
      1,
      4.738224,
      2,
      NULL,
      NULL,
      65,
      30,
      85.879560,
      5,
      0.604334,
      1,
      '24314',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.232522,
      '',
      NULL,
      '',
      2.889109,
      23,
      47,
      4,
      3.911729,
      NULL,
      0,
      4.928059,
      0,
      3.322468,
      2.974550,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057509,
      1,
      1.292299,
      1.726122,
      NULL,
      NULL,
      1.914410,
      NULL,
      NULL,
      3.383403,
      1,
      0,
      2.819918,
      1.281546,
      0,
      0,
      1,
      NULL,
      1.468573,
      NULL,
      NULL,
      2.551794,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.806794,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.632674,
      NULL,
      NULL,
      0.294326,
      0,
      1,
      3.435504,
      0,
      0.474020,
      NULL,
      1,
      2,
      NULL,
      1.876020,
      1,
      3,
      2,
      1.789904,
      0,
      1.370467,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.053346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.458879,
      NULL,
      NULL,
      2.982099,
      NULL,
      0,
      NULL,
      3.434454,
      NULL,
      1.907535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.956633,
      NULL,
      NULL,
      1.107007,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.425737,
      NULL,
      2.362841,
      1,
      NULL,
      NULL,
      4,
      3.446342,
      NULL,
      1,
      1.668152,
      NULL,
      0.545094,
      NULL,
      NULL,
      NULL,
      0.162724,
      1.105225,
      0,
      0.486448,
      3.605566,
      3,
      0.839890,
      NULL,
      NULL,
      5.701957,
      3.055132,
      3,
      2.171536,
      2,
      0.148443,
      0,
      0,
      NULL,
      NULL,
      0.359272,
      2,
      0,
      2.309214,
      4,
      3.076784,
      0,
      4,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      0.347528,
      1.869830,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277046,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.111339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.820305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182683,
      NULL,
      5,
      1.951136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.821229,
      18099,
      1938.986659,
      NULL,
      1.669318,
      0.996279,
      1,
      0.500618,
      1.232049,
      0,
      1.298788,
      NULL,
      0.179613,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1.886847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      1,
      2.298136,
      NULL,
      NULL,
      7.630708,
      2.949697,
      2,
      1.510740,
      NULL,
      1.859599,
      NULL,
      2,
      1,
      NULL,
      3,
      1.008702,
      NULL,
      NULL,
      1.288098,
      NULL,
      0,
      NULL,
      NULL,
      1.650762,
      0,
      NULL,
      1,
      1.930231,
      NULL,
      0,
      NULL,
      NULL,
      1.682031,
      1,
      NULL,
      0.921521,
      0,
      NULL,
      1.119577,
      1.528768,
      NULL,
      0,
      0,
      0.969103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.758325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816539,
      NULL,
      1,
      NULL,
      2,
      NULL,
      6,
      1,
      NULL,
      NULL,
      17,
      101.028007,
      4,
      1,
      2.470912,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


