set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3433013',
      3.001586,
      1,
      NULL,
      0,
      '4241',
      3,
      1,
      NULL,
      NULL,
      '11-17-2002',
      10.906721,
      NULL,
      0,
      1,
      3,
      NULL,
      51.807734,
      2,
      157.385793,
      144.426658,
      1,
      NULL,
      NULL,
      ' 0-17-1978',
      3.438498,
      1.086902,
      0.252673,
      3,
      0,
      1.980608,
      2,
      0,
      1,
      22.652336,
      NULL,
      16.596733,
      6.229195,
      6.913722,
      28,
      0,
      21,
      3,
      2,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      1.444973,
      0.906390,
      0,
      1.935975,
      NULL,
      1,
      2,
      4,
      NULL,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      5,
      0,
      NULL,
      3,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      1.419814,
      1.760891,
      1.874630,
      NULL,
      3,
      1.299393,
      0.045159,
      0.255208,
      NULL,
      0,
      1,
      2.167795,
      NULL,
      1.806380,
      NULL,
      1,
      1,
      0.277884,
      1,
      0,
      0,
      0.610765,
      NULL,
      NULL,
      0.852703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      1,
      2,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.060610,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      1,
      5,
      1,
      0,
      3,
      1,
      2,
      4,
      0,
      5,
      2,
      NULL,
      4,
      2,
      9,
      1.169120,
      ' 9-15-1990',
      6.151498,
      ' 3-19-1984',
      416,
      3,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.027422,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      5.103018,
      0.627375,
      0,
      3.982292,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.869711,
      0.005571,
      0.238950,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.522212,
      1,
      0,
      3,
      2,
      NULL,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.472840,
      2,
      NULL,
      1,
      0.207535,
      1,
      1,
      NULL,
      1.271766,
      NULL,
      0,
      1.189954,
      1,
      NULL,
      0,
      4.092271,
      NULL,
      1.038939,
      5,
      4,
      6.927036,
      NULL,
      1.660699,
      3,
      0.005798,
      7,
      0.857159,
      3.589635,
      0.178780,
      23,
      2,
      2,
      NULL,
      3,
      67,
      21,
      5,
      1,
      0.412394,
      '00300',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.181994,
      '',
      '',
      '',
      2,
      27,
      105.428355,
      25.566806,
      2,
      NULL,
      9,
      7,
      3,
      3.607498,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      0.791346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.064792,
      0,
      0.398424,
      NULL,
      1,
      0,
      NULL,
      1.939053,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.920100,
      NULL,
      2,
      0.218128,
      0,
      3.862745,
      3.190354,
      NULL,
      0.873748,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.437834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1.854542,
      0.170546,
      1,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      0.034757,
      1,
      NULL,
      0.506319,
      0.612079,
      1.431710,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.733961,
      NULL,
      NULL,
      1.093057,
      2.874341,
      5,
      1,
      1.758172,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.168925,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.503640,
      2,
      3.788623,
      3,
      0,
      6.393384,
      6.052573,
      0.583385,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.275206,
      NULL,
      NULL,
      0.761072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.693822,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.981631,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3.018735,
      1.948476,
      3,
      NULL,
      NULL,
      1,
      1.899720,
      1.576933,
      NULL,
      NULL,
      3.392703,
      3,
      1.817750,
      NULL,
      9.140826,
      7,
      9.246558,
      2,
      2,
      1,
      2,
      NULL,
      NULL,
      2,
      3,
      3.520268,
      2.196775,
      1.819855,
      0.990216,
      0,
      2,
      5.841532,
      9.141041,
      NULL,
      7,
      0.597856,
      NULL,
      NULL,
      1,
      0.111208,
      1.170808,
      NULL,
      NULL,
      3.600899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426864,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.656183,
      NULL,
      NULL,
      1.150245,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.346376,
      NULL,
      NULL,
      NULL,
      0.712377,
      1,
      1,
      0.326555,
      2.035728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      613,
      NULL,
      NULL,
      NULL,
      0.546658,
      NULL,
      NULL,
      NULL,
      1.505210,
      NULL,
      NULL,
      NULL,
      1.360178,
      NULL,
      NULL,
      NULL,
      1.818505,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.086939,
      NULL,
      NULL,
      NULL,
      0.995678,
      NULL,
      NULL,
      NULL,
      0.601063,
      NULL,
      NULL,
      NULL,
      1.814237,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.804324,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.131841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.227587,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.944251,
      5.539868,
      0.874832,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.976346,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.873173,
      NULL,
      NULL,
      0,
      NULL,
      1,
      31,
      886.500725,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1.951160,
      0,
      NULL,
      NULL,
      0.477399,
      1.860069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.964211,
      NULL,
      0,
      2.353342,
      NULL,
      4.526170,
      1,
      1.327176,
      1,
      0.600756,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.546876,
      NULL,
      0.768990,
      0.815510,
      NULL,
      0.010441,
      0.952621,
      NULL,
      1.006029,
      NULL,
      NULL,
      1,
      0.272846,
      NULL,
      NULL,
      0,
      NULL,
      1.668441,
      1,
      NULL,
      1,
      0.412151,
      NULL,
      NULL,
      0,
      NULL,
      0.354134,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040594,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      59.744239,
      17.019245,
      1,
      1.876437,
      1.685794,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.158662,
      '',
      '',
      '');
commit;
end;
/


