set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0024413',
      1.741219,
      1,
      1,
      NULL,
      '0342',
      3,
      1,
      NULL,
      NULL,
      ' 5-27-1991',
      45,
      NULL,
      3,
      3,
      NULL,
      ' 3-28-1989',
      15,
      3,
      NULL,
      NULL,
      0,
      ' 2-23-1977',
      ' 6-21-1982',
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.545119,
      1,
      3,
      0.286316,
      1,
      26.313124,
      5,
      4,
      2,
      21.738633,
      12,
      4,
      NULL,
      1,
      1,
      2.218617,
      1,
      3,
      0,
      NULL,
      1,
      0,
      1.601947,
      1.990536,
      0.022515,
      1.309197,
      0.246438,
      NULL,
      0,
      0,
      3.166793,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0.430422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.840440,
      3.613600,
      NULL,
      0.213147,
      1,
      0.161692,
      1,
      1.900769,
      1,
      1.939357,
      1,
      NULL,
      0.314147,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0.020721,
      1.795679,
      NULL,
      NULL,
      1.116812,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      5,
      1,
      3,
      4,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5,
      0,
      4,
      0,
      NULL,
      4,
      4,
      2,
      NULL,
      1,
      2,
      0,
      ' 2- 8-1986',
      107.483596,
      ' 3- 8-2002',
      NULL,
      1.357171,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.444350,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.138871,
      0.981601,
      0,
      3.496506,
      1,
      1.003000,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.666423,
      0.293121,
      1.546476,
      1,
      1.130071,
      0,
      10,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.621606,
      0,
      0,
      0,
      1,
      2,
      1,
      0,
      0,
      NULL,
      2,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      0.095486,
      1.810066,
      0,
      0.287709,
      0,
      0,
      1.500158,
      NULL,
      1,
      NULL,
      0.367695,
      3.430263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      38,
      22,
      73.396828,
      1,
      1.320978,
      0.103212,
      '04421',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.963046,
      NULL,
      NULL,
      26.983448,
      0,
      28,
      7.485228,
      0,
      0,
      0.160127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.439458,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.859234,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.332245,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0.050501,
      0.545090,
      1.241144,
      1,
      1.156228,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086965,
      NULL,
      NULL,
      4.293385,
      0,
      0.496421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.364064,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0.328327,
      0,
      4.583963,
      3.937266,
      0.335006,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.077681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.696597,
      3.960855,
      3.935266,
      1,
      NULL,
      NULL,
      3.506006,
      0,
      NULL,
      NULL,
      0,
      7.564606,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.658341,
      3.196885,
      2,
      1.495604,
      2.593484,
      NULL,
      0.264106,
      0.916504,
      6,
      9,
      1.569703,
      NULL,
      2.520274,
      1.705782,
      1.769196,
      NULL,
      3.930270,
      3,
      2,
      NULL,
      0,
      0.794693,
      7,
      2,
      NULL,
      NULL,
      5,
      7,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.288409,
      NULL,
      0.735304,
      NULL,
      NULL,
      1.050416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842331,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645813,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772632,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2.573440,
      0.131629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.911523,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.590442,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723320,
      NULL,
      NULL,
      NULL,
      1.461786,
      2.003030,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.872080,
      NULL,
      NULL,
      0.851929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626996,
      NULL,
      NULL,
      7127.962413,
      197,
      1.005199,
      NULL,
      0,
      NULL,
      0.824178,
      0,
      1,
      1.455658,
      1.287329,
      1,
      1,
      1.215274,
      1,
      0.576981,
      1.973049,
      1,
      0.603499,
      0.032424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3.325347,
      NULL,
      1.529003,
      0,
      2,
      9.636535,
      3,
      3.886915,
      1.982320,
      1,
      0.172367,
      NULL,
      NULL,
      1.335251,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.541682,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.661006,
      NULL,
      1.686672,
      0.188283,
      NULL,
      0.910500,
      NULL,
      NULL,
      0.256749,
      0.951778,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.234396,
      NULL,
      1.984645,
      NULL,
      4,
      NULL,
      NULL,
      0.694689,
      NULL,
      NULL,
      NULL,
      53.459046,
      3,
      1,
      2,
      '41112',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.003558,
      '',
      '',
      NULL);
commit;
end;
/


