set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8827853';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      1.135305,
      0.303005,
      1.235749,
      0,
      0.685071,
      3.848461,
      '430',
      NULL,
      57,
      NULL,
      '0331234',
      0,
      1.712774,
      0,
      2,
      NULL,
      4.107740,
      0.454850,
      NULL,
      NULL,
      '10- 2-1994',
      175,
      16.679893,
      NULL,
      NULL,
      2,
      ' 5-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10- 5-1998',
      NULL,
      NULL,
      1.213673,
      1.138661,
      NULL,
      2,
      0.579702,
      1,
      0,
      1.768330,
      NULL,
      NULL,
      NULL,
      4,
      5.667257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.071368,
      1,
      1,
      1,
      1,
      1.498608,
      21,
      3,
      5,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      2,
      2,
      NULL,
      2,
      0,
      3.799746,
      0,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      1,
      0,
      0,
      0.486262,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      4,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      5,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      1.347422,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      4,
      5,
      0,
      1,
      5,
      NULL,
      0,
      1,
      4,
      1,
      0,
      1,
      5,
      0,
      4,
      2,
      2,
      0,
      5,
      4,
      2,
      2.741055,
      ' 2-14-1979',
      313,
      ' 9-29-1996',
      18,
      1,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.683728,
      0.312255,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.378692,
      NULL,
      NULL,
      2.223514,
      0,
      1.271519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1.149787,
      1,
      8.572015,
      NULL,
      1.156984,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974055,
      3,
      3,
      3,
      1,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      1,
      0.495678,
      NULL,
      NULL,
      0,
      1.234863,
      0.926292,
      1.563033,
      1,
      0,
      0.231334,
      NULL,
      0,
      0,
      1.184570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.329685,
      NULL,
      0.817594,
      4,
      0.683288,
      4.827897,
      0.939742,
      2,
      3,
      2,
      0.577619,
      5.954583,
      3,
      0.846324,
      64,
      NULL,
      19,
      15.764383,
      5,
      5,
      NULL,
      '14322',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      73,
      2,
      2.551287,
      5,
      4.295827,
      3,
      NULL,
      0.111240,
      NULL,
      NULL,
      1.359796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656263,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.854391,
      NULL,
      NULL,
      0.781480,
      NULL,
      NULL,
      0.555018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.071261,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.995965,
      NULL,
      NULL,
      1.498583,
      NULL,
      NULL,
      0.579869,
      NULL,
      NULL,
      0.897887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.207898,
      2.432413,
      NULL,
      NULL,
      0.220629,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013013,
      3,
      1,
      NULL,
      6,
      6.229388,
      1,
      3,
      1,
      1,
      2.615084,
      NULL,
      1,
      0.551082,
      0.198655,
      NULL,
      3.893547,
      1.660226,
      2,
      3,
      5,
      1.777327,
      5,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.551486,
      NULL,
      1.940654,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.662779,
      0.576513,
      1,
      NULL,
      0,
      1.566493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152469,
      NULL,
      NULL,
      NULL,
      0.079168,
      7,
      3,
      3.006387,
      9.422202,
      2,
      1,
      NULL,
      NULL,
      1.118018,
      NULL,
      NULL,
      1.178759,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      120.518976,
      0.506320,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      1,
      3,
      0,
      2,
      1.971370,
      1.715109,
      0,
      1,
      0,
      1.003724,
      NULL,
      1.971212,
      NULL,
      2,
      NULL,
      1.266983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      32.930310,
      0,
      NULL,
      3.698627,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.963602,
      NULL,
      0.772653,
      NULL,
      0.107951,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.337201,
      NULL,
      0.380916,
      NULL,
      NULL,
      0.329650,
      1.428756,
      1.700888,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070916,
      NULL,
      0,
      0,
      0.071187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974900,
      NULL,
      1.096526,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.266784,
      NULL,
      3,
      NULL,
      0.288427,
      NULL,
      NULL,
      NULL,
      0.250464,
      NULL,
      0.347776,
      0.186752,
      3.838286,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.757738,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.919061,
      NULL,
      NULL,
      1.703650,
      2,
      4.516906,
      6.694359,
      0,
      3,
      2.182781,
      1.979266,
      1,
      1,
      0,
      3.241423,
      0,
      0.955655,
      3.916819,
      2,
      3.376738,
      3.163198,
      1,
      NULL,
      NULL,
      0.374998,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.699841,
      0,
      NULL,
      0.623717,
      1.665463,
      NULL,
      1.286739,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.659438,
      1.804202,
      NULL,
      1.608946,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474377,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.765825,
      NULL,
      NULL,
      NULL,
      142.255966,
      1,
      4,
      3,
      '10400',
      '03122',
      '03342',
      1,
      '',
      '',
      '',
      3.726008,
      '1040',
      '',
      '');
commit;
end;
/


