set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      2.614217,
      5.260393,
      NULL,
      NULL,
      1.301971,
      NULL,
      1.188605,
      '130',
      '11022232',
      64,
      NULL,
      '2220104',
      0.382318,
      0.800243,
      2,
      1,
      '2031',
      2,
      0.230023,
      NULL,
      NULL,
      ' 2-17-1994',
      31,
      NULL,
      NULL,
      3,
      3,
      ' 3-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-1977',
      ' 0- 9-1999',
      ' 7-18-1978',
      3,
      2.250158,
      NULL,
      2,
      0,
      1.801229,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.580330,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.960976,
      0,
      0,
      NULL,
      NULL,
      1.305973,
      1.665939,
      NULL,
      0,
      NULL,
      1,
      4,
      2,
      0,
      0,
      0,
      0,
      3,
      0,
      NULL,
      0,
      5,
      1,
      2,
      NULL,
      NULL,
      1,
      8,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.001600,
      1,
      0.736102,
      1,
      NULL,
      0,
      2,
      1,
      2,
      2,
      NULL,
      1,
      NULL,
      0,
      1.151156,
      1,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      0,
      NULL,
      4,
      0,
      0,
      1,
      1,
      0,
      0,
      3,
      0,
      0,
      NULL,
      0,
      1.787924,
      NULL,
      NULL,
      1,
      3,
      5,
      2,
      NULL,
      2,
      NULL,
      4,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      4,
      4,
      0,
      5,
      5,
      5,
      3,
      1,
      1,
      1,
      NULL,
      4.030431,
      2.341221,
      ' 8- 1-1979',
      476,
      '11-16-1985',
      128,
      3.156955,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      0.279242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.274331,
      1,
      NULL,
      NULL,
      NULL,
      1.026929,
      5.271966,
      3,
      1,
      2,
      4.582346,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.396203,
      0,
      0,
      NULL,
      0,
      0.298763,
      NULL,
      NULL,
      29,
      NULL,
      1.665123,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      NULL,
      1,
      2,
      3,
      2,
      1,
      2.255474,
      2.913709,
      NULL,
      NULL,
      NULL,
      NULL,
      3.837821,
      3.659851,
      1,
      1.588796,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      2.319491,
      6.520591,
      0,
      1,
      NULL,
      5.841866,
      NULL,
      6,
      NULL,
      3,
      0.026301,
      14,
      3,
      1.820292,
      55,
      NULL,
      60,
      14.189852,
      0,
      4.549692,
      0,
      '44020',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      1.261290,
      36.238353,
      22,
      12.362588,
      0,
      16,
      NULL,
      0,
      NULL,
      2.203445,
      1.468490,
      1.884346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.355100,
      1.112549,
      1,
      2.559156,
      NULL,
      1.851808,
      0,
      NULL,
      NULL,
      2.906608,
      0,
      NULL,
      1.753613,
      1.918261,
      3.213725,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.660192,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.284462,
      0,
      3,
      1.791310,
      2.475606,
      0,
      3,
      3.848567,
      2.128746,
      NULL,
      0.580919,
      0.231125,
      1,
      1.055498,
      3.302298,
      3,
      NULL,
      3,
      3,
      0,
      0.327582,
      1.712500,
      NULL,
      0.527374,
      1,
      3.980445,
      1,
      1,
      1.525513,
      NULL,
      NULL,
      NULL,
      NULL,
      3.828759,
      6,
      3,
      0.791228,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262034,
      NULL,
      NULL,
      NULL,
      0.762919,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0.269167,
      0.061669,
      NULL,
      NULL,
      2.314667,
      NULL,
      2.337141,
      0,
      NULL,
      NULL,
      1.216646,
      NULL,
      NULL,
      0.039859,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.377524,
      NULL,
      NULL,
      2.895238,
      1,
      3.918836,
      1.116261,
      NULL,
      2,
      NULL,
      NULL,
      6,
      5.501801,
      3.927460,
      NULL,
      1.847049,
      NULL,
      NULL,
      2.880686,
      0.244725,
      2.455825,
      2,
      NULL,
      2,
      0.340091,
      1.945513,
      3,
      NULL,
      0.854317,
      0.290727,
      1.855497,
      NULL,
      1,
      0.773154,
      2.598154,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      3,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      1.673422,
      1,
      0,
      0.082030,
      NULL,
      1.669089,
      1.391980,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389679,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.082407,
      NULL,
      NULL,
      0.877446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.637293,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1,
      0,
      0.784322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      150.316837,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.521991,
      NULL,
      NULL,
      NULL,
      0.591574,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.481551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871376,
      NULL,
      NULL,
      NULL,
      1.723280,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.102335,
      NULL,
      NULL,
      NULL,
      11.116891,
      NULL,
      NULL,
      NULL,
      0.338180,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888953,
      1,
      3.108472,
      6,
      1.381311,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.826092,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      143,
      NULL,
      1.341082,
      0.267344,
      0.835255,
      1.666830,
      0.824882,
      1,
      0,
      0.118502,
      0.989292,
      1.737379,
      NULL,
      0,
      NULL,
      0.609722,
      NULL,
      0.586986,
      0,
      1.101014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037017,
      0.859974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.417578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161592,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.289497,
      NULL,
      1.815132,
      NULL,
      0.119868,
      NULL,
      NULL,
      NULL,
      0.618289,
      NULL,
      1,
      NULL,
      1.074823,
      NULL,
      0,
      0.813133,
      1.791710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.364983,
      NULL,
      1.859008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508013,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      5,
      4,
      3.526035,
      NULL,
      11,
      3.525096,
      NULL,
      0.634094,
      1.647068,
      NULL,
      NULL,
      2.300922,
      2,
      NULL,
      2,
      2.934580,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.051272,
      NULL,
      3,
      1.136315,
      NULL,
      2.889568,
      2.673617,
      NULL,
      2,
      0.234686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      36,
      77.652184,
      2,
      3,
      NULL,
      '31044',
      '',
      '',
      1,
      '',
      '',
      '',
      0.435953,
      '3410',
      '',
      '');
commit;
end;
/


